/*$Id: Firekeeper.h,v 1.13 2006/08/20 16:39:54 jwrobel Exp $*/
/* ***** BEGIN LICENSE BLOCK *****
 *  This file is part of Firekeeper.
 *
 *  Copyright (C) 2006 Jan Wrobel <wrobel@blues.ath.cx>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License Version 2 as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * ***** END LICENSE BLOCK ***** */

#ifndef FIREKEEPER_H
#define FIREKEEPER_H

#include "nsCOMPtr.h"

#include "nsIObserver.h"

#include "fkIFirekeeper.h"
#include "fkHttpHandler.h"
#include "fkIJudge.h"
#include "fkIRule.h"
#include "RulesParser.h"

#define FIREKEEPER_CONTRACTID "@firekeeper.mozdev.org/firekeeper"
#define FKJUDGE_CONTRACTID "@firekeeper.mozdev.org/fkjudge"
#define IFIREKEEPER_CID_STR "eb2e6602-168f-4ff0-a378-c3c8c4214760"
#define FIREKEEPER_CID \
{0xeb2e6602, 0x168f, 0x4ff0, \
{0xa3, 0x78, 0xc3, 0xc8, 0xc4, 0x21, 0x47, 0x60}}

class Firekeeper : public fkIFirekeeper
                 , public nsIObserver
{
 public:
	NS_DECL_ISUPPORTS
	NS_DECL_NSIOBSERVER	
	NS_DECL_FKIFIREKEEPER

        Firekeeper();
	static Firekeeper *GetInstance(); 
 private:	
	~Firekeeper();
	fkHttpHandler *httpHandler;
	fkHttpHandler *httpsHandler;
	NS_IMETHODIMP init();
};


extern Rules *rules;
extern Firekeeper *firekeeper;
extern nsCOMPtr<fkIJudge> fkJudge;
extern const char *rulesOrder[];

/*TODO: more configurable*/
#define NACTIONS 3

#endif
