/*$Id: ActiveRuleSet.h,v 1.1 2006/08/20 16:39:04 jwrobel Exp $*/
/* ***** BEGIN LICENSE BLOCK *****
 *  This file is part of Firekeeper.
 *
 *  Copyright (C) 2006 Jan Wrobel <wrobel@blues.ath.cx>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License Version 2 as
 *  published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * ***** END LICENSE BLOCK ***** */

#ifndef ACTIVERULESSET_H
#define ACTIVERULESSET_H

#include "Rules.h"

class ActiveRuleSet
{
	friend int urlContentMatched(void *id, int index, void* ctx);
	friend int headersContentMatched(void *id, int index, void* ctx);
	friend int bodyContentMatched(void *id, int index, void* ctx);
	
 private:	
	RuleSet noContent;
	
	map<Rule *, set<PatternMatchData *> > urlMatchedParts;
	map<Rule *, set<PatternMatchData *> > headersMatchedParts;
	map<Rule *, set<PatternMatchData *> > bodyMatchedParts;
	
	RuleSet urlContentCorrect;
	RuleSet headersContentCorrect;
	RuleSet bodyContentCorrect;
	
	set<const Rule *> noMatch;
	set<const RE *> bodyMatchedREs;
	
	inline bool match(const RE &re_info, const char *s, int len);

	void checkUrlSet(set<Rule *> &rules, list<const Rule *> &result);
	
	void checkHeadersSet(set<Rule *> &rules, list<const Rule *> &result);

	void checkBodySet(set<Rule *> &rules, const char *body, int bodylen,
			  list<const Rule *> &result);
	/*used to inform that new rules are loaded 
	  and old shouldn't be used*/
	unsigned int rulesVersion;

	Rules *rules;
	
	char *headers, *url;
	int headerslen, urllen;
 public:
	ActiveRuleSet(Rules *initRules);
	~ActiveRuleSet();


	//void urlContentMatched(PatternMatchData *match);
	
	list<const Rule*> 
		checkURL(const char *url, int urllen);
	list<const Rule*> 
		checkHeaders(const char *headers, int headerslen);
	list<const Rule*> 
		checkBody(const char *body, int bodylen);

};

#endif
