/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is MacroTracker Bug Tracking System Source Code
 *
 * The Initial Developer of the Original Code is
 * R.J. Keller.
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */
package org.mozdev.MacroTracker.toolkit;

import javax.swing.*;
import javax.swing.event.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;

import com.trfenv.rlk.Debug;

/**
 *This is a class that inherits JPanel and holds a merger of a JList and
 *JComboBox. The actual element is a JList but the class contains methods
 *that allow you to modify elemenets like a JComboBox. You can also add
 *ActionListener's like a JComboBox.
 *
 *<p>This element is also already nested in a JScrollPane, so you will not
 *need that element for scrollbars.</p>
 *
 *@author R.J. Keller
 */
public class MComboBox extends JPanel implements ListSelectionListener
{
	private JList lstPanel;

	//this is the data model that holds the elements in the JList.
	private DefaultListModel mListItems;
	
	private LinkedList mActionListeners;
	
	public MComboBox()
	{
		super();
		
		mListItems = new DefaultListModel();
		mListItems.addElement("test");

		lstPanel = new JList(mListItems);
		lstPanel.setPrototypeCellValue("Index 1234567890");
		lstPanel.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
		lstPanel.setVisibleRowCount(3);	
		lstPanel.setSize(100, lstPanel.getHeight());
		mListItems.remove(0);
		
		mActionListeners = new LinkedList();

		//add this ListSelectionListener that goes through the ActionListener's
		//and executes each one appropriately.
		lstPanel.addListSelectionListener(this);
		
		lstPanel.setMaximumSize(new Dimension(5,5));

		setLayout(new GridLayout(1,1));
		add(new JScrollPane(lstPanel));

		Debug.createObject(this);
	}
	
	public void addActionListener(ActionListener listener)
	{
		mActionListeners.add(listener);
	}
	
	/**
	 *Adds an item to the list. If the item already exists in the list, it
	 *displays a message box telling the user to enter an new value.
	 *
	 *(precondition: item must not already be in the list)
	 *(postcondition: item is added to the list)
	 *@param item The item to add to the list if the item doesn't already exist.
	 */
	public void addItem(String item)
	{
		if (inList(item))
			JOptionPane.showMessageDialog(null, "This item is already in the list. Please enter a different item.");
		else
			mListItems.addElement(item);
	}
	
	public void removeItemAt(int aItem)
	{
		mListItems.remove(aItem);
	}
	
	public int getItemCount()
	{
		Object[] obj = mListItems.toArray();
		return obj.length;
	}
	
	public Object getItemAt(int aItem)
	{
		return mListItems.get(aItem);
	}
	
	public int getSelectedIndex()
	{
		return lstPanel.getSelectedIndex();
	}
	
	public void clear()
	{
		lstPanel.removeAll();
	}
	
	/**
	 *Returns whether or not the itemToCheckFor already exists in the list.
	 *@param itemToCheckFor The item to check whether or not it exists in the list.
	 */
	public boolean inList(String itemToCheckFor)
	{
		//Loop through all the elements. If the element is found, end the
		//function and return true.
		for (int i = 0; i < getItemCount(); i++)
		{
			if (((String)getItemAt(i)).equals(itemToCheckFor))
			{
				return true;
			}
		}
		
		//If the loop ended without hitting the return statement to end the
		//function, then the item must not exist in the list.
		return false;
	}
	
	/**
	 *Removes the item selected in the combo box.
	 */
	public void removeSelectedItem()
	{
		try
		{
			removeItemAt(getSelectedIndex());
		}
		catch (Exception ex)
		{
		}
	}
	
	public void valueChanged(ListSelectionEvent e)
	{
		ActionEvent event = new ActionEvent(this, 0, e.toString());
		for (Iterator i = mActionListeners.iterator(); i.hasNext(); )
		{
			ActionListener listeners = (ActionListener)i.next();
			listeners.actionPerformed(event);
		}
	}
}