/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is MacroTracker Bug Tracking System Source Code
 *
 * The Initial Developer of the Original Code is
 * R.J. Keller.
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */
package org.mozdev.MacroTracker.ui;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import org.mozdev.MacroTracker.ui.frmBug;
import org.mozdev.MacroTracker.classes.PanelMenuBar;

import com.trfenv.rlk.Debug;

/**
 *GUI element that makes a desktop where multiple Bug's can be viewed.
 *
 *The form also supports other JPanel's from being added.
 */
public class BugDesktop extends JFrame implements ActionListener
{
	private JDesktopPane desktop;

	private JMenuItem mnuFileNew;

	public BugDesktop()
	{
		super("MacroTracker Bugs");

		setSize(600,600);

		JMenuBar mnuBar = new JMenuBar();
		setJMenuBar(mnuBar);

		JMenu mnuFile = new JMenu("File");
		mnuBar.add(mnuFile);

		mnuFileNew = new JMenuItem("New");
		mnuFile.add(mnuFileNew);
		mnuFileNew.addActionListener(this);

		desktop = new JDesktopPane();
		desktop.setBackground(Color.LIGHT_GRAY);
		getContentPane().add(desktop);

		Debug.createObject(this);
	}

	public void actionPerformed(ActionEvent event)
	{
		addDesktopItem(new frmBug(), "Bug X");
	}

	/**
	 *Adds the item to the desktop.
	 *@param comp The JPanel to add (which includes a menubar)
	 *@param frameTitle The title to display in the frame.
	 */
	public void addDesktopItem(PanelMenuBar comp, String frameTitle)
	{
		JInternalFrame newFrame = new JInternalFrame(frameTitle, true, true, true, true);

		setJMenuBar(comp.getMenuBar(this));
		newFrame.getContentPane().add(comp);

		newFrame.pack();

		desktop.add(newFrame);
		newFrame.setSize(425, 400);
		newFrame.setVisible(true);
	}
	
	public static void main(String[] arcs)
	{
		BugDesktop desktop = new BugDesktop();
		desktop.setVisible(true);
		desktop.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
	}
}