# ***** BEGIN LICENSE BLOCK *****
# Version: MPL 1.1/GPL 2.0/LGPL 2.1
#
# The contents of this file are subject to the Mozilla Public License Version
# 1.1 (the "License"); you may not use this file except in compliance with
# the License. You may obtain a copy of the License at
# http://www.mozilla.org/MPL/
#
# Software distributed under the License is distributed on an "AS IS" basis,
# WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
# for the specific language governing rights and limitations under the
# License.
#
# The Original Code is MacroTracker Bug Tracking System.
#
# The Initial Developer of the Original Code is
# R.J. Keller.
# Portions created by the Initial Developer are Copyright (C) 2003
# the Initial Developer. All Rights Reserved.
#
# Contributor(s):
#
# Alternatively, the contents of this file may be used under the terms of
# either the GNU General Public License Version 2 or later (the "GPL"), or
# the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
# in which case the provisions of the GPL or the LGPL are applicable instead
# of those above. If you wish to allow use of your version of this file only
# under the terms of either the GPL or the LGPL, and not to allow others to
# use your version of this file under the terms of the MPL, indicate your
# decision by deleting the provisions above and replace them with the notice
# and other provisions required by the GPL or the LGPL. If you do not delete
# the provisions above, a recipient may use your version of this file under
# the terms of any one of the MPL, the GPL or the LGPL.
#
# ***** END LICENSE BLOCK *****

# Java Preprocessor compilation script
# by R.J. Keller <rlk@trfenv.com>
#
# Create a Makefile with a SRCS variable pointing to all of the files to
# comile.
#
# make build - Builds you application.
# make doc - Builds JavaDoc information for your application
# make run - Runs you application. This requires you set the APPLICATION_STARTUP_CLASS variable
#
# Do NOT run any of the other functions in this script. They may delete 
# all of your *.java files if you do!

JAVAC   = javac
JAVA    = java
JAVADOC = javadoc
JAVADOCDIR = ../doc

APPLICATION_STARTUP_CLASS = org.mozdev.MacroTracker.main.MacroTracker

# these are the default applications to run in this script. If you do not have
# these applications, make sure you install the appropriate app to set these vars
# to an alternative.
MAKE	= make
CP	= cp
RM	= rm

build::
ifdef SRCS
	$(JAVAC) $(SRCS) -d $(TOPDIR)
endif
ifdef DIRS
	@for dir in $(DIRS); do	\
		$(MAKE) -C $$dir;	\
	done
endif

run::
	$(JAVA) $(APPLICATION_STARTUP_CLASS)
