/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.dom;

import org.mozilla.dom.NodeFactory;
import org.mozilla.xpcom.nsIDOMDocument;
import org.mozilla.xpcom.nsIDOMHTMLFrameElement;
import org.mozilla.xpcom.nsIDOMHTMLIFrameElement;
import org.mozilla.xpcom.nsIDOMNode;
import org.w3c.dom.Document;

public class SharedUtils {
    public static boolean isFrameNode(nsIDOMNode moz) {
        if (moz == null) {
            return false;
        }
        String name = moz.getNodeName();
        return name.equalsIgnoreCase("frame") || name.equalsIgnoreCase("iframe");
    }

    public static boolean isHTMLNode(nsIDOMNode moz) {
        if (moz == null) {
            return false;
        }
        String name = moz.getNodeName();
        return name.equalsIgnoreCase("html");
    }

    public static Document frameNodeToDocument(nsIDOMNode moz) {
        String name = moz.getNodeName();
        if (name.equalsIgnoreCase("frame")) {
            nsIDOMHTMLFrameElement nsfn = (nsIDOMHTMLFrameElement)moz.queryInterface("{a6cf90b9-15b3-11d2-932e-00805f8add32}");
            nsIDOMDocument nsdoc = nsfn.getContentDocument();
            return (Document)NodeFactory.getNodeInstance((nsIDOMNode)nsdoc);
        }
        if (name.equalsIgnoreCase("iframe")) {
            nsIDOMHTMLIFrameElement nsfn = (nsIDOMHTMLIFrameElement)moz.queryInterface("{a6cf90ba-15b3-11d2-932e-00805f8add32}");
            nsIDOMDocument nsdoc = nsfn.getContentDocument();
            return (Document)NodeFactory.getNodeInstance((nsIDOMNode)nsdoc);
        }
        return null;
    }
}

