/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.dom.html;

import java.util.concurrent.Callable;
import org.mozilla.dom.NodeFactory;
import org.mozilla.dom.ThreadProxy;
import org.mozilla.dom.WeakValueHashMap;
import org.mozilla.interfaces.nsIDOMHTMLCollection;
import org.mozilla.interfaces.nsIDOMNode;
import org.mozilla.interfaces.nsISupports;
import org.w3c.dom.Node;
import org.w3c.dom.html.HTMLCollection;

public class HTMLCollectionImpl
implements HTMLCollection {
    protected nsISupports moz;
    protected static WeakValueHashMap instances = new WeakValueHashMap();

    public nsIDOMHTMLCollection getInstance() {
        return this.getInstanceAsnsIDOMHTMLCollection();
    }

    protected HTMLCollectionImpl(nsISupports mozInst) {
        this.moz = mozInst;
        instances.put(mozInst, this);
    }

    public HTMLCollectionImpl(nsIDOMHTMLCollection mozInst) {
        this((nsISupports)mozInst);
    }

    public static HTMLCollectionImpl getDOMInstance(nsIDOMHTMLCollection mozInst) {
        HTMLCollectionImpl node = (HTMLCollectionImpl)instances.get(mozInst);
        return node == null ? new HTMLCollectionImpl(mozInst) : node;
    }

    public nsIDOMHTMLCollection getInstanceAsnsIDOMHTMLCollection() {
        if (this.moz == null) {
            return null;
        }
        return (nsIDOMHTMLCollection)this.moz.queryInterface("{a6cf9083-15b3-11d2-932e-00805f8add32}");
    }

    public int getLength() {
        Callable<Integer> c = new Callable<Integer>(){

            @Override
            public Integer call() {
                long result = HTMLCollectionImpl.this.getInstanceAsnsIDOMHTMLCollection().getLength();
                return (int)result;
            }
        };
        return ThreadProxy.getSingleton().syncExec(c);
    }

    public Node namedItem(final String name) {
        Callable<Node> c = new Callable<Node>(){

            @Override
            public Node call() {
                nsIDOMNode result = HTMLCollectionImpl.this.getInstanceAsnsIDOMHTMLCollection().namedItem(name);
                return NodeFactory.getNodeInstance(result);
            }
        };
        return ThreadProxy.getSingleton().syncExec(c);
    }

    public Node item(final int index) {
        Callable<Node> c = new Callable<Node>(){

            @Override
            public Node call() {
                nsIDOMNode result = HTMLCollectionImpl.this.getInstanceAsnsIDOMHTMLCollection().item((long)index);
                return NodeFactory.getNodeInstance(result);
            }
        };
        return ThreadProxy.getSingleton().syncExec(c);
    }
}

