
namespace CoreSync
{
	public ref class Field : System::Object
	{
	public:
		static const int BOOL=CEVT_BOOL;
		static const int SHORT=CEVT_I2;
		static const int INT=CEVT_I4;
		static const int DOUBLE=CEVT_R8;
		static const int USHORT=CEVT_UI2;
		static const int UINT=CEVT_UI4;
		static const int STRING=CEVT_LPWSTR;
		static const int DATETIME=CEVT_FILETIME;
	private:
		int pvt_iID;
		int pvt_iType;
		System::String ^pvt_sValue;
		int pvt_iValue;
		double pvt_dValue;
		bool pvt_bValue;
		System::DateTime pvt_dtValue;
	public:
		Field();
		Field(Object ^oValue);
		~Field();

		int getID();
		void setID(int iID);

		int getType();
		void setType(int iType);

		System::Object ^getValue();
		void setValue(Object ^oObject);

		System::String ^getStringValue();
		void setStringValue(System::String ^oString);
		short getShortValue();
		void setShortValue(short wValue);
		unsigned short getUShortValue();
		void setUShortValue(unsigned short wValue);
		int getIntValue();
		void setIntValue(int dwValue);
		double getDoubleValue();
		void setDoubleValue(double dblValue);
		unsigned int getUIntValue();
		void setUIntValue(unsigned int uiValue);
		bool getBoolValue();
		void setBoolValue(bool bValue);
		System::DateTime getDateValue();
		void setDateValue(System::DateTime dtValue);
	};

	public ref class Record : System::Object
	{
		//Should be an unsorted collection of fields.
	private:
		System::Collections::ArrayList ^pvt_oFields;
		int pvt_iOID;
	public:
		Record();
		~Record();

		int getOID();
		void setOID(int iOID);
		Field ^getFieldByID(int iID);
		Field ^getField(int iField);
		void addField(Field ^oField);
		void removeField(int iField);
		int getFieldCount();
	};

	public ref class Database : System::Object
	{
	private:
		HANDLE pvt_hDBHandle;
		System::String ^pvt_sName;
		CEOID pvt_iOID;
	public:
		Database(HANDLE hDB, CEOID oid);
		~Database();

		System::String ^getName();
		void setName(System::String ^sName);

		Record ^getRecord(int iRecord);
		bool addRecord(Record ^oRecord);
		bool removeRecord(int iRecord);
		int getRecordCount();
	};
}
