using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace SmartSync
{
    public partial class frmSyncProgress : Form
    {
        progress pg=null;
        public frmSyncProgress()
        {
            InitializeComponent();
        }

        private void frmSyncProgress_Load(object sender, EventArgs e)
        {
            string[] args = Environment.GetCommandLineArgs();
            for (int i = 0; i < args.Length; i++)
            {
                if (args[i] == "-reset")
                {
                    Logger.AddEntry(Logger.NOTIFY, "frmSyncProgress", "'-reset' switch found. Reset will be performed.");
                    String appDir = AppSettings.getAppDir();
                    string[] fls=System.IO.Directory.GetFiles(appDir, "*.xml");
                    for (int c = 0; c < fls.Length; c++)
                        System.IO.File.Delete(fls[c]);
                    Logger.AddEntry(Logger.NOTIFY, "frmSyncProgress", "Reset performed.");
                    MessageBox.Show("Synchronization engine reset performed.");
                    this.Close();
                    return;
                }

                if (args[i] == "-auto")
                {
                    Logger.AddEntry(Logger.NOTIFY, "frmSyncProgress", "'-auto' switch found. Synchronization will start automatically.");
                    btnStart.Enabled = false;
                    System.Timers.Timer tmr = new System.Timers.Timer(1000);
                    tmr.Elapsed += new System.Timers.ElapsedEventHandler(tmr_Elapsed);
                    tmr.Enabled = true;
                }

                if (args[i] == "-createfolders")
                {
                    Logger.AddEntry(Logger.NOTIFY, "frmSyncProgress", "'-createfolders' switch found. SmartSync will create directories and exit.");
                    AppSettings.getAppDir();
                    Logger.AddEntry(Logger.NOTIFY, "frmSyncProgress", "Directories have been created.");
                    this.Close();
                    return;
                }

                if (args[i] == "-loglevel")
                {
                    i++;
                    int iLevel = 0;
                    try
                    {
                        iLevel = System.Convert.ToInt32(args[i]);
                    }
                    catch(Exception ex)
                    {
                        iLevel = 0;
                    }
                    Logger.AddEntry(Logger.NOTIFY, "frmSyncProgress.frmSyncProgress_Load", "Log level set to " + System.Convert.ToString(iLevel));
                    Logger.SetLogLevel(iLevel);
                }
            }
        }

        void tmr_Elapsed(object sender, System.Timers.ElapsedEventArgs e)
        {
            System.Timers.Timer tmr = (System.Timers.Timer)sender;
            tmr.Enabled = false;
            btnStart_Click(null, null);
        }

        private bool closeAtEnd()
        {
            string[] args = Environment.GetCommandLineArgs();
            for (int i = 0; i < args.Length; i++)
            {
                if (args[i] == "-autoclose")
                    return true;
            }
            return false;
        }

        private void btnStart_Click(object sender, EventArgs e)
        {
            Logger.AddEntry(Logger.USERACTION, "frmSyncProgress.btnStart", "User chose to start synchronization. Executing.");
            btnStart.Enabled = false;
            pg = new progress(this);
            Synchronizer engine = new Synchronizer();
            engine.Synchronize(pg);
            btnStart.Enabled = true;
            btnCancel.Enabled = true;
            Logger.AddEntry(Logger.USERACTION, "frmSyncProgress.btnStart", "Synchronization done.");
            if (closeAtEnd() == true)
            {
                Logger.AddEntry(Logger.NOTIFY, "frmSyncProgress.btnStart", "'-autoclose' command-line switch found. Closing automatically.");
                this.Close();
            }
        }

        private void btnCancel_Click(object sender, EventArgs e)
        {
            Logger.AddEntry(Logger.USERACTION, "frmSyncProgress.btnStart", "User chose to cancel synchronization. Executing.");
            this.Close();
        }
    }

    public class progress
    {
        private frmSyncProgress pvt_frm;
        private bool cancel = false;
        public progress(frmSyncProgress frm)
        {
            pvt_frm = frm;
        }
        public void setStep(int iStep)
        {
            if(pvt_frm.pgbSync.Maximum>=iStep)
                pvt_frm.pgbSync.Value = iStep;
            Font bold = new Font(FontFamily.GenericSansSerif, 8.25f, FontStyle.Bold);
            Font normal = new Font(FontFamily.GenericSansSerif, 8.25f, FontStyle.Regular);
            switch (iStep)
            {
                case 1:
                    pvt_frm.lblStep1.Font = bold;
                    break;
                case 2:
                    pvt_frm.lblStep1.Font = normal;
                    pvt_frm.lblStep1.ForeColor = Color.DarkGray;
                    pvt_frm.lblStep2.Font = bold;
                    break;
                case 3:
                    pvt_frm.lblStep2.Font = normal;
                    pvt_frm.lblStep2.ForeColor = Color.DarkGray;
                    pvt_frm.lblStep3.Font = bold;
                    break;
                case 4:
                    pvt_frm.btnCancel.Enabled = false;
                    pvt_frm.lblStep3.Font = normal;
                    pvt_frm.lblStep3.ForeColor = Color.DarkGray;
                    pvt_frm.lblStep4.Font = bold;
                    break;
                case 5:
                    pvt_frm.btnCancel.Enabled = false;
                    pvt_frm.lblStep4.Font = normal;
                    pvt_frm.lblStep4.ForeColor = Color.DarkGray;
                    pvt_frm.lblStep5.Font = bold;
                    break;
                case 6:
                    pvt_frm.btnCancel.Enabled = false;
                    pvt_frm.lblStep5.Font = normal;
                    pvt_frm.lblStep5.ForeColor = Color.DarkGray;
                    pvt_frm.lblStep6.Font = bold;
                    break;
                case 7:
                    pvt_frm.btnCancel.Enabled = false;
                    pvt_frm.lblStep6.Font = normal;
                    pvt_frm.lblStep6.ForeColor = Color.DarkGray;
                    pvt_frm.lblStep7.Font = bold;
                    break;
                case 8:
                    pvt_frm.btnCancel.Enabled = true;
                    pvt_frm.lblStep1.Font = normal;
                    pvt_frm.lblStep1.ForeColor = Color.Black;
                    pvt_frm.lblStep2.Font = normal;
                    pvt_frm.lblStep2.ForeColor = Color.Black;
                    pvt_frm.lblStep3.Font = normal;
                    pvt_frm.lblStep3.ForeColor = Color.Black;
                    pvt_frm.lblStep4.Font = normal;
                    pvt_frm.lblStep4.ForeColor = Color.Black;
                    pvt_frm.lblStep5.Font = normal;
                    pvt_frm.lblStep5.ForeColor = Color.Black;
                    pvt_frm.lblStep6.Font = normal;
                    pvt_frm.lblStep6.ForeColor = Color.Black;
                    pvt_frm.lblStep7.Font = normal;
                    pvt_frm.lblStep7.ForeColor = Color.Black;
                    break;
            }
            Application.DoEvents();
        }
        public void disableCancel()
        {
            pvt_frm.btnCancel.Enabled = false;
        }
        public bool cancelling()
        {
            return cancel;
        }
        public void doCancel()
        {
            cancel = true;
        }
    }
}