/* vim: set sw=8 ts=8 si et: */
#ifndef H_NTC
#define H_NTC 1

/* exported from the ntc_convert.c: */
double r2temperature(double ohm, int inout);
double c2f(double c);
double adc_2_ohm_iref(int adc_value);
double adc_2_ohm_avcc(int adc_value);

/* Note on calibration: many household thermometers are much worse than
* a not calibrated version of this thermometer. You many do more damage than
* good if you change too much here
*/

/* all calibrations should be done here if needed. Normally you will
* only compensate the variance in the value of the 10k resistor and
* the 4.7k NTC. The 78L05 has also influence. This all can be adjusted
* changing NTC_RNx a bit (see below). There is no need to change the NTC_B value
* unless you use a different manufacture. If you order the parts from
* shop.tuxgraphics.org then the NTC_B value as shown below is correct.
*/

/* NTC temperature constant "B"-value: 3977K +/- 1% */
#define NTC_Bi 3977
/* 4.7 kOhm at 25 degree celsius */
#define NTC_TNi 25  
/* 4.7 kOhm +/- 10%, change for calibration: */
#define NTC_RNi 4740 

/* NTC temperature constant "B"-value: 3977K +/- 1% */
#define NTC_Bo 3977
/* 4.7 kOhm at 25 degree celsius */
#define NTC_TNo 25  
/* 4.7 kOhm +/- 10%, change for calibration: */
#define NTC_RNo 4720 
#endif

