/*********************************************
* vim: set sw=8 ts=8 si :
* Author: Guido Socher, Copyright: GPL 
* This program is to test the led connected to
* PC5 and to display a string on the LCD
* See http://linuxfocus.org/English/November2002/
* for details.
* Chip type           : AT90S4433
* Clock frequency     : 4,00 MHz
*********************************************/
#include <avr/io.h>
#include <avr/pgmspace.h>
#include <avr/interrupt.h>
#include <string.h>
#include <stdlib.h>
#include <avr/signal.h>
#include "lcd.h" 
#include "avr-util.h" 
#include "uart.h"


#define reply_ok() uart_sendstr_P("ok\n")
#define reply_err() uart_sendstr_P("err\n")


void main(void)
{
	/* initialize display, cursor off */
	lcd_init(LCD_DISP_ON);

	/* initialize rs232 */
	uart_init();

	/* enable  PC5 as output */
	sbi(DDRC,PC5);
	/* PD7 input */
	sei(); /* enable interrupt */
	lcd_puts_P("Hello");
	while (1) {
		/* blink led */
		cbi(PORTC,PC5);
		delay_ms(500);
		/* set output to 5V, LED off */
		sbi(PORTC,PC5);
		delay_ms(500);
		/* write ok on rs232 */
		reply_ok();
	}
}

