#include <math.h>
#include <stdio.h>





#include "calcfloat.h"

#include "stack.h"
#include "memory.h"

#define NOEXTERN

#include "progmem.h"
#include "hpglobals.h"
#include "input.h"


/* A short subroutine to append a single character to a string */
void append_char(char *string, char c)
{
  int len = strlen(string);
  string[len] = c;
  string[len+1] = 0;
}


Stack<CalcFloat> fltstack;


/* This function has to be here to avoid linkage errors. It seems
 * that, since the only manifestations of the Stack<CalcFloat> and
 * HashTable<CalcFloat> classes are in global variables, somehow the
 * destructors defined in the templates are not compiled in. */
int dummy(void)
{
  Stack<CalcFloat> a;
  HashTable<CalcFloat> b;
  return 0;
}
  

#define INBUFFSIZE 2000   /* Should be big enough */

/* The main loop is here */
int main(int argc, char **argv)
{

  CursesIO *dino; /* dino - Data IN Out? No, a left over variable name
		   * from when fred, barney, wilma, and betty were all
		   * used. */
  char buffer[INBUFFSIZE + 1];
  CalcProgMem memory; /* The input will first be parsed into a program
		       * step object, then that object called upon to
		       * do whatever the input required. */
  int i;
  int pnum;
  sp_acts result;
  input_codes res_input;
  int diskinput = 0;
  int userbreak;
  KeyInfo const **caps; /* Keycaps are kept here */


  noexit = 0;
  preload = NULL;
  ignorerc = 0;

  if (argc > 0 &&
      argv[0][0] != 0) {       /* Just in case.... */

    parse_options(argc, argv);
  
    if (preload == NULL &&
	!ignorerc) {  /* No command line argument to preload a function */
      preload = get_environment_preload();
      if (preload == NULL)
	preload = get_rcfile_preload();
    }

    if (preload != NULL) {  /* We have a preload function to grab */
      inputstream = fopen(preload, "r");
      if (inputstream != NULL) { /* Success */
	diskinput = 1;
	runmode = ENTER_PROG;
      }    
    }
  }

/* Set the initial defaults */
  dispdigs = 2;
  angmode = DEG;
  dispmode = FIX;

/* The memory element for parsed input does not belong to any
 * particular program space. */ 
  memory.myspace = NULL;

/* Count the keys */
  int ncaps = sizeof(allkeys) / sizeof(allkeys[0]);

/* The KeyType class elements are unusable until the keys_complete
 * static function has been called. */
  KeyType::keys_complete(allkeys);

/* The IO methods will want to know what the names of the keycaps are,
 * and how many there are. This creates a set of pointers to the
 * keycaps which can then be sent on to the relevent IO method. */
  caps = (KeyInfo const **) malloc(ncaps * sizeof(KeyInfo const *));
  CHKMEM(caps);
  for (i = 0; i < ncaps; i++)
    caps[i] = &allkeys[i]->keycap;

/* Create the curses interface */
  dino = new CursesIO(caps, ncaps);

/* Some operations need scratch space. If the data types are ever
 * generalized, this construction allows the scratch space elements to
 * be used for the new data types, too. */
  for (i = 0; i < NUMSCRATCHSPACES; i++)
    scratchspace[i] = new CalcFloat;
  angscratch = new CalcFloat;

  do {

/* No screen output while collecting programs and instructions from a 
 * disk file */
    if (!diskinput) {
      CalcProgMem const *perform = program.get_currentcell_ptr(&pnum);
      dino->show_appropriate_thing(runmode, fltstack, perform, pnum);
    }

/* If getting input from disk, just read the next line */
    if (diskinput) {

      if (fgets(buffer, INBUFFSIZE, inputstream) == NULL) {  /* EOF or error */
	fclose(inputstream);
	diskinput = 0;
	runmode = IMMED;  /* Shut down the disk read, return to immediate mode */
	continue;
      }
      if (buffer[strlen(buffer) - 1] == '\n')
	buffer[strlen(buffer) - 1] = 0;   // strip the EOL character

      res_input = TEXTINPUT;  /* The special actions, like advancing the program counter or deleting an input line, can never be performed by disk input */

    } else {
      if (runmode == STEPPING) runmode = IMMED;  // change back to IMMED
      
      if (runmode == IMMED || runmode == ENTER_PROG) {  // getting instructions from keyboard
	res_input = dino->get_input_line(buffer, INBUFFSIZE);
	if (runmode == IMMED && res_input == ENDOFINPUT) {
	  if (noexit) beep();
	  else break;  // quit
	}
	if (res_input == REDRAW) {
	  delete dino;
	  dino = new CursesIO(caps, ncaps);  // the easiest way to redraw the screen if it's been resized
	  continue;
	}
      } else 
	res_input = TEXTINPUT;  // a dummy value for running programs
    }


    switch (runmode) {
    case IMMED:
      (void) KeyType::parse_command(buffer, memory);  // put input into a memory element
      if (memory.validcell) {  // if that worked, act on it
	result = memory.do_step();

	if (result == TAKE_A_STEP) {  // the user asked for "step"
	  result = program.take_a_step(); // run the program in memory
	  if (result == SKIP_NEXT) ++program;  // skip the next step if necessary
	} else if (result == ERROR) {
	  diskinput = 0;
	  beep();
	} else if (result == GET_DISK_INPUT && !diskinput) {
	  diskinput = 1;
	  runmode = ENTER_PROG;   // Disk input always starts with programming
	} else if (result == WRITE_PROGRAM && !diskinput) {
	  program.writeoutput(outputstream);
	  fclose(outputstream);
	} else if (result == WRITE_MEMORY && !diskinput) {
	  memories.writeoutput(outputstream);
	  fclose(outputstream);
	}
      } else {
	diskinput = 0;
	beep();
      }
      break;
    case ENTER_PROG:
      switch (res_input) {
      case NEXTLINE:  // down arrow, advance the program counter
	++program;
	break;
      case PREVLINE: // up arrow, move back the PC
	--program;
	break;
      case DELETELINE: // delete key, kill cell under the PC
	program.delete_current_cell();
	break;
      case ENDOFINPUT: // CTRL-D, return to immediate mode
	strcpy(buffer, IMMEDMODE);  // Fall through to the next stage
      default:
	if (KeyType::parse_command(buffer, memory) == EXECUTE_NOW) {
	  memory.do_step();
	} else if (memory.validcell) {
	  program.insert_cell(memory);
	} else {
	  diskinput = 0;
	  beep();
	}
      }
      break;

    case RUN_PROG:  // loop over program elements until program ends or a key is pressed
      while (runmode == RUN_PROG &&
	     !(userbreak = dino->break_run()))
	if ((result = program.take_a_step()) == ERROR) {
	  diskinput = 0;
	  beep();
	  runmode = IMMED;
	} else if (result == SKIP_NEXT) {
	  ++program;
	}

      if (userbreak) {
	runmode = STEPPING;
      } else {
	runmode = IMMED;
      }
      break;
    case STEPPING:
      fprintf(stderr, "Shouldn't happen.\n");
      abort();
      break;
    }
    
  } while (1);

  for (i = 0; i < ncaps; i++)
    delete allkeys[i];

  free(caps);
  delete dino;
  return EXIT_SUCCESS;
}

