/*
 * KubeVirt API
 * This is KubeVirt API an add-on for Kubernetes.
 *
 * OpenAPI spec version: 1.0.0
 * Contact: kubevirt-dev@googlegroups.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package kubevirt.io;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import kubevirt.io.V1ClockOffsetTimezone;
import kubevirt.io.V1ClockOffsetUTC;
import kubevirt.io.V1Timer;

/**
 * Represents the clock and timers of a vmi.
 */
@ApiModel(description = "Represents the clock and timers of a vmi.")
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2019-11-10T14:44:51.030+02:00")
public class V1Clock {
  @SerializedName("timer")
  private V1Timer timer = null;

  @SerializedName("timezone")
  private V1ClockOffsetTimezone timezone = null;

  @SerializedName("utc")
  private V1ClockOffsetUTC utc = null;

  public V1Clock timer(V1Timer timer) {
    this.timer = timer;
    return this;
  }

   /**
   * Timer specifies whih timers are attached to the vmi.
   * @return timer
  **/
  @ApiModelProperty(required = true, value = "Timer specifies whih timers are attached to the vmi.")
  public V1Timer getTimer() {
    return timer;
  }

  public void setTimer(V1Timer timer) {
    this.timer = timer;
  }

  public V1Clock timezone(V1ClockOffsetTimezone timezone) {
    this.timezone = timezone;
    return this;
  }

   /**
   * Timezone sets the guest clock to the specified timezone. Zone name follows the TZ environment variable format (e.g. &#39;America/New_York&#39;).
   * @return timezone
  **/
  @ApiModelProperty(value = "Timezone sets the guest clock to the specified timezone. Zone name follows the TZ environment variable format (e.g. 'America/New_York').")
  public V1ClockOffsetTimezone getTimezone() {
    return timezone;
  }

  public void setTimezone(V1ClockOffsetTimezone timezone) {
    this.timezone = timezone;
  }

  public V1Clock utc(V1ClockOffsetUTC utc) {
    this.utc = utc;
    return this;
  }

   /**
   * UTC sets the guest clock to UTC on each boot. If an offset is specified, guest changes to the clock will be kept during reboots and are not reset.
   * @return utc
  **/
  @ApiModelProperty(value = "UTC sets the guest clock to UTC on each boot. If an offset is specified, guest changes to the clock will be kept during reboots and are not reset.")
  public V1ClockOffsetUTC getUtc() {
    return utc;
  }

  public void setUtc(V1ClockOffsetUTC utc) {
    this.utc = utc;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    V1Clock v1Clock = (V1Clock) o;
    return Objects.equals(this.timer, v1Clock.timer) &&
        Objects.equals(this.timezone, v1Clock.timezone) &&
        Objects.equals(this.utc, v1Clock.utc);
  }

  @Override
  public int hashCode() {
    return Objects.hash(timer, timezone, utc);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class V1Clock {\n");
    
    sb.append("    timer: ").append(toIndentedString(timer)).append("\n");
    sb.append("    timezone: ").append(toIndentedString(timezone)).append("\n");
    sb.append("    utc: ").append(toIndentedString(utc)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

