/*
 * KubeVirt API
 * This is KubeVirt API an add-on for Kubernetes.
 *
 * OpenAPI spec version: 1.0.0
 * Contact: kubevirt-dev@googlegroups.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package kubevirt.io;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import kubevirt.io.V1DHCPPrivateOptions;

/**
 * Extra DHCP options to use in the interface.
 */
@ApiModel(description = "Extra DHCP options to use in the interface.")
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2019-11-10T14:44:51.030+02:00")
public class V1DHCPOptions {
  @SerializedName("bootFileName")
  private String bootFileName = null;

  @SerializedName("ntpServers")
  private List<String> ntpServers = null;

  @SerializedName("privateOptions")
  private List<V1DHCPPrivateOptions> privateOptions = null;

  @SerializedName("tftpServerName")
  private String tftpServerName = null;

  public V1DHCPOptions bootFileName(String bootFileName) {
    this.bootFileName = bootFileName;
    return this;
  }

   /**
   * If specified will pass option 67 to interface&#39;s DHCP server +optional
   * @return bootFileName
  **/
  @ApiModelProperty(value = "If specified will pass option 67 to interface's DHCP server +optional")
  public String getBootFileName() {
    return bootFileName;
  }

  public void setBootFileName(String bootFileName) {
    this.bootFileName = bootFileName;
  }

  public V1DHCPOptions ntpServers(List<String> ntpServers) {
    this.ntpServers = ntpServers;
    return this;
  }

  public V1DHCPOptions addNtpServersItem(String ntpServersItem) {
    if (this.ntpServers == null) {
      this.ntpServers = new ArrayList<>();
    }
    this.ntpServers.add(ntpServersItem);
    return this;
  }

   /**
   * If specified will pass the configured NTP server to the VM via DHCP option 042. +optional
   * @return ntpServers
  **/
  @ApiModelProperty(value = "If specified will pass the configured NTP server to the VM via DHCP option 042. +optional")
  public List<String> getNtpServers() {
    return ntpServers;
  }

  public void setNtpServers(List<String> ntpServers) {
    this.ntpServers = ntpServers;
  }

  public V1DHCPOptions privateOptions(List<V1DHCPPrivateOptions> privateOptions) {
    this.privateOptions = privateOptions;
    return this;
  }

  public V1DHCPOptions addPrivateOptionsItem(V1DHCPPrivateOptions privateOptionsItem) {
    if (this.privateOptions == null) {
      this.privateOptions = new ArrayList<>();
    }
    this.privateOptions.add(privateOptionsItem);
    return this;
  }

   /**
   * If specified will pass extra DHCP options for private use, range: 224-254 +optional
   * @return privateOptions
  **/
  @ApiModelProperty(value = "If specified will pass extra DHCP options for private use, range: 224-254 +optional")
  public List<V1DHCPPrivateOptions> getPrivateOptions() {
    return privateOptions;
  }

  public void setPrivateOptions(List<V1DHCPPrivateOptions> privateOptions) {
    this.privateOptions = privateOptions;
  }

  public V1DHCPOptions tftpServerName(String tftpServerName) {
    this.tftpServerName = tftpServerName;
    return this;
  }

   /**
   * If specified will pass option 66 to interface&#39;s DHCP server +optional
   * @return tftpServerName
  **/
  @ApiModelProperty(value = "If specified will pass option 66 to interface's DHCP server +optional")
  public String getTftpServerName() {
    return tftpServerName;
  }

  public void setTftpServerName(String tftpServerName) {
    this.tftpServerName = tftpServerName;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    V1DHCPOptions v1DHCPOptions = (V1DHCPOptions) o;
    return Objects.equals(this.bootFileName, v1DHCPOptions.bootFileName) &&
        Objects.equals(this.ntpServers, v1DHCPOptions.ntpServers) &&
        Objects.equals(this.privateOptions, v1DHCPOptions.privateOptions) &&
        Objects.equals(this.tftpServerName, v1DHCPOptions.tftpServerName);
  }

  @Override
  public int hashCode() {
    return Objects.hash(bootFileName, ntpServers, privateOptions, tftpServerName);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class V1DHCPOptions {\n");
    
    sb.append("    bootFileName: ").append(toIndentedString(bootFileName)).append("\n");
    sb.append("    ntpServers: ").append(toIndentedString(ntpServers)).append("\n");
    sb.append("    privateOptions: ").append(toIndentedString(privateOptions)).append("\n");
    sb.append("    tftpServerName: ").append(toIndentedString(tftpServerName)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

