/*
 * KubeVirt API
 * This is KubeVirt API an add-on for Kubernetes.
 *
 * OpenAPI spec version: 1.0.0
 * Contact: kubevirt-dev@googlegroups.com
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package kubevirt.io;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import kubevirt.io.V1Disk;
import kubevirt.io.V1GPU;
import kubevirt.io.V1Input;
import kubevirt.io.V1Interface;
import kubevirt.io.V1Rng;
import kubevirt.io.V1Watchdog;

/**
 * V1Devices
 */
@javax.annotation.Generated(value = "io.swagger.codegen.languages.JavaClientCodegen", date = "2019-11-10T14:44:51.030+02:00")
public class V1Devices {
  @SerializedName("autoattachGraphicsDevice")
  private Boolean autoattachGraphicsDevice = null;

  @SerializedName("autoattachPodInterface")
  private Boolean autoattachPodInterface = null;

  @SerializedName("blockMultiQueue")
  private Boolean blockMultiQueue = null;

  @SerializedName("disks")
  private List<V1Disk> disks = null;

  @SerializedName("gpus")
  private List<V1GPU> gpus = null;

  @SerializedName("inputs")
  private List<V1Input> inputs = null;

  @SerializedName("interfaces")
  private List<V1Interface> interfaces = null;

  @SerializedName("networkInterfaceMultiqueue")
  private Boolean networkInterfaceMultiqueue = null;

  @SerializedName("rng")
  private V1Rng rng = null;

  @SerializedName("watchdog")
  private V1Watchdog watchdog = null;

  public V1Devices autoattachGraphicsDevice(Boolean autoattachGraphicsDevice) {
    this.autoattachGraphicsDevice = autoattachGraphicsDevice;
    return this;
  }

   /**
   * Whether to attach the default graphics device or not. VNC will not be available if set to false. Defaults to true.
   * @return autoattachGraphicsDevice
  **/
  @ApiModelProperty(value = "Whether to attach the default graphics device or not. VNC will not be available if set to false. Defaults to true.")
  public Boolean isAutoattachGraphicsDevice() {
    return autoattachGraphicsDevice;
  }

  public void setAutoattachGraphicsDevice(Boolean autoattachGraphicsDevice) {
    this.autoattachGraphicsDevice = autoattachGraphicsDevice;
  }

  public V1Devices autoattachPodInterface(Boolean autoattachPodInterface) {
    this.autoattachPodInterface = autoattachPodInterface;
    return this;
  }

   /**
   * Whether to attach a pod network interface. Defaults to true.
   * @return autoattachPodInterface
  **/
  @ApiModelProperty(value = "Whether to attach a pod network interface. Defaults to true.")
  public Boolean isAutoattachPodInterface() {
    return autoattachPodInterface;
  }

  public void setAutoattachPodInterface(Boolean autoattachPodInterface) {
    this.autoattachPodInterface = autoattachPodInterface;
  }

  public V1Devices blockMultiQueue(Boolean blockMultiQueue) {
    this.blockMultiQueue = blockMultiQueue;
    return this;
  }

   /**
   * Whether or not to enable virtio multi-queue for block devices +optional
   * @return blockMultiQueue
  **/
  @ApiModelProperty(value = "Whether or not to enable virtio multi-queue for block devices +optional")
  public Boolean isBlockMultiQueue() {
    return blockMultiQueue;
  }

  public void setBlockMultiQueue(Boolean blockMultiQueue) {
    this.blockMultiQueue = blockMultiQueue;
  }

  public V1Devices disks(List<V1Disk> disks) {
    this.disks = disks;
    return this;
  }

  public V1Devices addDisksItem(V1Disk disksItem) {
    if (this.disks == null) {
      this.disks = new ArrayList<>();
    }
    this.disks.add(disksItem);
    return this;
  }

   /**
   * Disks describes disks, cdroms, floppy and luns which are connected to the vmi.
   * @return disks
  **/
  @ApiModelProperty(value = "Disks describes disks, cdroms, floppy and luns which are connected to the vmi.")
  public List<V1Disk> getDisks() {
    return disks;
  }

  public void setDisks(List<V1Disk> disks) {
    this.disks = disks;
  }

  public V1Devices gpus(List<V1GPU> gpus) {
    this.gpus = gpus;
    return this;
  }

  public V1Devices addGpusItem(V1GPU gpusItem) {
    if (this.gpus == null) {
      this.gpus = new ArrayList<>();
    }
    this.gpus.add(gpusItem);
    return this;
  }

   /**
   * Whether to attach a GPU device to the vmi. +optional
   * @return gpus
  **/
  @ApiModelProperty(value = "Whether to attach a GPU device to the vmi. +optional")
  public List<V1GPU> getGpus() {
    return gpus;
  }

  public void setGpus(List<V1GPU> gpus) {
    this.gpus = gpus;
  }

  public V1Devices inputs(List<V1Input> inputs) {
    this.inputs = inputs;
    return this;
  }

  public V1Devices addInputsItem(V1Input inputsItem) {
    if (this.inputs == null) {
      this.inputs = new ArrayList<>();
    }
    this.inputs.add(inputsItem);
    return this;
  }

   /**
   * Inputs describe input devices
   * @return inputs
  **/
  @ApiModelProperty(value = "Inputs describe input devices")
  public List<V1Input> getInputs() {
    return inputs;
  }

  public void setInputs(List<V1Input> inputs) {
    this.inputs = inputs;
  }

  public V1Devices interfaces(List<V1Interface> interfaces) {
    this.interfaces = interfaces;
    return this;
  }

  public V1Devices addInterfacesItem(V1Interface interfacesItem) {
    if (this.interfaces == null) {
      this.interfaces = new ArrayList<>();
    }
    this.interfaces.add(interfacesItem);
    return this;
  }

   /**
   * Interfaces describe network interfaces which are added to the vmi.
   * @return interfaces
  **/
  @ApiModelProperty(value = "Interfaces describe network interfaces which are added to the vmi.")
  public List<V1Interface> getInterfaces() {
    return interfaces;
  }

  public void setInterfaces(List<V1Interface> interfaces) {
    this.interfaces = interfaces;
  }

  public V1Devices networkInterfaceMultiqueue(Boolean networkInterfaceMultiqueue) {
    this.networkInterfaceMultiqueue = networkInterfaceMultiqueue;
    return this;
  }

   /**
   * If specified, virtual network interfaces configured with a virtio bus will also enable the vhost multiqueue feature +optional
   * @return networkInterfaceMultiqueue
  **/
  @ApiModelProperty(value = "If specified, virtual network interfaces configured with a virtio bus will also enable the vhost multiqueue feature +optional")
  public Boolean isNetworkInterfaceMultiqueue() {
    return networkInterfaceMultiqueue;
  }

  public void setNetworkInterfaceMultiqueue(Boolean networkInterfaceMultiqueue) {
    this.networkInterfaceMultiqueue = networkInterfaceMultiqueue;
  }

  public V1Devices rng(V1Rng rng) {
    this.rng = rng;
    return this;
  }

   /**
   * Whether to have random number generator from host +optional
   * @return rng
  **/
  @ApiModelProperty(value = "Whether to have random number generator from host +optional")
  public V1Rng getRng() {
    return rng;
  }

  public void setRng(V1Rng rng) {
    this.rng = rng;
  }

  public V1Devices watchdog(V1Watchdog watchdog) {
    this.watchdog = watchdog;
    return this;
  }

   /**
   * Watchdog describes a watchdog device which can be added to the vmi.
   * @return watchdog
  **/
  @ApiModelProperty(value = "Watchdog describes a watchdog device which can be added to the vmi.")
  public V1Watchdog getWatchdog() {
    return watchdog;
  }

  public void setWatchdog(V1Watchdog watchdog) {
    this.watchdog = watchdog;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    V1Devices v1Devices = (V1Devices) o;
    return Objects.equals(this.autoattachGraphicsDevice, v1Devices.autoattachGraphicsDevice) &&
        Objects.equals(this.autoattachPodInterface, v1Devices.autoattachPodInterface) &&
        Objects.equals(this.blockMultiQueue, v1Devices.blockMultiQueue) &&
        Objects.equals(this.disks, v1Devices.disks) &&
        Objects.equals(this.gpus, v1Devices.gpus) &&
        Objects.equals(this.inputs, v1Devices.inputs) &&
        Objects.equals(this.interfaces, v1Devices.interfaces) &&
        Objects.equals(this.networkInterfaceMultiqueue, v1Devices.networkInterfaceMultiqueue) &&
        Objects.equals(this.rng, v1Devices.rng) &&
        Objects.equals(this.watchdog, v1Devices.watchdog);
  }

  @Override
  public int hashCode() {
    return Objects.hash(autoattachGraphicsDevice, autoattachPodInterface, blockMultiQueue, disks, gpus, inputs, interfaces, networkInterfaceMultiqueue, rng, watchdog);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class V1Devices {\n");
    
    sb.append("    autoattachGraphicsDevice: ").append(toIndentedString(autoattachGraphicsDevice)).append("\n");
    sb.append("    autoattachPodInterface: ").append(toIndentedString(autoattachPodInterface)).append("\n");
    sb.append("    blockMultiQueue: ").append(toIndentedString(blockMultiQueue)).append("\n");
    sb.append("    disks: ").append(toIndentedString(disks)).append("\n");
    sb.append("    gpus: ").append(toIndentedString(gpus)).append("\n");
    sb.append("    inputs: ").append(toIndentedString(inputs)).append("\n");
    sb.append("    interfaces: ").append(toIndentedString(interfaces)).append("\n");
    sb.append("    networkInterfaceMultiqueue: ").append(toIndentedString(networkInterfaceMultiqueue)).append("\n");
    sb.append("    rng: ").append(toIndentedString(rng)).append("\n");
    sb.append("    watchdog: ").append(toIndentedString(watchdog)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

