/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.internal.containers;

import java.lang.Boolean;
import java.math.BigInteger;
import org.ovirt.engine.sdk4.types.MemoryOverCommit;
import org.ovirt.engine.sdk4.types.MemoryPolicy;
import org.ovirt.engine.sdk4.types.TransparentHugePages;

public class MemoryPolicyContainer extends Container implements MemoryPolicy {
    private Boolean ballooning;
    private BigInteger guaranteed;
    private BigInteger max;
    private MemoryOverCommit overCommit;
    private TransparentHugePages transparentHugePages;
    
    public boolean ballooning() {
        return ballooning;
    }
    
    public void ballooning(boolean newBallooning) {
        ballooning = Boolean.valueOf(newBallooning);
    }
    
    public void ballooning(Boolean newBallooning) {
        ballooning = newBallooning;
    }
    
    public boolean ballooningPresent() {
        return ballooning != null;
    }
    
    public BigInteger guaranteed() {
        return guaranteed;
    }
    
    public void guaranteed(BigInteger newGuaranteed) {
        guaranteed = newGuaranteed;
    }
    
    public boolean guaranteedPresent() {
        return guaranteed != null;
    }
    
    public BigInteger max() {
        return max;
    }
    
    public void max(BigInteger newMax) {
        max = newMax;
    }
    
    public boolean maxPresent() {
        return max != null;
    }
    
    public MemoryOverCommit overCommit() {
        return overCommit;
    }
    
    public void overCommit(MemoryOverCommit newOverCommit) {
        overCommit = newOverCommit;
    }
    
    public boolean overCommitPresent() {
        return overCommit != null;
    }
    
    public TransparentHugePages transparentHugePages() {
        return transparentHugePages;
    }
    
    public void transparentHugePages(TransparentHugePages newTransparentHugePages) {
        transparentHugePages = newTransparentHugePages;
    }
    
    public boolean transparentHugePagesPresent() {
        return transparentHugePages != null;
    }
    
}
