/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.xml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.engine.sdk4.internal.containers.KsmContainer;
import org.ovirt.engine.sdk4.types.Ksm;

public class XmlKsmReader {
    public static Ksm readOne(XmlReader reader) {
        if (!reader.forward()) {
            return null;
        }
        KsmContainer object = new KsmContainer();
        ArrayList<String[]> links = new ArrayList<String[]>();
        reader.next();
        block10: while (reader.forward()) {
            String name;
            switch (name = reader.getLocalName()) {
                case "enabled": {
                    object.enabled(reader.readBoolean());
                    continue block10;
                }
                case "merge_across_nodes": {
                    object.mergeAcrossNodes(reader.readBoolean());
                    continue block10;
                }
                case "link": {
                    String rel = reader.getAttributeValue("rel");
                    String href = reader.getAttributeValue("href");
                    if (rel != null && href != null) {
                        links.add(new String[]{rel, href});
                    }
                    reader.next();
                    continue block10;
                }
            }
            reader.skip();
        }
        if (links != null) {
            for (String[] link : links) {
                XmlKsmReader.processLink(object, link);
            }
        }
        reader.next();
        return object;
    }

    public static Iterator<Ksm> iterateMany(final XmlReader reader) {
        return new Iterator<Ksm>(){
            private boolean first = true;

            @Override
            public void remove() {
            }

            @Override
            public boolean hasNext() {
                if (this.first) {
                    if (!reader.forward()) {
                        return false;
                    }
                    reader.next();
                    this.first = false;
                }
                if (!reader.forward()) {
                    reader.next();
                    return false;
                }
                return true;
            }

            @Override
            public Ksm next() {
                Ksm next = XmlKsmReader.readOne(reader);
                if (next == null) {
                    throw new NoSuchElementException();
                }
                return next;
            }
        };
    }

    public static List<Ksm> readMany(XmlReader reader) {
        ArrayList<Ksm> list = new ArrayList<Ksm>();
        Iterator<Ksm> iterator = XmlKsmReader.iterateMany(reader);
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return list;
    }

    private static void processLink(KsmContainer object, String[] link) {
    }
}

