/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.xml;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.ovirt.api.metamodel.runtime.util.ArrayListWithHref;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.engine.sdk4.internal.containers.NicContainer;
import org.ovirt.engine.sdk4.internal.xml.XmlBootProtocolReader;
import org.ovirt.engine.sdk4.internal.xml.XmlInstanceTypeReader;
import org.ovirt.engine.sdk4.internal.xml.XmlMacReader;
import org.ovirt.engine.sdk4.internal.xml.XmlNetworkAttachmentReader;
import org.ovirt.engine.sdk4.internal.xml.XmlNetworkLabelReader;
import org.ovirt.engine.sdk4.internal.xml.XmlNetworkReader;
import org.ovirt.engine.sdk4.internal.xml.XmlNicInterfaceReader;
import org.ovirt.engine.sdk4.internal.xml.XmlReportedDeviceReader;
import org.ovirt.engine.sdk4.internal.xml.XmlStatisticReader;
import org.ovirt.engine.sdk4.internal.xml.XmlTemplateReader;
import org.ovirt.engine.sdk4.internal.xml.XmlVmReader;
import org.ovirt.engine.sdk4.internal.xml.XmlVnicProfileReader;
import org.ovirt.engine.sdk4.types.Network;
import org.ovirt.engine.sdk4.types.NetworkAttachment;
import org.ovirt.engine.sdk4.types.NetworkLabel;
import org.ovirt.engine.sdk4.types.Nic;
import org.ovirt.engine.sdk4.types.ReportedDevice;
import org.ovirt.engine.sdk4.types.Statistic;
import org.ovirt.engine.sdk4.types.Vm;

public class XmlNicReader {
    public static Nic readOne(XmlReader reader) {
        String name;
        if (!reader.forward()) {
            return null;
        }
        NicContainer object = new NicContainer();
        block56: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            name = reader.getAttributeLocalName(i);
            String image = reader.getAttributeValue(i);
            switch (name) {
                case "href": {
                    object.href(image);
                    continue block56;
                }
                case "id": {
                    object.id(image);
                    continue block56;
                }
            }
        }
        ArrayList<String[]> links = new ArrayList<String[]>();
        reader.next();
        block57: while (reader.forward()) {
            switch (name = reader.getLocalName()) {
                case "boot_protocol": {
                    object.bootProtocol(XmlBootProtocolReader.readOne(reader));
                    continue block57;
                }
                case "comment": {
                    object.comment(reader.readString());
                    continue block57;
                }
                case "description": {
                    object.description(reader.readString());
                    continue block57;
                }
                case "instance_type": {
                    object.instanceType(XmlInstanceTypeReader.readOne(reader));
                    continue block57;
                }
                case "interface": {
                    object.interface_(XmlNicInterfaceReader.readOne(reader));
                    continue block57;
                }
                case "linked": {
                    object.linked(reader.readBoolean());
                    continue block57;
                }
                case "mac": {
                    object.mac(XmlMacReader.readOne(reader));
                    continue block57;
                }
                case "name": {
                    object.name(reader.readString());
                    continue block57;
                }
                case "network": {
                    object.network(XmlNetworkReader.readOne(reader));
                    continue block57;
                }
                case "network_attachments": {
                    object.networkAttachments(XmlNetworkAttachmentReader.readMany(reader));
                    continue block57;
                }
                case "network_labels": {
                    object.networkLabels(XmlNetworkLabelReader.readMany(reader));
                    continue block57;
                }
                case "on_boot": {
                    object.onBoot(reader.readBoolean());
                    continue block57;
                }
                case "plugged": {
                    object.plugged(reader.readBoolean());
                    continue block57;
                }
                case "reported_devices": {
                    object.reportedDevices(XmlReportedDeviceReader.readMany(reader));
                    continue block57;
                }
                case "statistics": {
                    object.statistics(XmlStatisticReader.readMany(reader));
                    continue block57;
                }
                case "template": {
                    object.template(XmlTemplateReader.readOne(reader));
                    continue block57;
                }
                case "virtual_function_allowed_labels": {
                    object.virtualFunctionAllowedLabels(XmlNetworkLabelReader.readMany(reader));
                    continue block57;
                }
                case "virtual_function_allowed_networks": {
                    object.virtualFunctionAllowedNetworks(XmlNetworkReader.readMany(reader));
                    continue block57;
                }
                case "vm": {
                    object.vm(XmlVmReader.readOne(reader));
                    continue block57;
                }
                case "vms": {
                    object.vms(XmlVmReader.readMany(reader));
                    continue block57;
                }
                case "vnic_profile": {
                    object.vnicProfile(XmlVnicProfileReader.readOne(reader));
                    continue block57;
                }
                case "link": {
                    String rel = reader.getAttributeValue("rel");
                    String href = reader.getAttributeValue("href");
                    if (rel != null && href != null) {
                        links.add(new String[]{rel, href});
                    }
                    reader.next();
                    continue block57;
                }
            }
            reader.skip();
        }
        if (links != null) {
            for (String[] link : links) {
                XmlNicReader.processLink(object, link);
            }
        }
        reader.next();
        return object;
    }

    public static Iterator<Nic> iterateMany(final XmlReader reader) {
        return new Iterator<Nic>(){
            private boolean first = true;

            @Override
            public void remove() {
            }

            @Override
            public boolean hasNext() {
                if (this.first) {
                    if (!reader.forward()) {
                        return false;
                    }
                    reader.next();
                    this.first = false;
                }
                if (!reader.forward()) {
                    reader.next();
                    return false;
                }
                return true;
            }

            @Override
            public Nic next() {
                Nic next = XmlNicReader.readOne(reader);
                if (next == null) {
                    throw new NoSuchElementException();
                }
                return next;
            }
        };
    }

    public static List<Nic> readMany(XmlReader reader) {
        ArrayList<Nic> list = new ArrayList<Nic>();
        Iterator<Nic> iterator = XmlNicReader.iterateMany(reader);
        while (iterator.hasNext()) {
            list.add(iterator.next());
        }
        return list;
    }

    private static void processLink(NicContainer object, String[] link) {
        String rel = link[0];
        String href = link[1];
        if (href != null) {
            switch (rel) {
                case "networkattachments": {
                    ArrayListWithHref<NetworkAttachment> list = new ArrayListWithHref<NetworkAttachment>(object.networkAttachments());
                    list.href(href);
                    object.networkAttachments(list);
                    break;
                }
                case "networklabels": {
                    ArrayListWithHref<NetworkLabel> list = new ArrayListWithHref<NetworkLabel>(object.networkLabels());
                    list.href(href);
                    object.networkLabels(list);
                    break;
                }
                case "reporteddevices": {
                    ArrayListWithHref<ReportedDevice> list = new ArrayListWithHref<ReportedDevice>(object.reportedDevices());
                    list.href(href);
                    object.reportedDevices(list);
                    break;
                }
                case "statistics": {
                    ArrayListWithHref<Statistic> list = new ArrayListWithHref<Statistic>(object.statistics());
                    list.href(href);
                    object.statistics(list);
                    break;
                }
                case "virtualfunctionallowedlabels": {
                    ArrayListWithHref<NetworkLabel> list = new ArrayListWithHref<NetworkLabel>(object.virtualFunctionAllowedLabels());
                    list.href(href);
                    object.virtualFunctionAllowedLabels(list);
                    break;
                }
                case "virtualfunctionallowednetworks": {
                    ArrayListWithHref<Network> list = new ArrayListWithHref<Network>(object.virtualFunctionAllowedNetworks());
                    list.href(href);
                    object.virtualFunctionAllowedNetworks(list);
                    break;
                }
                case "vms": {
                    ArrayListWithHref<Vm> list = new ArrayListWithHref<Vm>(object.vms());
                    list.href(href);
                    object.vms(list);
                    break;
                }
            }
        }
    }
}

