/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.builders;

import java.math.BigInteger;
import java.util.Date;
import org.ovirt.engine.sdk4.builders.ClusterBuilder;
import org.ovirt.engine.sdk4.builders.DataCenterBuilder;
import org.ovirt.engine.sdk4.builders.HostBuilder;
import org.ovirt.engine.sdk4.builders.StorageDomainBuilder;
import org.ovirt.engine.sdk4.builders.TemplateBuilder;
import org.ovirt.engine.sdk4.builders.UserBuilder;
import org.ovirt.engine.sdk4.builders.VmBuilder;
import org.ovirt.engine.sdk4.internal.containers.EventContainer;
import org.ovirt.engine.sdk4.types.Cluster;
import org.ovirt.engine.sdk4.types.DataCenter;
import org.ovirt.engine.sdk4.types.Event;
import org.ovirt.engine.sdk4.types.Host;
import org.ovirt.engine.sdk4.types.LogSeverity;
import org.ovirt.engine.sdk4.types.StorageDomain;
import org.ovirt.engine.sdk4.types.Template;
import org.ovirt.engine.sdk4.types.User;
import org.ovirt.engine.sdk4.types.Vm;

public class EventBuilder {
    private Cluster cluster;
    private BigInteger code;
    private String comment;
    private String correlationId;
    private String customData;
    private BigInteger customId;
    private DataCenter dataCenter;
    private String description;
    private BigInteger floodRate;
    private Host host;
    private String href;
    private String id;
    private BigInteger index;
    private String name;
    private String origin;
    private LogSeverity severity;
    private StorageDomain storageDomain;
    private Template template;
    private Date time;
    private User user;
    private Vm vm;

    public EventBuilder cluster(Cluster newCluster) {
        this.cluster = newCluster;
        return this;
    }

    public EventBuilder cluster(ClusterBuilder newCluster) {
        this.cluster = newCluster == null ? null : newCluster.build();
        return this;
    }

    public EventBuilder code(int newCode) {
        this.code = BigInteger.valueOf(newCode);
        return this;
    }

    public EventBuilder code(Integer newCode) {
        this.code = newCode == null ? null : BigInteger.valueOf(newCode.longValue());
        return this;
    }

    public EventBuilder code(long newCode) {
        this.code = BigInteger.valueOf(newCode);
        return this;
    }

    public EventBuilder code(Long newCode) {
        this.code = newCode == null ? null : BigInteger.valueOf(newCode);
        return this;
    }

    public EventBuilder code(BigInteger newCode) {
        this.code = newCode;
        return this;
    }

    public EventBuilder comment(String newComment) {
        this.comment = newComment;
        return this;
    }

    public EventBuilder correlationId(String newCorrelationId) {
        this.correlationId = newCorrelationId;
        return this;
    }

    public EventBuilder customData(String newCustomData) {
        this.customData = newCustomData;
        return this;
    }

    public EventBuilder customId(int newCustomId) {
        this.customId = BigInteger.valueOf(newCustomId);
        return this;
    }

    public EventBuilder customId(Integer newCustomId) {
        this.customId = newCustomId == null ? null : BigInteger.valueOf(newCustomId.longValue());
        return this;
    }

    public EventBuilder customId(long newCustomId) {
        this.customId = BigInteger.valueOf(newCustomId);
        return this;
    }

    public EventBuilder customId(Long newCustomId) {
        this.customId = newCustomId == null ? null : BigInteger.valueOf(newCustomId);
        return this;
    }

    public EventBuilder customId(BigInteger newCustomId) {
        this.customId = newCustomId;
        return this;
    }

    public EventBuilder dataCenter(DataCenter newDataCenter) {
        this.dataCenter = newDataCenter;
        return this;
    }

    public EventBuilder dataCenter(DataCenterBuilder newDataCenter) {
        this.dataCenter = newDataCenter == null ? null : newDataCenter.build();
        return this;
    }

    public EventBuilder description(String newDescription) {
        this.description = newDescription;
        return this;
    }

    public EventBuilder floodRate(int newFloodRate) {
        this.floodRate = BigInteger.valueOf(newFloodRate);
        return this;
    }

    public EventBuilder floodRate(Integer newFloodRate) {
        this.floodRate = newFloodRate == null ? null : BigInteger.valueOf(newFloodRate.longValue());
        return this;
    }

    public EventBuilder floodRate(long newFloodRate) {
        this.floodRate = BigInteger.valueOf(newFloodRate);
        return this;
    }

    public EventBuilder floodRate(Long newFloodRate) {
        this.floodRate = newFloodRate == null ? null : BigInteger.valueOf(newFloodRate);
        return this;
    }

    public EventBuilder floodRate(BigInteger newFloodRate) {
        this.floodRate = newFloodRate;
        return this;
    }

    public EventBuilder host(Host newHost) {
        this.host = newHost;
        return this;
    }

    public EventBuilder host(HostBuilder newHost) {
        this.host = newHost == null ? null : newHost.build();
        return this;
    }

    public EventBuilder href(String newHref) {
        this.href = newHref;
        return this;
    }

    public EventBuilder id(String newId) {
        this.id = newId;
        return this;
    }

    public EventBuilder index(int newIndex) {
        this.index = BigInteger.valueOf(newIndex);
        return this;
    }

    public EventBuilder index(Integer newIndex) {
        this.index = newIndex == null ? null : BigInteger.valueOf(newIndex.longValue());
        return this;
    }

    public EventBuilder index(long newIndex) {
        this.index = BigInteger.valueOf(newIndex);
        return this;
    }

    public EventBuilder index(Long newIndex) {
        this.index = newIndex == null ? null : BigInteger.valueOf(newIndex);
        return this;
    }

    public EventBuilder index(BigInteger newIndex) {
        this.index = newIndex;
        return this;
    }

    public EventBuilder name(String newName) {
        this.name = newName;
        return this;
    }

    public EventBuilder origin(String newOrigin) {
        this.origin = newOrigin;
        return this;
    }

    public EventBuilder severity(LogSeverity newSeverity) {
        this.severity = newSeverity;
        return this;
    }

    public EventBuilder storageDomain(StorageDomain newStorageDomain) {
        this.storageDomain = newStorageDomain;
        return this;
    }

    public EventBuilder storageDomain(StorageDomainBuilder newStorageDomain) {
        this.storageDomain = newStorageDomain == null ? null : newStorageDomain.build();
        return this;
    }

    public EventBuilder template(Template newTemplate) {
        this.template = newTemplate;
        return this;
    }

    public EventBuilder template(TemplateBuilder newTemplate) {
        this.template = newTemplate == null ? null : newTemplate.build();
        return this;
    }

    public EventBuilder time(Date newTime) {
        this.time = newTime == null ? null : new Date(newTime.getTime());
        return this;
    }

    public EventBuilder user(User newUser) {
        this.user = newUser;
        return this;
    }

    public EventBuilder user(UserBuilder newUser) {
        this.user = newUser == null ? null : newUser.build();
        return this;
    }

    public EventBuilder vm(Vm newVm) {
        this.vm = newVm;
        return this;
    }

    public EventBuilder vm(VmBuilder newVm) {
        this.vm = newVm == null ? null : newVm.build();
        return this;
    }

    public Event build() {
        EventContainer container = new EventContainer();
        container.cluster(this.cluster);
        container.code(this.code);
        container.comment(this.comment);
        container.correlationId(this.correlationId);
        container.customData(this.customData);
        container.customId(this.customId);
        container.dataCenter(this.dataCenter);
        container.description(this.description);
        container.floodRate(this.floodRate);
        container.host(this.host);
        container.href(this.href);
        container.id(this.id);
        container.index(this.index);
        container.name(this.name);
        container.origin(this.origin);
        container.severity(this.severity);
        container.storageDomain(this.storageDomain);
        container.template(this.template);
        container.time(this.time);
        container.user(this.user);
        container.vm(this.vm);
        return container;
    }
}

