/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.types;


import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum HostStatus {
    
    DOWN,
    ERROR,
    INITIALIZING,
    INSTALLING,
    INSTALL_FAILED,
    MAINTENANCE,
    NON_OPERATIONAL,
    NON_RESPONSIVE,
    PENDING_APPROVAL,
    PREPARING_FOR_MAINTENANCE,
    CONNECTING,
    REBOOT,
    UNASSIGNED,
    UP,
    INSTALLING_OS,
    KDUMPING;
    
    private static final Logger LOG = LoggerFactory.getLogger(HostStatus.class);
    
    public String value() {
        return name().toLowerCase();
    }
    
    public static HostStatus fromValue(String value) {
        try {
            return valueOf(value.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            LOG.error("The string '" + value + "' isn't a valid value for the 'HostStatus' enumerated type. Valid values are: 'down', 'error', 'initializing', 'installing', 'install_failed', 'maintenance', 'non_operational', 'non_responsive', 'pending_approval', 'preparing_for_maintenance', 'connecting', 'reboot', 'unassigned', 'up', 'installing_os', 'kdumping'.");
            return null;
        }
    }
    
}
