/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.internal.containers;

import java.util.List;
import org.ovirt.engine.sdk4.types.Host;
import org.ovirt.engine.sdk4.types.VmAffinity;
import org.ovirt.engine.sdk4.types.VmPlacementPolicy;

public class VmPlacementPolicyContainer extends Container implements VmPlacementPolicy {
    private VmAffinity affinity;
    private List<Host> hosts;
    
    public VmAffinity affinity() {
        return affinity;
    }
    
    public void affinity(VmAffinity newAffinity) {
        affinity = newAffinity;
    }
    
    public boolean affinityPresent() {
        return affinity != null;
    }
    
    public List<Host> hosts() {
        return makeUnmodifiableList(hosts);
    }
    
    public void hosts(List<Host> newHosts) {
        hosts = makeArrayList(newHosts);
    }
    
    public boolean hostsPresent() {
        return hosts != null && !hosts.isEmpty();
    }
    
}
