/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.internal.containers;

import java.lang.Boolean;
import org.ovirt.engine.sdk4.types.AffinityRule;

public class AffinityRuleContainer extends Container implements AffinityRule {
    private Boolean enabled;
    private Boolean enforcing;
    private Boolean positive;
    
    public boolean enabled() {
        return enabled;
    }
    
    public void enabled(boolean newEnabled) {
        enabled = Boolean.valueOf(newEnabled);
    }
    
    public void enabled(Boolean newEnabled) {
        enabled = newEnabled;
    }
    
    public boolean enabledPresent() {
        return enabled != null;
    }
    
    public boolean enforcing() {
        return enforcing;
    }
    
    public void enforcing(boolean newEnforcing) {
        enforcing = Boolean.valueOf(newEnforcing);
    }
    
    public void enforcing(Boolean newEnforcing) {
        enforcing = newEnforcing;
    }
    
    public boolean enforcingPresent() {
        return enforcing != null;
    }
    
    public boolean positive() {
        return positive;
    }
    
    public void positive(boolean newPositive) {
        positive = Boolean.valueOf(newPositive);
    }
    
    public void positive(Boolean newPositive) {
        positive = newPositive;
    }
    
    public boolean positivePresent() {
        return positive != null;
    }
    
}
