/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.builders;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ovirt.engine.sdk4.builders.SystemOptionValueBuilder;
import org.ovirt.engine.sdk4.internal.containers.SystemOptionContainer;
import org.ovirt.engine.sdk4.types.SystemOption;
import org.ovirt.engine.sdk4.types.SystemOptionValue;

public class SystemOptionBuilder {
    private String comment;
    private String description;
    private String href;
    private String id;
    private String name;
    private List<SystemOptionValue> values;

    public SystemOptionBuilder comment(String newComment) {
        this.comment = newComment;
        return this;
    }

    public SystemOptionBuilder description(String newDescription) {
        this.description = newDescription;
        return this;
    }

    public SystemOptionBuilder href(String newHref) {
        this.href = newHref;
        return this;
    }

    public SystemOptionBuilder id(String newId) {
        this.id = newId;
        return this;
    }

    public SystemOptionBuilder name(String newName) {
        this.name = newName;
        return this;
    }

    public SystemOptionBuilder values(List<SystemOptionValue> newValues) {
        if (newValues != null) {
            if (this.values == null) {
                this.values = new ArrayList<SystemOptionValue>(newValues);
            } else {
                this.values.addAll(newValues);
            }
        }
        return this;
    }

    public SystemOptionBuilder values(SystemOptionValue ... newValues) {
        if (newValues != null) {
            if (this.values == null) {
                this.values = new ArrayList<SystemOptionValue>(newValues.length);
            }
            Collections.addAll(this.values, newValues);
        }
        return this;
    }

    public SystemOptionBuilder values(SystemOptionValueBuilder ... newValues) {
        if (newValues != null) {
            if (this.values == null) {
                this.values = new ArrayList<SystemOptionValue>(newValues.length);
            }
            for (SystemOptionValueBuilder builder : newValues) {
                this.values.add(builder.build());
            }
        }
        return this;
    }

    public SystemOption build() {
        SystemOptionContainer container = new SystemOptionContainer();
        container.comment(this.comment);
        container.description(this.description);
        container.href(this.href);
        container.id(this.id);
        container.name(this.name);
        container.values(this.values);
        return container;
    }
}

