/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.services;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.util.EntityUtils;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.BaseRequest;
import org.ovirt.engine.sdk4.Error;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.builders.IscsiBondBuilder;
import org.ovirt.engine.sdk4.internal.HttpConnection;
import org.ovirt.engine.sdk4.internal.services.IscsiBondServiceImpl;
import org.ovirt.engine.sdk4.internal.services.ServiceImpl;
import org.ovirt.engine.sdk4.internal.xml.XmlIscsiBondReader;
import org.ovirt.engine.sdk4.internal.xml.XmlIscsiBondWriter;
import org.ovirt.engine.sdk4.services.IscsiBondService;
import org.ovirt.engine.sdk4.services.IscsiBondsService;
import org.ovirt.engine.sdk4.types.IscsiBond;

public class IscsiBondsServiceImpl
extends ServiceImpl
implements IscsiBondsService {
    public IscsiBondsServiceImpl(HttpConnection connection, String path) {
        super(connection, path);
    }

    @Override
    public IscsiBondsService.AddRequest add() {
        return new AddRequestImpl();
    }

    @Override
    public IscsiBondsService.ListRequest list() {
        return new ListRequestImpl();
    }

    @Override
    public IscsiBondService iscsiBondService(String id) {
        return new IscsiBondServiceImpl(this.getConnection(), this.getPath() + "/" + id);
    }

    @Override
    public Service service(String path) {
        if (path == null) {
            return this;
        }
        int index = path.indexOf(47);
        if (index == -1) {
            return this.iscsiBondService(path);
        }
        return this.iscsiBondService(path.substring(0, index)).service(path.substring(index + 1));
    }

    public String toString() {
        return "IscsiBondsService:" + this.getPath();
    }

    private class ListResponseImpl
    implements IscsiBondsService.ListResponse {
        private List<IscsiBond> bonds;

        private ListResponseImpl() {
        }

        public void bonds(List<IscsiBond> bonds) {
            this.bonds = bonds;
        }

        @Override
        public List<IscsiBond> bonds() {
            return this.bonds;
        }
    }

    private class ListRequestImpl
    extends BaseRequest<IscsiBondsService.ListRequest, IscsiBondsService.ListResponse>
    implements IscsiBondsService.ListRequest {
        private String follow;
        private BigInteger max;

        private ListRequestImpl() {
        }

        @Override
        public IscsiBondsService.ListRequest follow(String follow) {
            this.follow = follow;
            return this;
        }

        @Override
        public IscsiBondsService.ListRequest max(BigInteger max) {
            this.max = max;
            return this;
        }

        @Override
        public IscsiBondsService.ListRequest max(Integer max) {
            this.max = BigInteger.valueOf(max.intValue());
            return this;
        }

        @Override
        public IscsiBondsService.ListRequest max(Long max) {
            this.max = BigInteger.valueOf(max);
            return this;
        }

        @Override
        public IscsiBondsService.ListResponse send() {
            HttpResponse response;
            HttpGet request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(IscsiBondsServiceImpl.this.getConnection().getUrl() + IscsiBondsServiceImpl.this.getPath());
                if (this.follow != null) {
                    uriBuilder.addParameter("follow", XmlWriter.renderString(this.follow));
                }
                if (this.max != null) {
                    uriBuilder.addParameter("max", XmlWriter.renderInteger(this.max));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpGet(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = IscsiBondsServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        ListResponseImpl actionResponse = new ListResponseImpl();
                        actionResponse.bonds(XmlIscsiBondReader.readMany(reader));
                        ListResponseImpl listResponseImpl = actionResponse;
                        reader.close();
                        return listResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            IscsiBondsServiceImpl.this.checkFault(response);
            return new ListResponseImpl();
        }
    }

    private class AddResponseImpl
    implements IscsiBondsService.AddResponse {
        private IscsiBond bond;

        private AddResponseImpl() {
        }

        public void bond(IscsiBond bond) {
            this.bond = bond;
        }

        @Override
        public IscsiBond bond() {
            return this.bond;
        }
    }

    private class AddRequestImpl
    extends BaseRequest<IscsiBondsService.AddRequest, IscsiBondsService.AddResponse>
    implements IscsiBondsService.AddRequest {
        private IscsiBond bond;

        private AddRequestImpl() {
        }

        @Override
        public IscsiBondsService.AddRequest bond(IscsiBond bond) {
            this.bond = bond;
            return this;
        }

        @Override
        public IscsiBondsService.AddRequest bond(IscsiBondBuilder bond) {
            this.bond = bond.build();
            return this;
        }

        @Override
        public IscsiBondsService.AddResponse send() {
            HttpResponse response;
            HttpPost request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(IscsiBondsServiceImpl.this.getConnection().getUrl() + IscsiBondsServiceImpl.this.getPath());
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpPost(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                XmlIscsiBondWriter.writeOne(this.bond, xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to parse response", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = IscsiBondsServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 201 || response.getStatusLine().getStatusCode() == 202) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        AddResponseImpl actionResponse = new AddResponseImpl();
                        actionResponse.bond(XmlIscsiBondReader.readOne(reader));
                        AddResponseImpl addResponseImpl = actionResponse;
                        reader.close();
                        return addResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            IscsiBondsServiceImpl.this.checkFault(response);
            return new AddResponseImpl();
        }
    }
}

