/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.services;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.util.EntityUtils;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.BaseRequest;
import org.ovirt.engine.sdk4.Error;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.builders.OpenstackVolumeAuthenticationKeyBuilder;
import org.ovirt.engine.sdk4.internal.HttpConnection;
import org.ovirt.engine.sdk4.internal.services.ServiceImpl;
import org.ovirt.engine.sdk4.internal.xml.XmlOpenstackVolumeAuthenticationKeyReader;
import org.ovirt.engine.sdk4.internal.xml.XmlOpenstackVolumeAuthenticationKeyWriter;
import org.ovirt.engine.sdk4.services.OpenstackVolumeAuthenticationKeyService;
import org.ovirt.engine.sdk4.types.OpenstackVolumeAuthenticationKey;

public class OpenstackVolumeAuthenticationKeyServiceImpl
extends ServiceImpl
implements OpenstackVolumeAuthenticationKeyService {
    public OpenstackVolumeAuthenticationKeyServiceImpl(HttpConnection connection, String path) {
        super(connection, path);
    }

    @Override
    public OpenstackVolumeAuthenticationKeyService.GetRequest get() {
        return new GetRequestImpl();
    }

    @Override
    public OpenstackVolumeAuthenticationKeyService.RemoveRequest remove() {
        return new RemoveRequestImpl();
    }

    @Override
    public OpenstackVolumeAuthenticationKeyService.UpdateRequest update() {
        return new UpdateRequestImpl();
    }

    @Override
    public Service service(String path) {
        if (path == null) {
            return this;
        }
        throw new Error("The path " + path + " doesn't correspond to any service");
    }

    public String toString() {
        return "OpenstackVolumeAuthenticationKeyService:" + this.getPath();
    }

    private class UpdateResponseImpl
    implements OpenstackVolumeAuthenticationKeyService.UpdateResponse {
        private OpenstackVolumeAuthenticationKey key;

        private UpdateResponseImpl() {
        }

        public void key(OpenstackVolumeAuthenticationKey key) {
            this.key = key;
        }

        @Override
        public OpenstackVolumeAuthenticationKey key() {
            return this.key;
        }
    }

    private class UpdateRequestImpl
    extends BaseRequest<OpenstackVolumeAuthenticationKeyService.UpdateRequest, OpenstackVolumeAuthenticationKeyService.UpdateResponse>
    implements OpenstackVolumeAuthenticationKeyService.UpdateRequest {
        private OpenstackVolumeAuthenticationKey key;

        private UpdateRequestImpl() {
        }

        @Override
        public OpenstackVolumeAuthenticationKeyService.UpdateRequest key(OpenstackVolumeAuthenticationKey key) {
            this.key = key;
            return this;
        }

        @Override
        public OpenstackVolumeAuthenticationKeyService.UpdateRequest key(OpenstackVolumeAuthenticationKeyBuilder key) {
            this.key = key.build();
            return this;
        }

        @Override
        public OpenstackVolumeAuthenticationKeyService.UpdateResponse send() {
            HttpResponse response;
            HttpPut request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(OpenstackVolumeAuthenticationKeyServiceImpl.this.getConnection().getUrl() + OpenstackVolumeAuthenticationKeyServiceImpl.this.getPath());
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpPut(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                XmlOpenstackVolumeAuthenticationKeyWriter.writeOne(this.key, xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to parse response", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = OpenstackVolumeAuthenticationKeyServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        UpdateResponseImpl actionResponse = new UpdateResponseImpl();
                        actionResponse.key(XmlOpenstackVolumeAuthenticationKeyReader.readOne(reader));
                        UpdateResponseImpl updateResponseImpl = actionResponse;
                        reader.close();
                        return updateResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            OpenstackVolumeAuthenticationKeyServiceImpl.this.checkFault(response);
            return new UpdateResponseImpl();
        }
    }

    private class RemoveResponseImpl
    implements OpenstackVolumeAuthenticationKeyService.RemoveResponse {
        private RemoveResponseImpl() {
        }
    }

    private class RemoveRequestImpl
    extends BaseRequest<OpenstackVolumeAuthenticationKeyService.RemoveRequest, OpenstackVolumeAuthenticationKeyService.RemoveResponse>
    implements OpenstackVolumeAuthenticationKeyService.RemoveRequest {
        private Boolean async;

        private RemoveRequestImpl() {
        }

        @Override
        public OpenstackVolumeAuthenticationKeyService.RemoveRequest async(Boolean async) {
            this.async = async;
            return this;
        }

        @Override
        public OpenstackVolumeAuthenticationKeyService.RemoveResponse send() {
            HttpResponse response;
            HttpDelete request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(OpenstackVolumeAuthenticationKeyServiceImpl.this.getConnection().getUrl() + OpenstackVolumeAuthenticationKeyServiceImpl.this.getPath());
                if (this.async != null) {
                    uriBuilder.addParameter("async", XmlWriter.renderBoolean(this.async));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpDelete(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = OpenstackVolumeAuthenticationKeyServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                return new RemoveResponseImpl();
            }
            OpenstackVolumeAuthenticationKeyServiceImpl.this.checkFault(response);
            return new RemoveResponseImpl();
        }
    }

    private class GetResponseImpl
    implements OpenstackVolumeAuthenticationKeyService.GetResponse {
        private OpenstackVolumeAuthenticationKey key;

        private GetResponseImpl() {
        }

        public void key(OpenstackVolumeAuthenticationKey key) {
            this.key = key;
        }

        @Override
        public OpenstackVolumeAuthenticationKey key() {
            return this.key;
        }
    }

    private class GetRequestImpl
    extends BaseRequest<OpenstackVolumeAuthenticationKeyService.GetRequest, OpenstackVolumeAuthenticationKeyService.GetResponse>
    implements OpenstackVolumeAuthenticationKeyService.GetRequest {
        private String follow;

        private GetRequestImpl() {
        }

        @Override
        public OpenstackVolumeAuthenticationKeyService.GetRequest follow(String follow) {
            this.follow = follow;
            return this;
        }

        @Override
        public OpenstackVolumeAuthenticationKeyService.GetResponse send() {
            HttpResponse response;
            HttpGet request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(OpenstackVolumeAuthenticationKeyServiceImpl.this.getConnection().getUrl() + OpenstackVolumeAuthenticationKeyServiceImpl.this.getPath());
                if (this.follow != null) {
                    uriBuilder.addParameter("follow", XmlWriter.renderString(this.follow));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpGet(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = OpenstackVolumeAuthenticationKeyServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        GetResponseImpl actionResponse = new GetResponseImpl();
                        actionResponse.key(XmlOpenstackVolumeAuthenticationKeyReader.readOne(reader));
                        GetResponseImpl getResponseImpl = actionResponse;
                        reader.close();
                        return getResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            OpenstackVolumeAuthenticationKeyServiceImpl.this.checkFault(response);
            return new GetResponseImpl();
        }
    }
}

