/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.services;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.util.EntityUtils;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.BaseRequest;
import org.ovirt.engine.sdk4.Error;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.builders.QuotaBuilder;
import org.ovirt.engine.sdk4.internal.HttpConnection;
import org.ovirt.engine.sdk4.internal.services.AssignedPermissionsServiceImpl;
import org.ovirt.engine.sdk4.internal.services.QuotaClusterLimitsServiceImpl;
import org.ovirt.engine.sdk4.internal.services.QuotaStorageLimitsServiceImpl;
import org.ovirt.engine.sdk4.internal.services.ServiceImpl;
import org.ovirt.engine.sdk4.internal.xml.XmlQuotaReader;
import org.ovirt.engine.sdk4.internal.xml.XmlQuotaWriter;
import org.ovirt.engine.sdk4.services.AssignedPermissionsService;
import org.ovirt.engine.sdk4.services.QuotaClusterLimitsService;
import org.ovirt.engine.sdk4.services.QuotaService;
import org.ovirt.engine.sdk4.services.QuotaStorageLimitsService;
import org.ovirt.engine.sdk4.types.Quota;

public class QuotaServiceImpl
extends ServiceImpl
implements QuotaService {
    public QuotaServiceImpl(HttpConnection connection, String path) {
        super(connection, path);
    }

    @Override
    public QuotaService.GetRequest get() {
        return new GetRequestImpl();
    }

    @Override
    public QuotaService.RemoveRequest remove() {
        return new RemoveRequestImpl();
    }

    @Override
    public QuotaService.UpdateRequest update() {
        return new UpdateRequestImpl();
    }

    @Override
    public AssignedPermissionsService permissionsService() {
        return new AssignedPermissionsServiceImpl(this.getConnection(), this.getPath() + "/permissions");
    }

    @Override
    public QuotaClusterLimitsService quotaClusterLimitsService() {
        return new QuotaClusterLimitsServiceImpl(this.getConnection(), this.getPath() + "/quotaclusterlimits");
    }

    @Override
    public QuotaStorageLimitsService quotaStorageLimitsService() {
        return new QuotaStorageLimitsServiceImpl(this.getConnection(), this.getPath() + "/quotastoragelimits");
    }

    @Override
    public Service service(String path) {
        if (path == null) {
            return this;
        }
        if (path.equals("permissions")) {
            return this.permissionsService();
        }
        if (path.startsWith("permissions/")) {
            return this.permissionsService().service(path.substring(12));
        }
        if (path.equals("quotaclusterlimits")) {
            return this.quotaClusterLimitsService();
        }
        if (path.startsWith("quotaclusterlimits/")) {
            return this.quotaClusterLimitsService().service(path.substring(19));
        }
        if (path.equals("quotastoragelimits")) {
            return this.quotaStorageLimitsService();
        }
        if (path.startsWith("quotastoragelimits/")) {
            return this.quotaStorageLimitsService().service(path.substring(19));
        }
        throw new Error("The path " + path + " doesn't correspond to any service");
    }

    public String toString() {
        return "QuotaService:" + this.getPath();
    }

    private class UpdateResponseImpl
    implements QuotaService.UpdateResponse {
        private Quota quota;

        private UpdateResponseImpl() {
        }

        public void quota(Quota quota) {
            this.quota = quota;
        }

        @Override
        public Quota quota() {
            return this.quota;
        }
    }

    private class UpdateRequestImpl
    extends BaseRequest<QuotaService.UpdateRequest, QuotaService.UpdateResponse>
    implements QuotaService.UpdateRequest {
        private Boolean async;
        private Quota quota;

        private UpdateRequestImpl() {
        }

        @Override
        public QuotaService.UpdateRequest async(Boolean async) {
            this.async = async;
            return this;
        }

        @Override
        public QuotaService.UpdateRequest quota(Quota quota) {
            this.quota = quota;
            return this;
        }

        @Override
        public QuotaService.UpdateRequest quota(QuotaBuilder quota) {
            this.quota = quota.build();
            return this;
        }

        @Override
        public QuotaService.UpdateResponse send() {
            HttpResponse response;
            HttpPut request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(QuotaServiceImpl.this.getConnection().getUrl() + QuotaServiceImpl.this.getPath());
                if (this.async != null) {
                    uriBuilder.addParameter("async", XmlWriter.renderBoolean(this.async));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpPut(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                XmlQuotaWriter.writeOne(this.quota, xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to parse response", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = QuotaServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        UpdateResponseImpl actionResponse = new UpdateResponseImpl();
                        actionResponse.quota(XmlQuotaReader.readOne(reader));
                        UpdateResponseImpl updateResponseImpl = actionResponse;
                        reader.close();
                        return updateResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            QuotaServiceImpl.this.checkFault(response);
            return new UpdateResponseImpl();
        }
    }

    private class RemoveResponseImpl
    implements QuotaService.RemoveResponse {
        private RemoveResponseImpl() {
        }
    }

    private class RemoveRequestImpl
    extends BaseRequest<QuotaService.RemoveRequest, QuotaService.RemoveResponse>
    implements QuotaService.RemoveRequest {
        private Boolean async;

        private RemoveRequestImpl() {
        }

        @Override
        public QuotaService.RemoveRequest async(Boolean async) {
            this.async = async;
            return this;
        }

        @Override
        public QuotaService.RemoveResponse send() {
            HttpResponse response;
            HttpDelete request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(QuotaServiceImpl.this.getConnection().getUrl() + QuotaServiceImpl.this.getPath());
                if (this.async != null) {
                    uriBuilder.addParameter("async", XmlWriter.renderBoolean(this.async));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpDelete(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = QuotaServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                return new RemoveResponseImpl();
            }
            QuotaServiceImpl.this.checkFault(response);
            return new RemoveResponseImpl();
        }
    }

    private class GetResponseImpl
    implements QuotaService.GetResponse {
        private Quota quota;

        private GetResponseImpl() {
        }

        public void quota(Quota quota) {
            this.quota = quota;
        }

        @Override
        public Quota quota() {
            return this.quota;
        }
    }

    private class GetRequestImpl
    extends BaseRequest<QuotaService.GetRequest, QuotaService.GetResponse>
    implements QuotaService.GetRequest {
        private String follow;

        private GetRequestImpl() {
        }

        @Override
        public QuotaService.GetRequest follow(String follow) {
            this.follow = follow;
            return this;
        }

        @Override
        public QuotaService.GetResponse send() {
            HttpResponse response;
            HttpGet request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(QuotaServiceImpl.this.getConnection().getUrl() + QuotaServiceImpl.this.getPath());
                if (this.follow != null) {
                    uriBuilder.addParameter("follow", XmlWriter.renderString(this.follow));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpGet(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = QuotaServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        GetResponseImpl actionResponse = new GetResponseImpl();
                        actionResponse.quota(XmlQuotaReader.readOne(reader));
                        GetResponseImpl getResponseImpl = actionResponse;
                        reader.close();
                        return getResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            QuotaServiceImpl.this.checkFault(response);
            return new GetResponseImpl();
        }
    }
}

