/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.services;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.util.EntityUtils;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.BaseRequest;
import org.ovirt.engine.sdk4.Error;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.builders.StorageConnectionBuilder;
import org.ovirt.engine.sdk4.internal.HttpConnection;
import org.ovirt.engine.sdk4.internal.services.ServiceImpl;
import org.ovirt.engine.sdk4.internal.services.StorageServerConnectionServiceImpl;
import org.ovirt.engine.sdk4.internal.xml.XmlStorageConnectionReader;
import org.ovirt.engine.sdk4.internal.xml.XmlStorageConnectionWriter;
import org.ovirt.engine.sdk4.services.StorageServerConnectionService;
import org.ovirt.engine.sdk4.services.StorageServerConnectionsService;
import org.ovirt.engine.sdk4.types.StorageConnection;

public class StorageServerConnectionsServiceImpl
extends ServiceImpl
implements StorageServerConnectionsService {
    public StorageServerConnectionsServiceImpl(HttpConnection connection, String path) {
        super(connection, path);
    }

    @Override
    public StorageServerConnectionsService.AddRequest add() {
        return new AddRequestImpl();
    }

    @Override
    public StorageServerConnectionsService.AddGlusterfsRequest addGlusterfs() {
        return new AddGlusterfsRequestImpl();
    }

    @Override
    public StorageServerConnectionsService.AddIscsiRequest addIscsi() {
        return new AddIscsiRequestImpl();
    }

    @Override
    public StorageServerConnectionsService.ListRequest list() {
        return new ListRequestImpl();
    }

    @Override
    public StorageServerConnectionsService.AddLocalRequest addLocal() {
        return new AddLocalRequestImpl();
    }

    @Override
    public StorageServerConnectionsService.AddNfsRequest addNfs() {
        return new AddNfsRequestImpl();
    }

    @Override
    public StorageServerConnectionsService.AddVfsRequest addVfs() {
        return new AddVfsRequestImpl();
    }

    @Override
    public StorageServerConnectionService storageConnectionService(String id) {
        return new StorageServerConnectionServiceImpl(this.getConnection(), this.getPath() + "/" + id);
    }

    @Override
    public Service service(String path) {
        if (path == null) {
            return this;
        }
        int index = path.indexOf(47);
        if (index == -1) {
            return this.storageConnectionService(path);
        }
        return this.storageConnectionService(path.substring(0, index)).service(path.substring(index + 1));
    }

    public String toString() {
        return "StorageServerConnectionsService:" + this.getPath();
    }

    private class AddVfsResponseImpl
    implements StorageServerConnectionsService.AddVfsResponse {
        private StorageConnection connection;

        private AddVfsResponseImpl() {
        }

        public void connection(StorageConnection connection) {
            this.connection = connection;
        }

        @Override
        public StorageConnection connection() {
            return this.connection;
        }
    }

    private class AddVfsRequestImpl
    extends BaseRequest<StorageServerConnectionsService.AddVfsRequest, StorageServerConnectionsService.AddVfsResponse>
    implements StorageServerConnectionsService.AddVfsRequest {
        private StorageConnection connection;

        private AddVfsRequestImpl() {
        }

        @Override
        public StorageServerConnectionsService.AddVfsRequest connection(StorageConnection connection) {
            this.connection = connection;
            return this;
        }

        @Override
        public StorageServerConnectionsService.AddVfsRequest connection(StorageConnectionBuilder connection) {
            this.connection = connection.build();
            return this;
        }

        @Override
        public StorageServerConnectionsService.AddVfsResponse send() {
            HttpResponse response;
            HttpPost request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(StorageServerConnectionsServiceImpl.this.getConnection().getUrl() + StorageServerConnectionsServiceImpl.this.getPath());
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpPost(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                XmlStorageConnectionWriter.writeOne(this.connection, xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to parse response", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = StorageServerConnectionsServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 201 || response.getStatusLine().getStatusCode() == 202) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        AddVfsResponseImpl actionResponse = new AddVfsResponseImpl();
                        actionResponse.connection(XmlStorageConnectionReader.readOne(reader));
                        AddVfsResponseImpl addVfsResponseImpl = actionResponse;
                        reader.close();
                        return addVfsResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            StorageServerConnectionsServiceImpl.this.checkFault(response);
            return new AddVfsResponseImpl();
        }
    }

    private class AddNfsResponseImpl
    implements StorageServerConnectionsService.AddNfsResponse {
        private StorageConnection connection;

        private AddNfsResponseImpl() {
        }

        public void connection(StorageConnection connection) {
            this.connection = connection;
        }

        @Override
        public StorageConnection connection() {
            return this.connection;
        }
    }

    private class AddNfsRequestImpl
    extends BaseRequest<StorageServerConnectionsService.AddNfsRequest, StorageServerConnectionsService.AddNfsResponse>
    implements StorageServerConnectionsService.AddNfsRequest {
        private StorageConnection connection;

        private AddNfsRequestImpl() {
        }

        @Override
        public StorageServerConnectionsService.AddNfsRequest connection(StorageConnection connection) {
            this.connection = connection;
            return this;
        }

        @Override
        public StorageServerConnectionsService.AddNfsRequest connection(StorageConnectionBuilder connection) {
            this.connection = connection.build();
            return this;
        }

        @Override
        public StorageServerConnectionsService.AddNfsResponse send() {
            HttpResponse response;
            HttpPost request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(StorageServerConnectionsServiceImpl.this.getConnection().getUrl() + StorageServerConnectionsServiceImpl.this.getPath());
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpPost(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                XmlStorageConnectionWriter.writeOne(this.connection, xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to parse response", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = StorageServerConnectionsServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 201 || response.getStatusLine().getStatusCode() == 202) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        AddNfsResponseImpl actionResponse = new AddNfsResponseImpl();
                        actionResponse.connection(XmlStorageConnectionReader.readOne(reader));
                        AddNfsResponseImpl addNfsResponseImpl = actionResponse;
                        reader.close();
                        return addNfsResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            StorageServerConnectionsServiceImpl.this.checkFault(response);
            return new AddNfsResponseImpl();
        }
    }

    private class AddLocalResponseImpl
    implements StorageServerConnectionsService.AddLocalResponse {
        private StorageConnection connection;

        private AddLocalResponseImpl() {
        }

        public void connection(StorageConnection connection) {
            this.connection = connection;
        }

        @Override
        public StorageConnection connection() {
            return this.connection;
        }
    }

    private class AddLocalRequestImpl
    extends BaseRequest<StorageServerConnectionsService.AddLocalRequest, StorageServerConnectionsService.AddLocalResponse>
    implements StorageServerConnectionsService.AddLocalRequest {
        private StorageConnection connection;

        private AddLocalRequestImpl() {
        }

        @Override
        public StorageServerConnectionsService.AddLocalRequest connection(StorageConnection connection) {
            this.connection = connection;
            return this;
        }

        @Override
        public StorageServerConnectionsService.AddLocalRequest connection(StorageConnectionBuilder connection) {
            this.connection = connection.build();
            return this;
        }

        @Override
        public StorageServerConnectionsService.AddLocalResponse send() {
            HttpResponse response;
            HttpPost request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(StorageServerConnectionsServiceImpl.this.getConnection().getUrl() + StorageServerConnectionsServiceImpl.this.getPath());
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpPost(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                XmlStorageConnectionWriter.writeOne(this.connection, xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to parse response", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = StorageServerConnectionsServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 201 || response.getStatusLine().getStatusCode() == 202) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        AddLocalResponseImpl actionResponse = new AddLocalResponseImpl();
                        actionResponse.connection(XmlStorageConnectionReader.readOne(reader));
                        AddLocalResponseImpl addLocalResponseImpl = actionResponse;
                        reader.close();
                        return addLocalResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            StorageServerConnectionsServiceImpl.this.checkFault(response);
            return new AddLocalResponseImpl();
        }
    }

    private class ListResponseImpl
    implements StorageServerConnectionsService.ListResponse {
        private List<StorageConnection> connections;

        private ListResponseImpl() {
        }

        public void connections(List<StorageConnection> connections) {
            this.connections = connections;
        }

        @Override
        public List<StorageConnection> connections() {
            return this.connections;
        }
    }

    private class ListRequestImpl
    extends BaseRequest<StorageServerConnectionsService.ListRequest, StorageServerConnectionsService.ListResponse>
    implements StorageServerConnectionsService.ListRequest {
        private String follow;
        private BigInteger max;

        private ListRequestImpl() {
        }

        @Override
        public StorageServerConnectionsService.ListRequest follow(String follow) {
            this.follow = follow;
            return this;
        }

        @Override
        public StorageServerConnectionsService.ListRequest max(BigInteger max) {
            this.max = max;
            return this;
        }

        @Override
        public StorageServerConnectionsService.ListRequest max(Integer max) {
            this.max = BigInteger.valueOf(max.intValue());
            return this;
        }

        @Override
        public StorageServerConnectionsService.ListRequest max(Long max) {
            this.max = BigInteger.valueOf(max);
            return this;
        }

        @Override
        public StorageServerConnectionsService.ListResponse send() {
            HttpResponse response;
            HttpGet request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(StorageServerConnectionsServiceImpl.this.getConnection().getUrl() + StorageServerConnectionsServiceImpl.this.getPath());
                if (this.follow != null) {
                    uriBuilder.addParameter("follow", XmlWriter.renderString(this.follow));
                }
                if (this.max != null) {
                    uriBuilder.addParameter("max", XmlWriter.renderInteger(this.max));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpGet(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = StorageServerConnectionsServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        ListResponseImpl actionResponse = new ListResponseImpl();
                        actionResponse.connections(XmlStorageConnectionReader.readMany(reader));
                        ListResponseImpl listResponseImpl = actionResponse;
                        reader.close();
                        return listResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            StorageServerConnectionsServiceImpl.this.checkFault(response);
            return new ListResponseImpl();
        }
    }

    private class AddIscsiResponseImpl
    implements StorageServerConnectionsService.AddIscsiResponse {
        private StorageConnection connection;

        private AddIscsiResponseImpl() {
        }

        public void connection(StorageConnection connection) {
            this.connection = connection;
        }

        @Override
        public StorageConnection connection() {
            return this.connection;
        }
    }

    private class AddIscsiRequestImpl
    extends BaseRequest<StorageServerConnectionsService.AddIscsiRequest, StorageServerConnectionsService.AddIscsiResponse>
    implements StorageServerConnectionsService.AddIscsiRequest {
        private StorageConnection connection;

        private AddIscsiRequestImpl() {
        }

        @Override
        public StorageServerConnectionsService.AddIscsiRequest connection(StorageConnection connection) {
            this.connection = connection;
            return this;
        }

        @Override
        public StorageServerConnectionsService.AddIscsiRequest connection(StorageConnectionBuilder connection) {
            this.connection = connection.build();
            return this;
        }

        @Override
        public StorageServerConnectionsService.AddIscsiResponse send() {
            HttpResponse response;
            HttpPost request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(StorageServerConnectionsServiceImpl.this.getConnection().getUrl() + StorageServerConnectionsServiceImpl.this.getPath());
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpPost(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                XmlStorageConnectionWriter.writeOne(this.connection, xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to parse response", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = StorageServerConnectionsServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 201 || response.getStatusLine().getStatusCode() == 202) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        AddIscsiResponseImpl actionResponse = new AddIscsiResponseImpl();
                        actionResponse.connection(XmlStorageConnectionReader.readOne(reader));
                        AddIscsiResponseImpl addIscsiResponseImpl = actionResponse;
                        reader.close();
                        return addIscsiResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            StorageServerConnectionsServiceImpl.this.checkFault(response);
            return new AddIscsiResponseImpl();
        }
    }

    private class AddGlusterfsResponseImpl
    implements StorageServerConnectionsService.AddGlusterfsResponse {
        private StorageConnection connection;

        private AddGlusterfsResponseImpl() {
        }

        public void connection(StorageConnection connection) {
            this.connection = connection;
        }

        @Override
        public StorageConnection connection() {
            return this.connection;
        }
    }

    private class AddGlusterfsRequestImpl
    extends BaseRequest<StorageServerConnectionsService.AddGlusterfsRequest, StorageServerConnectionsService.AddGlusterfsResponse>
    implements StorageServerConnectionsService.AddGlusterfsRequest {
        private StorageConnection connection;

        private AddGlusterfsRequestImpl() {
        }

        @Override
        public StorageServerConnectionsService.AddGlusterfsRequest connection(StorageConnection connection) {
            this.connection = connection;
            return this;
        }

        @Override
        public StorageServerConnectionsService.AddGlusterfsRequest connection(StorageConnectionBuilder connection) {
            this.connection = connection.build();
            return this;
        }

        @Override
        public StorageServerConnectionsService.AddGlusterfsResponse send() {
            HttpResponse response;
            HttpPost request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(StorageServerConnectionsServiceImpl.this.getConnection().getUrl() + StorageServerConnectionsServiceImpl.this.getPath());
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpPost(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                XmlStorageConnectionWriter.writeOne(this.connection, xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to parse response", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = StorageServerConnectionsServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 201 || response.getStatusLine().getStatusCode() == 202) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        AddGlusterfsResponseImpl actionResponse = new AddGlusterfsResponseImpl();
                        actionResponse.connection(XmlStorageConnectionReader.readOne(reader));
                        AddGlusterfsResponseImpl addGlusterfsResponseImpl = actionResponse;
                        reader.close();
                        return addGlusterfsResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            StorageServerConnectionsServiceImpl.this.checkFault(response);
            return new AddGlusterfsResponseImpl();
        }
    }

    private class AddResponseImpl
    implements StorageServerConnectionsService.AddResponse {
        private StorageConnection connection;

        private AddResponseImpl() {
        }

        public void connection(StorageConnection connection) {
            this.connection = connection;
        }

        @Override
        public StorageConnection connection() {
            return this.connection;
        }
    }

    private class AddRequestImpl
    extends BaseRequest<StorageServerConnectionsService.AddRequest, StorageServerConnectionsService.AddResponse>
    implements StorageServerConnectionsService.AddRequest {
        private StorageConnection connection;

        private AddRequestImpl() {
        }

        @Override
        public StorageServerConnectionsService.AddRequest connection(StorageConnection connection) {
            this.connection = connection;
            return this;
        }

        @Override
        public StorageServerConnectionsService.AddRequest connection(StorageConnectionBuilder connection) {
            this.connection = connection.build();
            return this;
        }

        @Override
        public StorageServerConnectionsService.AddResponse send() {
            HttpResponse response;
            HttpPost request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(StorageServerConnectionsServiceImpl.this.getConnection().getUrl() + StorageServerConnectionsServiceImpl.this.getPath());
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpPost(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                XmlStorageConnectionWriter.writeOne(this.connection, xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to parse response", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = StorageServerConnectionsServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 201 || response.getStatusLine().getStatusCode() == 202) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        AddResponseImpl actionResponse = new AddResponseImpl();
                        actionResponse.connection(XmlStorageConnectionReader.readOne(reader));
                        AddResponseImpl addResponseImpl = actionResponse;
                        reader.close();
                        return addResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            StorageServerConnectionsServiceImpl.this.checkFault(response);
            return new AddResponseImpl();
        }
    }
}

