/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.types;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum SerialNumberPolicy {
    CUSTOM("custom"),
    HOST("host"),
    NONE("none"),
    VM("vm");

    private static final Logger log;
    private String image;

    private SerialNumberPolicy(String image) {
        this.image = image;
    }

    public String value() {
        return this.image;
    }

    public static SerialNumberPolicy fromValue(String value) {
        try {
            return SerialNumberPolicy.valueOf(value.toUpperCase());
        }
        catch (IllegalArgumentException exception) {
            log.error("The string '" + value + "' isn't a valid value for the 'SerialNumberPolicy' enumerated type. Valid values are 'custom', 'host', 'none' and 'vm'.", (Throwable)exception);
            return null;
        }
    }

    static {
        log = LoggerFactory.getLogger(SerialNumberPolicy.class);
    }
}

