/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.builders;

import org.ovirt.engine.sdk4.internal.containers.RegistrationVnicProfileMappingContainer;
import org.ovirt.engine.sdk4.types.RegistrationVnicProfileMapping;
import org.ovirt.engine.sdk4.types.VnicProfile;

public class RegistrationVnicProfileMappingBuilder {
    private VnicProfile from;
    private VnicProfile to;
    
    public RegistrationVnicProfileMappingBuilder from(VnicProfile newFrom) {
        from = newFrom;
        return this;
    }
    
    public RegistrationVnicProfileMappingBuilder from(VnicProfileBuilder newFrom) {
        if (newFrom == null) {
            from = null;
        }
        else {
            from = newFrom.build();
        }
        return this;
    }
    
    
    public RegistrationVnicProfileMappingBuilder to(VnicProfile newTo) {
        to = newTo;
        return this;
    }
    
    public RegistrationVnicProfileMappingBuilder to(VnicProfileBuilder newTo) {
        if (newTo == null) {
            to = null;
        }
        else {
            to = newTo.build();
        }
        return this;
    }
    
    
    public RegistrationVnicProfileMapping build() {
        RegistrationVnicProfileMappingContainer container = new RegistrationVnicProfileMappingContainer();
        container.from(from);
        container.to(to);
        return container;
    }
}
