/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.services;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.util.EntityUtils;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.BaseRequest;
import org.ovirt.engine.sdk4.Error;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.builders.DiskProfileBuilder;
import org.ovirt.engine.sdk4.internal.HttpConnection;
import org.ovirt.engine.sdk4.internal.services.AssignedPermissionsServiceImpl;
import org.ovirt.engine.sdk4.internal.services.ServiceImpl;
import org.ovirt.engine.sdk4.internal.xml.XmlDiskProfileReader;
import org.ovirt.engine.sdk4.internal.xml.XmlDiskProfileWriter;
import org.ovirt.engine.sdk4.services.AssignedPermissionsService;
import org.ovirt.engine.sdk4.services.DiskProfileService;
import org.ovirt.engine.sdk4.types.DiskProfile;

public class DiskProfileServiceImpl
extends ServiceImpl
implements DiskProfileService {
    public DiskProfileServiceImpl(HttpConnection connection, String path) {
        super(connection, path);
    }

    @Override
    public DiskProfileService.GetRequest get() {
        return new GetRequestImpl();
    }

    @Override
    public DiskProfileService.RemoveRequest remove() {
        return new RemoveRequestImpl();
    }

    @Override
    public DiskProfileService.UpdateRequest update() {
        return new UpdateRequestImpl();
    }

    @Override
    public AssignedPermissionsService permissionsService() {
        return new AssignedPermissionsServiceImpl(this.getConnection(), this.getPath() + "/permissions");
    }

    @Override
    public Service service(String path) {
        if (path == null) {
            return this;
        }
        if (path.equals("permissions")) {
            return this.permissionsService();
        }
        if (path.startsWith("permissions/")) {
            return this.permissionsService().service(path.substring(12));
        }
        throw new Error("The path " + path + " doesn't correspond to any service");
    }

    public String toString() {
        return "DiskProfileService:" + this.getPath();
    }

    private class UpdateResponseImpl
    implements DiskProfileService.UpdateResponse {
        private DiskProfile profile;

        private UpdateResponseImpl() {
        }

        public void profile(DiskProfile profile) {
            this.profile = profile;
        }

        @Override
        public DiskProfile profile() {
            return this.profile;
        }
    }

    private class UpdateRequestImpl
    extends BaseRequest<DiskProfileService.UpdateRequest, DiskProfileService.UpdateResponse>
    implements DiskProfileService.UpdateRequest {
        private Boolean async;
        private DiskProfile profile;

        private UpdateRequestImpl() {
        }

        @Override
        public DiskProfileService.UpdateRequest async(Boolean async) {
            this.async = async;
            return this;
        }

        @Override
        public DiskProfileService.UpdateRequest profile(DiskProfile profile) {
            this.profile = profile;
            return this;
        }

        @Override
        public DiskProfileService.UpdateRequest profile(DiskProfileBuilder profile) {
            this.profile = profile.build();
            return this;
        }

        @Override
        public DiskProfileService.UpdateResponse send() {
            HttpResponse response;
            HttpPut request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(DiskProfileServiceImpl.this.getConnection().getUrl() + DiskProfileServiceImpl.this.getPath());
                if (this.async != null) {
                    uriBuilder.addParameter("async", XmlWriter.renderBoolean(this.async));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpPut(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                XmlDiskProfileWriter.writeOne(this.profile, xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to parse response", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = DiskProfileServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        UpdateResponseImpl actionResponse = new UpdateResponseImpl();
                        actionResponse.profile(XmlDiskProfileReader.readOne(reader));
                        UpdateResponseImpl updateResponseImpl = actionResponse;
                        reader.close();
                        return updateResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            DiskProfileServiceImpl.this.checkFault(response);
            return new UpdateResponseImpl();
        }
    }

    private class RemoveResponseImpl
    implements DiskProfileService.RemoveResponse {
        private RemoveResponseImpl() {
        }
    }

    private class RemoveRequestImpl
    extends BaseRequest<DiskProfileService.RemoveRequest, DiskProfileService.RemoveResponse>
    implements DiskProfileService.RemoveRequest {
        private Boolean async;

        private RemoveRequestImpl() {
        }

        @Override
        public DiskProfileService.RemoveRequest async(Boolean async) {
            this.async = async;
            return this;
        }

        @Override
        public DiskProfileService.RemoveResponse send() {
            HttpResponse response;
            HttpDelete request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(DiskProfileServiceImpl.this.getConnection().getUrl() + DiskProfileServiceImpl.this.getPath());
                if (this.async != null) {
                    uriBuilder.addParameter("async", XmlWriter.renderBoolean(this.async));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpDelete(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = DiskProfileServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                return new RemoveResponseImpl();
            }
            DiskProfileServiceImpl.this.checkFault(response);
            return new RemoveResponseImpl();
        }
    }

    private class GetResponseImpl
    implements DiskProfileService.GetResponse {
        private DiskProfile profile;

        private GetResponseImpl() {
        }

        public void profile(DiskProfile profile) {
            this.profile = profile;
        }

        @Override
        public DiskProfile profile() {
            return this.profile;
        }
    }

    private class GetRequestImpl
    extends BaseRequest<DiskProfileService.GetRequest, DiskProfileService.GetResponse>
    implements DiskProfileService.GetRequest {
        private String follow;

        private GetRequestImpl() {
        }

        @Override
        public DiskProfileService.GetRequest follow(String follow) {
            this.follow = follow;
            return this;
        }

        @Override
        public DiskProfileService.GetResponse send() {
            HttpResponse response;
            HttpGet request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(DiskProfileServiceImpl.this.getConnection().getUrl() + DiskProfileServiceImpl.this.getPath());
                if (this.follow != null) {
                    uriBuilder.addParameter("follow", XmlWriter.renderString(this.follow));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpGet(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = DiskProfileServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        GetResponseImpl actionResponse = new GetResponseImpl();
                        actionResponse.profile(XmlDiskProfileReader.readOne(reader));
                        GetResponseImpl getResponseImpl = actionResponse;
                        reader.close();
                        return getResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            DiskProfileServiceImpl.this.checkFault(response);
            return new GetResponseImpl();
        }
    }
}

