/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.services;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.util.EntityUtils;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.BaseRequest;
import org.ovirt.engine.sdk4.Error;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.builders.ActionBuilder;
import org.ovirt.engine.sdk4.builders.HostBuilder;
import org.ovirt.engine.sdk4.internal.HttpConnection;
import org.ovirt.engine.sdk4.internal.services.ServiceImpl;
import org.ovirt.engine.sdk4.internal.xml.XmlActionWriter;
import org.ovirt.engine.sdk4.internal.xml.XmlGlusterHookReader;
import org.ovirt.engine.sdk4.services.GlusterHookService;
import org.ovirt.engine.sdk4.types.Action;
import org.ovirt.engine.sdk4.types.GlusterHook;
import org.ovirt.engine.sdk4.types.Host;

public class GlusterHookServiceImpl
extends ServiceImpl
implements GlusterHookService {
    public GlusterHookServiceImpl(HttpConnection connection, String path) {
        super(connection, path);
    }

    @Override
    public GlusterHookService.DisableRequest disable() {
        return new DisableRequestImpl();
    }

    @Override
    public GlusterHookService.EnableRequest enable() {
        return new EnableRequestImpl();
    }

    @Override
    public GlusterHookService.GetRequest get() {
        return new GetRequestImpl();
    }

    @Override
    public GlusterHookService.RemoveRequest remove() {
        return new RemoveRequestImpl();
    }

    @Override
    public GlusterHookService.ResolveRequest resolve() {
        return new ResolveRequestImpl();
    }

    @Override
    public Service service(String path) {
        if (path == null) {
            return this;
        }
        throw new Error("The path " + path + " doesn't correspond to any service");
    }

    public String toString() {
        return "GlusterHookService:" + this.getPath();
    }

    private class ResolveResponseImpl
    implements GlusterHookService.ResolveResponse {
        private ResolveResponseImpl() {
        }
    }

    private class ResolveRequestImpl
    extends BaseRequest<GlusterHookService.ResolveRequest, GlusterHookService.ResolveResponse>
    implements GlusterHookService.ResolveRequest {
        private Boolean async;
        private Host host;
        private String resolutionType;

        private ResolveRequestImpl() {
        }

        @Override
        public GlusterHookService.ResolveRequest async(Boolean async) {
            this.async = async;
            return this;
        }

        @Override
        public GlusterHookService.ResolveRequest host(Host host) {
            this.host = host;
            return this;
        }

        @Override
        public GlusterHookService.ResolveRequest host(HostBuilder host) {
            this.host = host.build();
            return this;
        }

        @Override
        public GlusterHookService.ResolveRequest resolutionType(String resolutionType) {
            this.resolutionType = resolutionType;
            return this;
        }

        @Override
        public GlusterHookService.ResolveResponse send() {
            HttpPost request = new HttpPost(GlusterHookServiceImpl.this.getConnection().getUrl() + GlusterHookServiceImpl.this.getPath() + "/resolve");
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                ActionBuilder action = new ActionBuilder();
                action.async(this.async);
                action.host(this.host);
                action.resolutionType(this.resolutionType);
                XmlActionWriter.writeOne(action.build(), xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to write request", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            HttpResponse response = GlusterHookServiceImpl.this.getConnection().send((HttpUriRequest)request);
            Action action = GlusterHookServiceImpl.this.checkAction(response);
            EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            return new ResolveResponseImpl();
        }
    }

    private class RemoveResponseImpl
    implements GlusterHookService.RemoveResponse {
        private RemoveResponseImpl() {
        }
    }

    private class RemoveRequestImpl
    extends BaseRequest<GlusterHookService.RemoveRequest, GlusterHookService.RemoveResponse>
    implements GlusterHookService.RemoveRequest {
        private Boolean async;

        private RemoveRequestImpl() {
        }

        @Override
        public GlusterHookService.RemoveRequest async(Boolean async) {
            this.async = async;
            return this;
        }

        @Override
        public GlusterHookService.RemoveResponse send() {
            HttpResponse response;
            HttpDelete request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(GlusterHookServiceImpl.this.getConnection().getUrl() + GlusterHookServiceImpl.this.getPath());
                if (this.async != null) {
                    uriBuilder.addParameter("async", XmlWriter.renderBoolean(this.async));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpDelete(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = GlusterHookServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                return new RemoveResponseImpl();
            }
            GlusterHookServiceImpl.this.checkFault(response);
            return new RemoveResponseImpl();
        }
    }

    private class GetResponseImpl
    implements GlusterHookService.GetResponse {
        private GlusterHook hook;

        private GetResponseImpl() {
        }

        public void hook(GlusterHook hook) {
            this.hook = hook;
        }

        @Override
        public GlusterHook hook() {
            return this.hook;
        }
    }

    private class GetRequestImpl
    extends BaseRequest<GlusterHookService.GetRequest, GlusterHookService.GetResponse>
    implements GlusterHookService.GetRequest {
        private String follow;

        private GetRequestImpl() {
        }

        @Override
        public GlusterHookService.GetRequest follow(String follow) {
            this.follow = follow;
            return this;
        }

        @Override
        public GlusterHookService.GetResponse send() {
            HttpResponse response;
            HttpGet request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(GlusterHookServiceImpl.this.getConnection().getUrl() + GlusterHookServiceImpl.this.getPath());
                if (this.follow != null) {
                    uriBuilder.addParameter("follow", XmlWriter.renderString(this.follow));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpGet(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = GlusterHookServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        GetResponseImpl actionResponse = new GetResponseImpl();
                        actionResponse.hook(XmlGlusterHookReader.readOne(reader));
                        GetResponseImpl getResponseImpl = actionResponse;
                        reader.close();
                        return getResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            GlusterHookServiceImpl.this.checkFault(response);
            return new GetResponseImpl();
        }
    }

    private class EnableResponseImpl
    implements GlusterHookService.EnableResponse {
        private EnableResponseImpl() {
        }
    }

    private class EnableRequestImpl
    extends BaseRequest<GlusterHookService.EnableRequest, GlusterHookService.EnableResponse>
    implements GlusterHookService.EnableRequest {
        private Boolean async;

        private EnableRequestImpl() {
        }

        @Override
        public GlusterHookService.EnableRequest async(Boolean async) {
            this.async = async;
            return this;
        }

        @Override
        public GlusterHookService.EnableResponse send() {
            HttpPost request = new HttpPost(GlusterHookServiceImpl.this.getConnection().getUrl() + GlusterHookServiceImpl.this.getPath() + "/enable");
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                ActionBuilder action = new ActionBuilder();
                action.async(this.async);
                XmlActionWriter.writeOne(action.build(), xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to write request", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            HttpResponse response = GlusterHookServiceImpl.this.getConnection().send((HttpUriRequest)request);
            Action action = GlusterHookServiceImpl.this.checkAction(response);
            EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            return new EnableResponseImpl();
        }
    }

    private class DisableResponseImpl
    implements GlusterHookService.DisableResponse {
        private DisableResponseImpl() {
        }
    }

    private class DisableRequestImpl
    extends BaseRequest<GlusterHookService.DisableRequest, GlusterHookService.DisableResponse>
    implements GlusterHookService.DisableRequest {
        private Boolean async;

        private DisableRequestImpl() {
        }

        @Override
        public GlusterHookService.DisableRequest async(Boolean async) {
            this.async = async;
            return this;
        }

        @Override
        public GlusterHookService.DisableResponse send() {
            HttpPost request = new HttpPost(GlusterHookServiceImpl.this.getConnection().getUrl() + GlusterHookServiceImpl.this.getPath() + "/disable");
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                ActionBuilder action = new ActionBuilder();
                action.async(this.async);
                XmlActionWriter.writeOne(action.build(), xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to write request", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            HttpResponse response = GlusterHookServiceImpl.this.getConnection().send((HttpUriRequest)request);
            Action action = GlusterHookServiceImpl.this.checkAction(response);
            EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            return new DisableResponseImpl();
        }
    }
}

