/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.services;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.util.EntityUtils;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.BaseRequest;
import org.ovirt.engine.sdk4.Error;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.internal.HttpConnection;
import org.ovirt.engine.sdk4.internal.services.MeasurableServiceImpl;
import org.ovirt.engine.sdk4.internal.services.StatisticsServiceImpl;
import org.ovirt.engine.sdk4.internal.xml.XmlNumaNodeReader;
import org.ovirt.engine.sdk4.services.HostNumaNodeService;
import org.ovirt.engine.sdk4.services.StatisticsService;
import org.ovirt.engine.sdk4.types.NumaNode;

public class HostNumaNodeServiceImpl
extends MeasurableServiceImpl
implements HostNumaNodeService {
    public HostNumaNodeServiceImpl(HttpConnection connection, String path) {
        super(connection, path);
    }

    @Override
    public HostNumaNodeService.GetRequest get() {
        return new GetRequestImpl();
    }

    @Override
    public StatisticsService statisticsService() {
        return new StatisticsServiceImpl(this.getConnection(), this.getPath() + "/statistics");
    }

    @Override
    public Service service(String path) {
        if (path == null) {
            return this;
        }
        if (path.equals("statistics")) {
            return this.statisticsService();
        }
        if (path.startsWith("statistics/")) {
            return this.statisticsService().service(path.substring(11));
        }
        throw new Error("The path " + path + " doesn't correspond to any service");
    }

    @Override
    public String toString() {
        return "HostNumaNodeService:" + this.getPath();
    }

    private class GetResponseImpl
    implements HostNumaNodeService.GetResponse {
        private NumaNode node;

        private GetResponseImpl() {
        }

        public void node(NumaNode node) {
            this.node = node;
        }

        @Override
        public NumaNode node() {
            return this.node;
        }
    }

    private class GetRequestImpl
    extends BaseRequest<HostNumaNodeService.GetRequest, HostNumaNodeService.GetResponse>
    implements HostNumaNodeService.GetRequest {
        private String follow;

        private GetRequestImpl() {
        }

        @Override
        public HostNumaNodeService.GetRequest follow(String follow) {
            this.follow = follow;
            return this;
        }

        @Override
        public HostNumaNodeService.GetResponse send() {
            HttpResponse response;
            HttpGet request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(HostNumaNodeServiceImpl.this.getConnection().getUrl() + HostNumaNodeServiceImpl.this.getPath());
                if (this.follow != null) {
                    uriBuilder.addParameter("follow", XmlWriter.renderString(this.follow));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpGet(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = HostNumaNodeServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        GetResponseImpl actionResponse = new GetResponseImpl();
                        actionResponse.node(XmlNumaNodeReader.readOne(reader));
                        GetResponseImpl getResponseImpl = actionResponse;
                        reader.close();
                        return getResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            HostNumaNodeServiceImpl.this.checkFault(response);
            return new GetResponseImpl();
        }
    }
}

