/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.services;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.util.EntityUtils;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.BaseRequest;
import org.ovirt.engine.sdk4.Error;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.builders.VirtualNumaNodeBuilder;
import org.ovirt.engine.sdk4.internal.HttpConnection;
import org.ovirt.engine.sdk4.internal.services.ServiceImpl;
import org.ovirt.engine.sdk4.internal.services.VmNumaNodeServiceImpl;
import org.ovirt.engine.sdk4.internal.xml.XmlVirtualNumaNodeReader;
import org.ovirt.engine.sdk4.internal.xml.XmlVirtualNumaNodeWriter;
import org.ovirt.engine.sdk4.services.VmNumaNodeService;
import org.ovirt.engine.sdk4.services.VmNumaNodesService;
import org.ovirt.engine.sdk4.types.VirtualNumaNode;

public class VmNumaNodesServiceImpl
extends ServiceImpl
implements VmNumaNodesService {
    public VmNumaNodesServiceImpl(HttpConnection connection, String path) {
        super(connection, path);
    }

    @Override
    public VmNumaNodesService.AddRequest add() {
        return new AddRequestImpl();
    }

    @Override
    public VmNumaNodesService.ListRequest list() {
        return new ListRequestImpl();
    }

    @Override
    public VmNumaNodeService nodeService(String id) {
        return new VmNumaNodeServiceImpl(this.getConnection(), this.getPath() + "/" + id);
    }

    @Override
    public Service service(String path) {
        if (path == null) {
            return this;
        }
        int index = path.indexOf(47);
        if (index == -1) {
            return this.nodeService(path);
        }
        return this.nodeService(path.substring(0, index)).service(path.substring(index + 1));
    }

    public String toString() {
        return "VmNumaNodesService:" + this.getPath();
    }

    private class ListResponseImpl
    implements VmNumaNodesService.ListResponse {
        private List<VirtualNumaNode> nodes;

        private ListResponseImpl() {
        }

        public void nodes(List<VirtualNumaNode> nodes) {
            this.nodes = nodes;
        }

        @Override
        public List<VirtualNumaNode> nodes() {
            return this.nodes;
        }
    }

    private class ListRequestImpl
    extends BaseRequest<VmNumaNodesService.ListRequest, VmNumaNodesService.ListResponse>
    implements VmNumaNodesService.ListRequest {
        private String follow;
        private BigInteger max;

        private ListRequestImpl() {
        }

        @Override
        public VmNumaNodesService.ListRequest follow(String follow) {
            this.follow = follow;
            return this;
        }

        @Override
        public VmNumaNodesService.ListRequest max(BigInteger max) {
            this.max = max;
            return this;
        }

        @Override
        public VmNumaNodesService.ListRequest max(Integer max) {
            this.max = BigInteger.valueOf(max.intValue());
            return this;
        }

        @Override
        public VmNumaNodesService.ListRequest max(Long max) {
            this.max = BigInteger.valueOf(max);
            return this;
        }

        @Override
        public VmNumaNodesService.ListResponse send() {
            HttpResponse response;
            HttpGet request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(VmNumaNodesServiceImpl.this.getConnection().getUrl() + VmNumaNodesServiceImpl.this.getPath());
                if (this.follow != null) {
                    uriBuilder.addParameter("follow", XmlWriter.renderString(this.follow));
                }
                if (this.max != null) {
                    uriBuilder.addParameter("max", XmlWriter.renderInteger(this.max));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpGet(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = VmNumaNodesServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        ListResponseImpl actionResponse = new ListResponseImpl();
                        actionResponse.nodes(XmlVirtualNumaNodeReader.readMany(reader));
                        ListResponseImpl listResponseImpl = actionResponse;
                        reader.close();
                        return listResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            VmNumaNodesServiceImpl.this.checkFault(response);
            return new ListResponseImpl();
        }
    }

    private class AddResponseImpl
    implements VmNumaNodesService.AddResponse {
        private VirtualNumaNode node;

        private AddResponseImpl() {
        }

        public void node(VirtualNumaNode node) {
            this.node = node;
        }

        @Override
        public VirtualNumaNode node() {
            return this.node;
        }
    }

    private class AddRequestImpl
    extends BaseRequest<VmNumaNodesService.AddRequest, VmNumaNodesService.AddResponse>
    implements VmNumaNodesService.AddRequest {
        private VirtualNumaNode node;

        private AddRequestImpl() {
        }

        @Override
        public VmNumaNodesService.AddRequest node(VirtualNumaNode node) {
            this.node = node;
            return this;
        }

        @Override
        public VmNumaNodesService.AddRequest node(VirtualNumaNodeBuilder node) {
            this.node = node.build();
            return this;
        }

        @Override
        public VmNumaNodesService.AddResponse send() {
            HttpResponse response;
            HttpPost request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(VmNumaNodesServiceImpl.this.getConnection().getUrl() + VmNumaNodesServiceImpl.this.getPath());
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpPost(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                XmlVirtualNumaNodeWriter.writeOne(this.node, xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to parse response", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = VmNumaNodesServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200 || response.getStatusLine().getStatusCode() == 201 || response.getStatusLine().getStatusCode() == 202) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        AddResponseImpl actionResponse = new AddResponseImpl();
                        actionResponse.node(XmlVirtualNumaNodeReader.readOne(reader));
                        AddResponseImpl addResponseImpl = actionResponse;
                        reader.close();
                        return addResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            VmNumaNodesServiceImpl.this.checkFault(response);
            return new AddResponseImpl();
        }
    }
}

