/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.services;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.util.EntityUtils;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.BaseRequest;
import org.ovirt.engine.sdk4.Error;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.builders.ActionBuilder;
import org.ovirt.engine.sdk4.builders.StorageDomainBuilder;
import org.ovirt.engine.sdk4.internal.HttpConnection;
import org.ovirt.engine.sdk4.internal.services.ServiceImpl;
import org.ovirt.engine.sdk4.internal.xml.XmlActionWriter;
import org.ovirt.engine.sdk4.internal.xml.XmlDiskReader;
import org.ovirt.engine.sdk4.services.TemplateDiskService;
import org.ovirt.engine.sdk4.types.Action;
import org.ovirt.engine.sdk4.types.Disk;
import org.ovirt.engine.sdk4.types.StorageDomain;

public class TemplateDiskServiceImpl
extends ServiceImpl
implements TemplateDiskService {
    public TemplateDiskServiceImpl(HttpConnection connection, String path) {
        super(connection, path);
    }

    @Override
    public TemplateDiskService.CopyRequest copy() {
        return new CopyRequestImpl();
    }

    @Override
    public TemplateDiskService.ExportRequest export() {
        return new ExportRequestImpl();
    }

    @Override
    public TemplateDiskService.GetRequest get() {
        return new GetRequestImpl();
    }

    @Override
    public TemplateDiskService.RemoveRequest remove() {
        return new RemoveRequestImpl();
    }

    @Override
    public Service service(String path) {
        if (path == null) {
            return this;
        }
        throw new Error("The path " + path + " doesn't correspond to any service");
    }

    public String toString() {
        return "TemplateDiskService:" + this.getPath();
    }

    private class RemoveResponseImpl
    implements TemplateDiskService.RemoveResponse {
        private RemoveResponseImpl() {
        }
    }

    private class RemoveRequestImpl
    extends BaseRequest<TemplateDiskService.RemoveRequest, TemplateDiskService.RemoveResponse>
    implements TemplateDiskService.RemoveRequest {
        private Boolean async;

        private RemoveRequestImpl() {
        }

        @Override
        public TemplateDiskService.RemoveRequest async(Boolean async) {
            this.async = async;
            return this;
        }

        @Override
        public TemplateDiskService.RemoveResponse send() {
            HttpResponse response;
            HttpDelete request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(TemplateDiskServiceImpl.this.getConnection().getUrl() + TemplateDiskServiceImpl.this.getPath());
                if (this.async != null) {
                    uriBuilder.addParameter("async", XmlWriter.renderBoolean(this.async));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpDelete(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = TemplateDiskServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                return new RemoveResponseImpl();
            }
            TemplateDiskServiceImpl.this.checkFault(response);
            return new RemoveResponseImpl();
        }
    }

    private class GetResponseImpl
    implements TemplateDiskService.GetResponse {
        private Disk disk;

        private GetResponseImpl() {
        }

        public void disk(Disk disk) {
            this.disk = disk;
        }

        @Override
        public Disk disk() {
            return this.disk;
        }
    }

    private class GetRequestImpl
    extends BaseRequest<TemplateDiskService.GetRequest, TemplateDiskService.GetResponse>
    implements TemplateDiskService.GetRequest {
        private String follow;

        private GetRequestImpl() {
        }

        @Override
        public TemplateDiskService.GetRequest follow(String follow) {
            this.follow = follow;
            return this;
        }

        @Override
        public TemplateDiskService.GetResponse send() {
            HttpResponse response;
            HttpGet request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(TemplateDiskServiceImpl.this.getConnection().getUrl() + TemplateDiskServiceImpl.this.getPath());
                if (this.follow != null) {
                    uriBuilder.addParameter("follow", XmlWriter.renderString(this.follow));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpGet(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = TemplateDiskServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        GetResponseImpl actionResponse = new GetResponseImpl();
                        actionResponse.disk(XmlDiskReader.readOne(reader));
                        GetResponseImpl getResponseImpl = actionResponse;
                        reader.close();
                        return getResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            TemplateDiskServiceImpl.this.checkFault(response);
            return new GetResponseImpl();
        }
    }

    private class ExportResponseImpl
    implements TemplateDiskService.ExportResponse {
        private ExportResponseImpl() {
        }
    }

    private class ExportRequestImpl
    extends BaseRequest<TemplateDiskService.ExportRequest, TemplateDiskService.ExportResponse>
    implements TemplateDiskService.ExportRequest {
        private Boolean async;
        private Boolean filter;
        private StorageDomain storageDomain;

        private ExportRequestImpl() {
        }

        @Override
        public TemplateDiskService.ExportRequest async(Boolean async) {
            this.async = async;
            return this;
        }

        @Override
        public TemplateDiskService.ExportRequest filter(Boolean filter) {
            this.filter = filter;
            return this;
        }

        @Override
        public TemplateDiskService.ExportRequest storageDomain(StorageDomain storageDomain) {
            this.storageDomain = storageDomain;
            return this;
        }

        @Override
        public TemplateDiskService.ExportRequest storageDomain(StorageDomainBuilder storageDomain) {
            this.storageDomain = storageDomain.build();
            return this;
        }

        @Override
        public TemplateDiskService.ExportResponse send() {
            HttpPost request = new HttpPost(TemplateDiskServiceImpl.this.getConnection().getUrl() + TemplateDiskServiceImpl.this.getPath() + "/export");
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                ActionBuilder action = new ActionBuilder();
                action.async(this.async);
                action.filter(this.filter);
                action.storageDomain(this.storageDomain);
                XmlActionWriter.writeOne(action.build(), xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to write request", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            HttpResponse response = TemplateDiskServiceImpl.this.getConnection().send((HttpUriRequest)request);
            Action action = TemplateDiskServiceImpl.this.checkAction(response);
            EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            return new ExportResponseImpl();
        }
    }

    private class CopyResponseImpl
    implements TemplateDiskService.CopyResponse {
        private CopyResponseImpl() {
        }
    }

    private class CopyRequestImpl
    extends BaseRequest<TemplateDiskService.CopyRequest, TemplateDiskService.CopyResponse>
    implements TemplateDiskService.CopyRequest {
        private Boolean async;
        private Boolean filter;
        private StorageDomain storageDomain;

        private CopyRequestImpl() {
        }

        @Override
        public TemplateDiskService.CopyRequest async(Boolean async) {
            this.async = async;
            return this;
        }

        @Override
        public TemplateDiskService.CopyRequest filter(Boolean filter) {
            this.filter = filter;
            return this;
        }

        @Override
        public TemplateDiskService.CopyRequest storageDomain(StorageDomain storageDomain) {
            this.storageDomain = storageDomain;
            return this;
        }

        @Override
        public TemplateDiskService.CopyRequest storageDomain(StorageDomainBuilder storageDomain) {
            this.storageDomain = storageDomain.build();
            return this;
        }

        @Override
        public TemplateDiskService.CopyResponse send() {
            HttpPost request = new HttpPost(TemplateDiskServiceImpl.this.getConnection().getUrl() + TemplateDiskServiceImpl.this.getPath() + "/copy");
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                ActionBuilder action = new ActionBuilder();
                action.async(this.async);
                action.filter(this.filter);
                action.storageDomain(this.storageDomain);
                XmlActionWriter.writeOne(action.build(), xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to write request", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            HttpResponse response = TemplateDiskServiceImpl.this.getConnection().send((HttpUriRequest)request);
            Action action = TemplateDiskServiceImpl.this.checkAction(response);
            EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
            return new CopyResponseImpl();
        }
    }
}

