/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.internal.containers;

import java.lang.String;
import org.ovirt.engine.sdk4.types.Hook;
import org.ovirt.engine.sdk4.types.Host;

public class HookContainer extends IdentifiedContainer implements Hook {
    private String eventName;
    private String md5;
    private Host host;
    
    public String eventName() {
        return eventName;
    }
    
    public void eventName(String newEventName) {
        eventName = newEventName;
    }
    
    public boolean eventNamePresent() {
        return eventName != null;
    }
    
    public String md5() {
        return md5;
    }
    
    public void md5(String newMd5) {
        md5 = newMd5;
    }
    
    public boolean md5Present() {
        return md5 != null;
    }
    
    public Host host() {
        return host;
    }
    
    public void host(Host newHost) {
        host = newHost;
    }
    
    public boolean hostPresent() {
        return host != null;
    }
    
}
