/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.internal.services;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.util.EntityUtils;
import org.ovirt.api.metamodel.runtime.xml.XmlReader;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.BaseRequest;
import org.ovirt.engine.sdk4.Error;
import org.ovirt.engine.sdk4.Service;
import org.ovirt.engine.sdk4.builders.StorageConnectionBuilder;
import org.ovirt.engine.sdk4.internal.HttpConnection;
import org.ovirt.engine.sdk4.internal.services.ServiceImpl;
import org.ovirt.engine.sdk4.internal.xml.XmlStorageConnectionReader;
import org.ovirt.engine.sdk4.internal.xml.XmlStorageConnectionWriter;
import org.ovirt.engine.sdk4.services.StorageServerConnectionService;
import org.ovirt.engine.sdk4.types.StorageConnection;

public class StorageServerConnectionServiceImpl
extends ServiceImpl
implements StorageServerConnectionService {
    public StorageServerConnectionServiceImpl(HttpConnection connection, String path) {
        super(connection, path);
    }

    @Override
    public StorageServerConnectionService.GetRequest get() {
        return new GetRequestImpl();
    }

    @Override
    public StorageServerConnectionService.UpdateGlusterfsRequest updateGlusterfs() {
        return new UpdateGlusterfsRequestImpl();
    }

    @Override
    public StorageServerConnectionService.UpdateIscsiRequest updateIscsi() {
        return new UpdateIscsiRequestImpl();
    }

    @Override
    public StorageServerConnectionService.UpdateLocalRequest updateLocal() {
        return new UpdateLocalRequestImpl();
    }

    @Override
    public StorageServerConnectionService.UpdateNfsRequest updateNfs() {
        return new UpdateNfsRequestImpl();
    }

    @Override
    public StorageServerConnectionService.RemoveRequest remove() {
        return new RemoveRequestImpl();
    }

    @Override
    public StorageServerConnectionService.UpdateRequest update() {
        return new UpdateRequestImpl();
    }

    @Override
    public StorageServerConnectionService.UpdateVfsRequest updateVfs() {
        return new UpdateVfsRequestImpl();
    }

    @Override
    public Service service(String path) {
        if (path == null) {
            return this;
        }
        throw new Error("The path " + path + " doesn't correspond to any service");
    }

    public String toString() {
        return "StorageServerConnectionService:" + this.getPath();
    }

    private class UpdateVfsResponseImpl
    implements StorageServerConnectionService.UpdateVfsResponse {
        private StorageConnection connection;

        private UpdateVfsResponseImpl() {
        }

        public void connection(StorageConnection connection) {
            this.connection = connection;
        }

        @Override
        public StorageConnection connection() {
            return this.connection;
        }
    }

    private class UpdateVfsRequestImpl
    extends BaseRequest<StorageServerConnectionService.UpdateVfsRequest, StorageServerConnectionService.UpdateVfsResponse>
    implements StorageServerConnectionService.UpdateVfsRequest {
        private Boolean async;
        private StorageConnection connection;
        private Boolean force;

        private UpdateVfsRequestImpl() {
        }

        @Override
        public StorageServerConnectionService.UpdateVfsRequest async(Boolean async) {
            this.async = async;
            return this;
        }

        @Override
        public StorageServerConnectionService.UpdateVfsRequest connection(StorageConnection connection) {
            this.connection = connection;
            return this;
        }

        @Override
        public StorageServerConnectionService.UpdateVfsRequest connection(StorageConnectionBuilder connection) {
            this.connection = connection.build();
            return this;
        }

        @Override
        public StorageServerConnectionService.UpdateVfsRequest force(Boolean force) {
            this.force = force;
            return this;
        }

        @Override
        public StorageServerConnectionService.UpdateVfsResponse send() {
            HttpResponse response;
            HttpPut request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(StorageServerConnectionServiceImpl.this.getConnection().getUrl() + StorageServerConnectionServiceImpl.this.getPath());
                if (this.async != null) {
                    uriBuilder.addParameter("async", XmlWriter.renderBoolean(this.async));
                }
                if (this.force != null) {
                    uriBuilder.addParameter("force", XmlWriter.renderBoolean(this.force));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpPut(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                XmlStorageConnectionWriter.writeOne(this.connection, xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to parse response", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = StorageServerConnectionServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        UpdateVfsResponseImpl actionResponse = new UpdateVfsResponseImpl();
                        actionResponse.connection(XmlStorageConnectionReader.readOne(reader));
                        UpdateVfsResponseImpl updateVfsResponseImpl = actionResponse;
                        reader.close();
                        return updateVfsResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            StorageServerConnectionServiceImpl.this.checkFault(response);
            return new UpdateVfsResponseImpl();
        }
    }

    private class UpdateResponseImpl
    implements StorageServerConnectionService.UpdateResponse {
        private StorageConnection connection;

        private UpdateResponseImpl() {
        }

        public void connection(StorageConnection connection) {
            this.connection = connection;
        }

        @Override
        public StorageConnection connection() {
            return this.connection;
        }
    }

    private class UpdateRequestImpl
    extends BaseRequest<StorageServerConnectionService.UpdateRequest, StorageServerConnectionService.UpdateResponse>
    implements StorageServerConnectionService.UpdateRequest {
        private Boolean async;
        private StorageConnection connection;
        private Boolean force;

        private UpdateRequestImpl() {
        }

        @Override
        public StorageServerConnectionService.UpdateRequest async(Boolean async) {
            this.async = async;
            return this;
        }

        @Override
        public StorageServerConnectionService.UpdateRequest connection(StorageConnection connection) {
            this.connection = connection;
            return this;
        }

        @Override
        public StorageServerConnectionService.UpdateRequest connection(StorageConnectionBuilder connection) {
            this.connection = connection.build();
            return this;
        }

        @Override
        public StorageServerConnectionService.UpdateRequest force(Boolean force) {
            this.force = force;
            return this;
        }

        @Override
        public StorageServerConnectionService.UpdateResponse send() {
            HttpResponse response;
            HttpPut request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(StorageServerConnectionServiceImpl.this.getConnection().getUrl() + StorageServerConnectionServiceImpl.this.getPath());
                if (this.async != null) {
                    uriBuilder.addParameter("async", XmlWriter.renderBoolean(this.async));
                }
                if (this.force != null) {
                    uriBuilder.addParameter("force", XmlWriter.renderBoolean(this.force));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpPut(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                XmlStorageConnectionWriter.writeOne(this.connection, xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to parse response", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = StorageServerConnectionServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        UpdateResponseImpl actionResponse = new UpdateResponseImpl();
                        actionResponse.connection(XmlStorageConnectionReader.readOne(reader));
                        UpdateResponseImpl updateResponseImpl = actionResponse;
                        reader.close();
                        return updateResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            StorageServerConnectionServiceImpl.this.checkFault(response);
            return new UpdateResponseImpl();
        }
    }

    private class RemoveResponseImpl
    implements StorageServerConnectionService.RemoveResponse {
        private RemoveResponseImpl() {
        }
    }

    private class RemoveRequestImpl
    extends BaseRequest<StorageServerConnectionService.RemoveRequest, StorageServerConnectionService.RemoveResponse>
    implements StorageServerConnectionService.RemoveRequest {
        private Boolean async;
        private String host;

        private RemoveRequestImpl() {
        }

        @Override
        public StorageServerConnectionService.RemoveRequest async(Boolean async) {
            this.async = async;
            return this;
        }

        @Override
        public StorageServerConnectionService.RemoveRequest host(String host) {
            this.host = host;
            return this;
        }

        @Override
        public StorageServerConnectionService.RemoveResponse send() {
            HttpResponse response;
            HttpDelete request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(StorageServerConnectionServiceImpl.this.getConnection().getUrl() + StorageServerConnectionServiceImpl.this.getPath());
                if (this.async != null) {
                    uriBuilder.addParameter("async", XmlWriter.renderBoolean(this.async));
                }
                if (this.host != null) {
                    uriBuilder.addParameter("host", XmlWriter.renderString(this.host));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpDelete(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = StorageServerConnectionServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                return new RemoveResponseImpl();
            }
            StorageServerConnectionServiceImpl.this.checkFault(response);
            return new RemoveResponseImpl();
        }
    }

    private class UpdateNfsResponseImpl
    implements StorageServerConnectionService.UpdateNfsResponse {
        private StorageConnection connection;

        private UpdateNfsResponseImpl() {
        }

        public void connection(StorageConnection connection) {
            this.connection = connection;
        }

        @Override
        public StorageConnection connection() {
            return this.connection;
        }
    }

    private class UpdateNfsRequestImpl
    extends BaseRequest<StorageServerConnectionService.UpdateNfsRequest, StorageServerConnectionService.UpdateNfsResponse>
    implements StorageServerConnectionService.UpdateNfsRequest {
        private Boolean async;
        private StorageConnection connection;
        private Boolean force;

        private UpdateNfsRequestImpl() {
        }

        @Override
        public StorageServerConnectionService.UpdateNfsRequest async(Boolean async) {
            this.async = async;
            return this;
        }

        @Override
        public StorageServerConnectionService.UpdateNfsRequest connection(StorageConnection connection) {
            this.connection = connection;
            return this;
        }

        @Override
        public StorageServerConnectionService.UpdateNfsRequest connection(StorageConnectionBuilder connection) {
            this.connection = connection.build();
            return this;
        }

        @Override
        public StorageServerConnectionService.UpdateNfsRequest force(Boolean force) {
            this.force = force;
            return this;
        }

        @Override
        public StorageServerConnectionService.UpdateNfsResponse send() {
            HttpResponse response;
            HttpPut request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(StorageServerConnectionServiceImpl.this.getConnection().getUrl() + StorageServerConnectionServiceImpl.this.getPath());
                if (this.async != null) {
                    uriBuilder.addParameter("async", XmlWriter.renderBoolean(this.async));
                }
                if (this.force != null) {
                    uriBuilder.addParameter("force", XmlWriter.renderBoolean(this.force));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpPut(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                XmlStorageConnectionWriter.writeOne(this.connection, xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to parse response", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = StorageServerConnectionServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        UpdateNfsResponseImpl actionResponse = new UpdateNfsResponseImpl();
                        actionResponse.connection(XmlStorageConnectionReader.readOne(reader));
                        UpdateNfsResponseImpl updateNfsResponseImpl = actionResponse;
                        reader.close();
                        return updateNfsResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            StorageServerConnectionServiceImpl.this.checkFault(response);
            return new UpdateNfsResponseImpl();
        }
    }

    private class UpdateLocalResponseImpl
    implements StorageServerConnectionService.UpdateLocalResponse {
        private StorageConnection connection;

        private UpdateLocalResponseImpl() {
        }

        public void connection(StorageConnection connection) {
            this.connection = connection;
        }

        @Override
        public StorageConnection connection() {
            return this.connection;
        }
    }

    private class UpdateLocalRequestImpl
    extends BaseRequest<StorageServerConnectionService.UpdateLocalRequest, StorageServerConnectionService.UpdateLocalResponse>
    implements StorageServerConnectionService.UpdateLocalRequest {
        private Boolean async;
        private StorageConnection connection;
        private Boolean force;

        private UpdateLocalRequestImpl() {
        }

        @Override
        public StorageServerConnectionService.UpdateLocalRequest async(Boolean async) {
            this.async = async;
            return this;
        }

        @Override
        public StorageServerConnectionService.UpdateLocalRequest connection(StorageConnection connection) {
            this.connection = connection;
            return this;
        }

        @Override
        public StorageServerConnectionService.UpdateLocalRequest connection(StorageConnectionBuilder connection) {
            this.connection = connection.build();
            return this;
        }

        @Override
        public StorageServerConnectionService.UpdateLocalRequest force(Boolean force) {
            this.force = force;
            return this;
        }

        @Override
        public StorageServerConnectionService.UpdateLocalResponse send() {
            HttpResponse response;
            HttpPut request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(StorageServerConnectionServiceImpl.this.getConnection().getUrl() + StorageServerConnectionServiceImpl.this.getPath());
                if (this.async != null) {
                    uriBuilder.addParameter("async", XmlWriter.renderBoolean(this.async));
                }
                if (this.force != null) {
                    uriBuilder.addParameter("force", XmlWriter.renderBoolean(this.force));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpPut(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                XmlStorageConnectionWriter.writeOne(this.connection, xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to parse response", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = StorageServerConnectionServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        UpdateLocalResponseImpl actionResponse = new UpdateLocalResponseImpl();
                        actionResponse.connection(XmlStorageConnectionReader.readOne(reader));
                        UpdateLocalResponseImpl updateLocalResponseImpl = actionResponse;
                        reader.close();
                        return updateLocalResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            StorageServerConnectionServiceImpl.this.checkFault(response);
            return new UpdateLocalResponseImpl();
        }
    }

    private class UpdateIscsiResponseImpl
    implements StorageServerConnectionService.UpdateIscsiResponse {
        private StorageConnection connection;

        private UpdateIscsiResponseImpl() {
        }

        public void connection(StorageConnection connection) {
            this.connection = connection;
        }

        @Override
        public StorageConnection connection() {
            return this.connection;
        }
    }

    private class UpdateIscsiRequestImpl
    extends BaseRequest<StorageServerConnectionService.UpdateIscsiRequest, StorageServerConnectionService.UpdateIscsiResponse>
    implements StorageServerConnectionService.UpdateIscsiRequest {
        private Boolean async;
        private StorageConnection connection;
        private Boolean force;

        private UpdateIscsiRequestImpl() {
        }

        @Override
        public StorageServerConnectionService.UpdateIscsiRequest async(Boolean async) {
            this.async = async;
            return this;
        }

        @Override
        public StorageServerConnectionService.UpdateIscsiRequest connection(StorageConnection connection) {
            this.connection = connection;
            return this;
        }

        @Override
        public StorageServerConnectionService.UpdateIscsiRequest connection(StorageConnectionBuilder connection) {
            this.connection = connection.build();
            return this;
        }

        @Override
        public StorageServerConnectionService.UpdateIscsiRequest force(Boolean force) {
            this.force = force;
            return this;
        }

        @Override
        public StorageServerConnectionService.UpdateIscsiResponse send() {
            HttpResponse response;
            HttpPut request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(StorageServerConnectionServiceImpl.this.getConnection().getUrl() + StorageServerConnectionServiceImpl.this.getPath());
                if (this.async != null) {
                    uriBuilder.addParameter("async", XmlWriter.renderBoolean(this.async));
                }
                if (this.force != null) {
                    uriBuilder.addParameter("force", XmlWriter.renderBoolean(this.force));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpPut(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                XmlStorageConnectionWriter.writeOne(this.connection, xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to parse response", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = StorageServerConnectionServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        UpdateIscsiResponseImpl actionResponse = new UpdateIscsiResponseImpl();
                        actionResponse.connection(XmlStorageConnectionReader.readOne(reader));
                        UpdateIscsiResponseImpl updateIscsiResponseImpl = actionResponse;
                        reader.close();
                        return updateIscsiResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            StorageServerConnectionServiceImpl.this.checkFault(response);
            return new UpdateIscsiResponseImpl();
        }
    }

    private class UpdateGlusterfsResponseImpl
    implements StorageServerConnectionService.UpdateGlusterfsResponse {
        private StorageConnection connection;

        private UpdateGlusterfsResponseImpl() {
        }

        public void connection(StorageConnection connection) {
            this.connection = connection;
        }

        @Override
        public StorageConnection connection() {
            return this.connection;
        }
    }

    private class UpdateGlusterfsRequestImpl
    extends BaseRequest<StorageServerConnectionService.UpdateGlusterfsRequest, StorageServerConnectionService.UpdateGlusterfsResponse>
    implements StorageServerConnectionService.UpdateGlusterfsRequest {
        private Boolean async;
        private StorageConnection connection;
        private Boolean force;

        private UpdateGlusterfsRequestImpl() {
        }

        @Override
        public StorageServerConnectionService.UpdateGlusterfsRequest async(Boolean async) {
            this.async = async;
            return this;
        }

        @Override
        public StorageServerConnectionService.UpdateGlusterfsRequest connection(StorageConnection connection) {
            this.connection = connection;
            return this;
        }

        @Override
        public StorageServerConnectionService.UpdateGlusterfsRequest connection(StorageConnectionBuilder connection) {
            this.connection = connection.build();
            return this;
        }

        @Override
        public StorageServerConnectionService.UpdateGlusterfsRequest force(Boolean force) {
            this.force = force;
            return this;
        }

        @Override
        public StorageServerConnectionService.UpdateGlusterfsResponse send() {
            HttpResponse response;
            HttpPut request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(StorageServerConnectionServiceImpl.this.getConnection().getUrl() + StorageServerConnectionServiceImpl.this.getPath());
                if (this.async != null) {
                    uriBuilder.addParameter("async", XmlWriter.renderBoolean(this.async));
                }
                if (this.force != null) {
                    uriBuilder.addParameter("force", XmlWriter.renderBoolean(this.force));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpPut(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            try (ByteArrayOutputStream output = new ByteArrayOutputStream();
                 XmlWriter xmlWriter = new XmlWriter(output, true);){
                XmlStorageConnectionWriter.writeOne(this.connection, xmlWriter);
                xmlWriter.flush();
                request.setEntity((HttpEntity)new ByteArrayEntity(output.toByteArray()));
            }
            catch (IOException ex) {
                throw new Error("Failed to parse response", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = StorageServerConnectionServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        UpdateGlusterfsResponseImpl actionResponse = new UpdateGlusterfsResponseImpl();
                        actionResponse.connection(XmlStorageConnectionReader.readOne(reader));
                        UpdateGlusterfsResponseImpl updateGlusterfsResponseImpl = actionResponse;
                        reader.close();
                        return updateGlusterfsResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            StorageServerConnectionServiceImpl.this.checkFault(response);
            return new UpdateGlusterfsResponseImpl();
        }
    }

    private class GetResponseImpl
    implements StorageServerConnectionService.GetResponse {
        private StorageConnection conection;

        private GetResponseImpl() {
        }

        public void conection(StorageConnection conection) {
            this.conection = conection;
        }

        @Override
        public StorageConnection conection() {
            return this.conection;
        }
    }

    private class GetRequestImpl
    extends BaseRequest<StorageServerConnectionService.GetRequest, StorageServerConnectionService.GetResponse>
    implements StorageServerConnectionService.GetRequest {
        private String follow;

        private GetRequestImpl() {
        }

        @Override
        public StorageServerConnectionService.GetRequest follow(String follow) {
            this.follow = follow;
            return this;
        }

        @Override
        public StorageServerConnectionService.GetResponse send() {
            HttpResponse response;
            HttpGet request = null;
            try {
                URIBuilder uriBuilder = new URIBuilder(StorageServerConnectionServiceImpl.this.getConnection().getUrl() + StorageServerConnectionServiceImpl.this.getPath());
                if (this.follow != null) {
                    uriBuilder.addParameter("follow", XmlWriter.renderString(this.follow));
                }
                if (this.query != null) {
                    for (Map.Entry queryParam : this.query.entrySet()) {
                        uriBuilder.addParameter((String)queryParam.getKey(), (String)queryParam.getValue());
                    }
                }
                request = new HttpGet(uriBuilder.build());
            }
            catch (URISyntaxException ex) {
                throw new Error("Failed to build URL", ex);
            }
            if (this.headers != null) {
                for (Map.Entry header : this.headers.entrySet()) {
                    request.setHeader((String)header.getKey(), (String)header.getValue());
                }
            }
            if ((response = StorageServerConnectionServiceImpl.this.getConnection().send((HttpUriRequest)request)).getStatusLine().getStatusCode() == 200) {
                try {
                    XmlReader reader = new XmlReader(response.getEntity().getContent());
                    try {
                        GetResponseImpl actionResponse = new GetResponseImpl();
                        actionResponse.conection(XmlStorageConnectionReader.readOne(reader));
                        GetResponseImpl getResponseImpl = actionResponse;
                        reader.close();
                        return getResponseImpl;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            throw new Error("Failed to read response", ex);
                        }
                    }
                }
                finally {
                    EntityUtils.consumeQuietly((HttpEntity)response.getEntity());
                }
            }
            StorageServerConnectionServiceImpl.this.checkFault(response);
            return new GetResponseImpl();
        }
    }
}

