/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk4.types;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum RoleType {
    ADMIN("admin"),
    USER("user");

    private static final Logger log;
    private String image;

    private RoleType(String image) {
        this.image = image;
    }

    public String value() {
        return this.image;
    }

    public static RoleType fromValue(String value) {
        try {
            return RoleType.valueOf(value.toUpperCase());
        }
        catch (IllegalArgumentException exception) {
            log.error("The string '" + value + "' isn't a valid value for the 'RoleType' enumerated type. Valid values are 'admin' and 'user'.", (Throwable)exception);
            return null;
        }
    }

    static {
        log = LoggerFactory.getLogger(RoleType.class);
    }
}

