/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.internal.containers;

import java.lang.String;
import java.util.List;
import org.ovirt.engine.sdk4.types.LogicalUnit;
import org.ovirt.engine.sdk4.types.VolumeGroup;

public class VolumeGroupContainer extends Container implements VolumeGroup {
    private String id;
    private List<LogicalUnit> logicalUnits;
    private String name;
    
    public String id() {
        return id;
    }
    
    public void id(String newId) {
        id = newId;
    }
    
    public boolean idPresent() {
        return id != null;
    }
    
    public List<LogicalUnit> logicalUnits() {
        return makeUnmodifiableList(logicalUnits);
    }
    
    public void logicalUnits(List<LogicalUnit> newLogicalUnits) {
        logicalUnits = makeArrayList(newLogicalUnits);
    }
    
    public boolean logicalUnitsPresent() {
        return logicalUnits != null && !logicalUnits.isEmpty();
    }
    
    public String name() {
        return name;
    }
    
    public void name(String newName) {
        name = newName;
    }
    
    public boolean namePresent() {
        return name != null;
    }
    
}
