/*
Copyright (c) 2015 Red Hat, Inc.
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package org.ovirt.engine.sdk4.internal.xml;

import java.util.Iterator;
import org.ovirt.api.metamodel.runtime.xml.XmlWriter;
import org.ovirt.engine.sdk4.types.ExternalTemplateImport;

public class XmlExternalTemplateImportWriter {
    
    public static void writeOne(ExternalTemplateImport object, XmlWriter writer) {
        writeOne(object, "external_template_import", writer);
    }
    
    public static void writeOne(ExternalTemplateImport object, String tag, XmlWriter writer) {
        writer.writeStartElement(tag);
        if (object.clone_Present()) {
            writer.writeBoolean("clone", object.clone_());
        }
        if (object.clusterPresent()) {
            XmlClusterWriter.writeOne(object.cluster(), "cluster", writer);
        }
        if (object.cpuProfilePresent()) {
            XmlCpuProfileWriter.writeOne(object.cpuProfile(), "cpu_profile", writer);
        }
        if (object.hostPresent()) {
            XmlHostWriter.writeOne(object.host(), "host", writer);
        }
        if (object.quotaPresent()) {
            XmlQuotaWriter.writeOne(object.quota(), "quota", writer);
        }
        if (object.storageDomainPresent()) {
            XmlStorageDomainWriter.writeOne(object.storageDomain(), "storage_domain", writer);
        }
        if (object.templatePresent()) {
            XmlTemplateWriter.writeOne(object.template(), "template", writer);
        }
        if (object.urlPresent()) {
            writer.writeElement("url", object.url());
        }
        writer.writeEndElement();
    }
    
    public static void writeMany(Iterator<ExternalTemplateImport> list, XmlWriter writer) {
        writeMany(list, "external_template_import", "external_template_imports", writer);
    }
    
    public static void writeMany(Iterator<ExternalTemplateImport> list, String singular, String plural, XmlWriter writer) {
        writer.writeStartElement(plural);
        while (list.hasNext()) {
            XmlExternalTemplateImportWriter.writeOne(list.next(), singular, writer);
        }
        writer.writeEndElement();
    }
    
}

