/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk.decorators;

import java.io.IOException;
import java.util.List;
import java.util.UUID;
import org.apache.http.Header;
import org.apache.http.client.ClientProtocolException;
import org.ovirt.engine.sdk.common.CollectionDecorator;
import org.ovirt.engine.sdk.decorators.Host;
import org.ovirt.engine.sdk.decorators.HostAgent;
import org.ovirt.engine.sdk.entities.Agent;
import org.ovirt.engine.sdk.entities.Agents;
import org.ovirt.engine.sdk.exceptions.ServerException;
import org.ovirt.engine.sdk.utils.HttpHeaderBuilder;
import org.ovirt.engine.sdk.utils.UrlBuilder;
import org.ovirt.engine.sdk.web.HttpProxyBroker;
import org.ovirt.engine.sdk.web.UrlParameterType;

public class HostAgents
extends CollectionDecorator<Agent, Agents, HostAgent> {
    private Host parent;

    public HostAgents(HttpProxyBroker proxy, Host parent) {
        super(proxy, "fenceagents");
        this.parent = parent;
    }

    @Override
    public List<HostAgent> list() throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        return this.list(url, Agents.class, HostAgent.class);
    }

    @Override
    public HostAgent get(UUID id) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName() + "/" + id.toString();
        return this.getProxy().get(url, Agent.class, HostAgent.class);
    }

    @Override
    public HostAgent getById(String id) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName() + "/" + id;
        return this.getProxy().get(url, Agent.class, HostAgent.class);
    }

    public HostAgent add(Agent agent) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        url = urlBuilder.build();
        return this.getProxy().add(url, agent, Agent.class, HostAgent.class, headers);
    }

    public HostAgent add(Agent agent, String correlationId) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        if (correlationId != null) {
            headersBuilder.add("Correlation-Id", correlationId);
        }
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        url = urlBuilder.build();
        return this.getProxy().add(url, agent, Agent.class, HostAgent.class, headers);
    }

    public HostAgent add(Agent agent, String correlationId, String expect) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        if (correlationId != null) {
            headersBuilder.add("Correlation-Id", correlationId);
        }
        if (expect != null) {
            headersBuilder.add("Expect", expect);
        }
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        url = urlBuilder.build();
        return this.getProxy().add(url, agent, Agent.class, HostAgent.class, headers);
    }

    public List<HostAgent> list(Integer max) throws ClientProtocolException, ServerException, IOException {
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(this.parent.getHref() + "/" + this.getName());
        if (max != null) {
            urlBuilder.add("max", max, UrlParameterType.MATRIX);
        }
        String url = urlBuilder.build();
        return this.list(url, Agents.class, HostAgent.class, headers);
    }
}

