/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk.decorators;

import java.io.IOException;
import java.util.List;
import java.util.UUID;
import org.apache.http.Header;
import org.apache.http.client.ClientProtocolException;
import org.ovirt.engine.sdk.common.CollectionDecorator;
import org.ovirt.engine.sdk.decorators.OpenStackImageProvider;
import org.ovirt.engine.sdk.exceptions.ServerException;
import org.ovirt.engine.sdk.utils.HttpHeaderBuilder;
import org.ovirt.engine.sdk.utils.UrlBuilder;
import org.ovirt.engine.sdk.web.HttpProxyBroker;
import org.ovirt.engine.sdk.web.UrlParameterType;

public class OpenStackImageProviders
extends CollectionDecorator<org.ovirt.engine.sdk.entities.OpenStackImageProvider, org.ovirt.engine.sdk.entities.OpenStackImageProviders, OpenStackImageProvider> {
    public OpenStackImageProviders(HttpProxyBroker proxy) {
        super(proxy, "openstackimageproviders");
    }

    @Override
    public List<OpenStackImageProvider> list() throws ClientProtocolException, ServerException, IOException {
        String url = "/" + this.getName();
        return this.list(url, org.ovirt.engine.sdk.entities.OpenStackImageProviders.class, OpenStackImageProvider.class);
    }

    @Override
    public OpenStackImageProvider get(UUID id) throws ClientProtocolException, ServerException, IOException {
        String url = "/" + this.getName() + "/" + id.toString();
        return this.getProxy().get(url, org.ovirt.engine.sdk.entities.OpenStackImageProvider.class, OpenStackImageProvider.class);
    }

    @Override
    public OpenStackImageProvider getById(String id) throws ClientProtocolException, ServerException, IOException {
        String url = "/" + this.getName() + "/" + id;
        return this.getProxy().get(url, org.ovirt.engine.sdk.entities.OpenStackImageProvider.class, OpenStackImageProvider.class);
    }

    public OpenStackImageProvider add(org.ovirt.engine.sdk.entities.OpenStackImageProvider openstackimageprovider) throws ClientProtocolException, ServerException, IOException {
        String url = "/" + this.getName();
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        url = urlBuilder.build();
        return this.getProxy().add(url, openstackimageprovider, org.ovirt.engine.sdk.entities.OpenStackImageProvider.class, OpenStackImageProvider.class, headers);
    }

    public OpenStackImageProvider add(org.ovirt.engine.sdk.entities.OpenStackImageProvider openstackimageprovider, String correlationId) throws ClientProtocolException, ServerException, IOException {
        String url = "/" + this.getName();
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        if (correlationId != null) {
            headersBuilder.add("Correlation-Id", correlationId);
        }
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        url = urlBuilder.build();
        return this.getProxy().add(url, openstackimageprovider, org.ovirt.engine.sdk.entities.OpenStackImageProvider.class, OpenStackImageProvider.class, headers);
    }

    public OpenStackImageProvider add(org.ovirt.engine.sdk.entities.OpenStackImageProvider openstackimageprovider, String correlationId, String expect) throws ClientProtocolException, ServerException, IOException {
        String url = "/" + this.getName();
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        if (correlationId != null) {
            headersBuilder.add("Correlation-Id", correlationId);
        }
        if (expect != null) {
            headersBuilder.add("Expect", expect);
        }
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        url = urlBuilder.build();
        return this.getProxy().add(url, openstackimageprovider, org.ovirt.engine.sdk.entities.OpenStackImageProvider.class, OpenStackImageProvider.class, headers);
    }

    public List<OpenStackImageProvider> list(Integer max) throws ClientProtocolException, ServerException, IOException {
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder("/" + this.getName());
        if (max != null) {
            urlBuilder.add("max", max, UrlParameterType.MATRIX);
        }
        String url = urlBuilder.build();
        return this.list(url, org.ovirt.engine.sdk.entities.OpenStackImageProviders.class, OpenStackImageProvider.class, headers);
    }
}

