/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk.decorators;

import java.io.IOException;
import java.util.List;
import java.util.UUID;
import org.apache.http.Header;
import org.apache.http.client.ClientProtocolException;
import org.ovirt.engine.sdk.common.CollectionDecorator;
import org.ovirt.engine.sdk.decorators.User;
import org.ovirt.engine.sdk.decorators.UserSSHPublicKey;
import org.ovirt.engine.sdk.entities.SSHPublicKey;
import org.ovirt.engine.sdk.entities.SSHPublicKeys;
import org.ovirt.engine.sdk.exceptions.ServerException;
import org.ovirt.engine.sdk.utils.HttpHeaderBuilder;
import org.ovirt.engine.sdk.utils.UrlBuilder;
import org.ovirt.engine.sdk.web.HttpProxyBroker;
import org.ovirt.engine.sdk.web.UrlParameterType;

public class UserSSHPublicKeys
extends CollectionDecorator<SSHPublicKey, SSHPublicKeys, UserSSHPublicKey> {
    private User parent;

    public UserSSHPublicKeys(HttpProxyBroker proxy, User parent) {
        super(proxy, "sshpublickeys");
        this.parent = parent;
    }

    @Override
    public List<UserSSHPublicKey> list() throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        return this.list(url, SSHPublicKeys.class, UserSSHPublicKey.class);
    }

    @Override
    public UserSSHPublicKey get(UUID id) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName() + "/" + id.toString();
        return this.getProxy().get(url, SSHPublicKey.class, UserSSHPublicKey.class);
    }

    @Override
    public UserSSHPublicKey getById(String id) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName() + "/" + id;
        return this.getProxy().get(url, SSHPublicKey.class, UserSSHPublicKey.class);
    }

    public UserSSHPublicKey add(SSHPublicKey sshpublickey) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        url = urlBuilder.build();
        return this.getProxy().add(url, sshpublickey, SSHPublicKey.class, UserSSHPublicKey.class, headers);
    }

    public UserSSHPublicKey add(SSHPublicKey sshpublickey, String correlationId) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        if (correlationId != null) {
            headersBuilder.add("Correlation-Id", correlationId);
        }
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        url = urlBuilder.build();
        return this.getProxy().add(url, sshpublickey, SSHPublicKey.class, UserSSHPublicKey.class, headers);
    }

    public UserSSHPublicKey add(SSHPublicKey sshpublickey, String correlationId, String expect) throws ClientProtocolException, ServerException, IOException {
        String url = this.parent.getHref() + "/" + this.getName();
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        if (correlationId != null) {
            headersBuilder.add("Correlation-Id", correlationId);
        }
        if (expect != null) {
            headersBuilder.add("Expect", expect);
        }
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(url);
        url = urlBuilder.build();
        return this.getProxy().add(url, sshpublickey, SSHPublicKey.class, UserSSHPublicKey.class, headers);
    }

    public List<UserSSHPublicKey> list(Integer max) throws ClientProtocolException, ServerException, IOException {
        HttpHeaderBuilder headersBuilder = new HttpHeaderBuilder();
        List<Header> headers = headersBuilder.build();
        UrlBuilder urlBuilder = new UrlBuilder(this.parent.getHref() + "/" + this.getName());
        if (max != null) {
            urlBuilder.add("max", max, UrlParameterType.MATRIX);
        }
        String url = urlBuilder.build();
        return this.list(url, SSHPublicKeys.class, UserSSHPublicKey.class, headers);
    }
}

