/*
 * Decompiled with CFR 0.152.
 */
package org.ovirt.engine.sdk.mapping;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import javax.xml.bind.JAXBException;
import org.apache.commons.beanutils.PropertyUtils;
import org.ovirt.engine.sdk.utils.SerializationHelper;
import org.ovirt.engine.sdk.web.HttpProxyBroker;

public class Mapper {
    private static String[] MAPPING_EXCEPTIONS = new String[]{"links", "actions"};

    public static synchronized <F, T> T map(F from, Class<T> to, HttpProxyBroker proxy) {
        T dstobj = null;
        try {
            dstobj = proxy != null ? (T)Mapper.getConstracor(to).newInstance(proxy) : (T)to.newInstance();
            if (dstobj != null) {
                PropertyUtils.copyProperties(dstobj, from);
                Mapper.excludeExceptions(dstobj);
            }
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        return dstobj;
    }

    private static <T> void excludeExceptions(T dstobj) {
        for (String field : MAPPING_EXCEPTIONS) {
            try {
                PropertyUtils.setProperty(dstobj, (String)field, null);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                // empty catch block
            }
        }
    }

    public static synchronized <F, T> T map(F from, Class<T> to) {
        return Mapper.map(from, to, null);
    }

    private static <T> Constructor<?> getConstracor(Class<T> to) throws NoSuchMethodException {
        for (Constructor<?> ctr : to.getConstructors()) {
            if (ctr.getParameterTypes().length <= 0 || !ctr.getParameterTypes()[0].equals(HttpProxyBroker.class)) continue;
            return ctr;
        }
        throw new NoSuchMethodException("HttpProxyBroker");
    }

    public static <R, Z> Z map(Class<R> from, Class<Z> to, String xml, HttpProxyBroker proxy) throws JAXBException {
        R res = SerializationHelper.unmarshall(from, xml);
        return Mapper.map(res, to, proxy);
    }
}

