/*	$NetBSD: ds2482owreg.h,v 1.1 2024/11/04 20:43:38 brad Exp $	*/

/*
 * Copyright (c) 2024 Brad Spencer <brad@anduin.eldar.org>
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

#ifndef _DEV_I2C_DS2482REG_H_
#define _DEV_I2C_DS2482REG_H_

#define DS2482_LOWEST_ADDR		0x18
#define DS2482_HIGHEST_ADDR		0x1F

#define DS2482_DEVICE_RESET		0xF0
#define DS2482_SET_READ_POINTER		0xE1
#define 	DS2482_REGISTER_STATUS	0xF0
#define			DS2482_STATUS_1WB	0x01
#define			DS2482_STATUS_PPD	0x02
#define			DS2482_STATUS_SD	0x04
#define			DS2482_STATUS_LL	0x08
#define			DS2482_STATUS_RST	0x10
#define			DS2482_STATUS_SBR	0x20
#define				DS2482_STATUS_SBR_SHIFT	5
#define			DS2482_STATUS_TSB	0x40
#define			DS2482_STATUS_DIR	0x80
#define		DS2482_REGISTER_DATA	0xE1
#define		DS2482_REGISTER_CONFIG	0xC3
#define		DS2482_REGISTER_CHANNEL	0xD2 /* DS2482-800 only */
#define DS2482_WRITE_CONFIG		0xD2
#define		DS2482_CONFIG_1WS	0x08
#define		DS2482_CONFIG_SPU	0x04
#define		DS2482_CONFIG_APU	0x01
#define DS2482_SELECT_CHANNEL		0xC3 /* DS2482-800 only */
#define 	DS2482_CHANNEL_IO0	0xF0
#define 	DS2482_CHANNEL_IO1	0xE1
#define 	DS2482_CHANNEL_IO2	0xD2
#define 	DS2482_CHANNEL_IO3	0xC3
#define 	DS2482_CHANNEL_IO4	0xB4
#define 	DS2482_CHANNEL_IO5	0xA5
#define 	DS2482_CHANNEL_IO6	0x96
#define 	DS2482_CHANNEL_IO7	0x87
#define DS2482_ONEWIRE_RESET		0xB4
#define DS2482_ONEWIRE_SINGLE_BIT	0x87
#define		DS2482_ONEWIRE_BIT_ZERO		0x00
#define		DS2482_ONEWIRE_BIT_ONE		0x80
#define DS2482_ONEWIRE_WRITE_BYTE	0xA5
#define DS2482_ONEWIRE_READ_BYTE	0x96
#define DS2482_ONEWIRE_TRIPLET		0x78
#define		DS2482_TRIPLET_DIR_ZERO 0x00
#define		DS2482_TRIPLET_DIR_ONE	0x80

#endif
