/*	$NetBSD: platform_device.h,v 1.8 2021/12/19 10:49:55 riastradh Exp $	*/

/*-
 * Copyright (c) 2013 The NetBSD Foundation, Inc.
 * All rights reserved.
 *
 * This code is derived from software contributed to The NetBSD Foundation
 * by Taylor R. Campbell.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _LINUX_PLATFORM_DEVICE_H_
#define _LINUX_PLATFORM_DEVICE_H_

#include <sys/device.h>
#include <sys/bus.h>

#define NUM_PLATFORM_RESOURCE	2

struct platform_device {
	device_t	pd_dev;
	uint64_t	id;

	bus_dma_tag_t	dmat;
	unsigned int	nresource;
	struct {
		bus_space_tag_t	tag;
		bus_addr_t	start;
		bus_size_t	len;
	}		resource[NUM_PLATFORM_RESOURCE];
};

static inline device_t
platform_device_dev(const struct platform_device *platformdev)
{

	return platformdev->pd_dev;
}

static inline const char *
platform_device_name(const struct platform_device *platformdev)
{

	return device_xname(platformdev->pd_dev);
}

static inline struct platform_device *
to_platform_device(device_t self)
{

	/* XXX */
	return device_private(self);
}

#endif  /* _LINUX_PLATFORM_DEVICE_H_ */
