/* $NetBSD: tegra_dcreg.h,v 1.5 2015/11/14 11:55:36 jmcneill Exp $ */

/*-
 * Copyright (c) 2015 Jared D. McNeill <jmcneill@invisible.ca>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef _ARM_TEGRA_DCREG_H
#define _ARM_TEGRA_DCREG_H

/*
 * Display CMD registers
 */
#define DC_CMD_GENERAL_INCR_SYNCPT_REG			0x000
#define DC_CMD_GENERAL_INCR_SYNCPT_CNTRL_REG		0x004
#define DC_CMD_GENERAL_INCR_SYNCPT_ERROR_REG		0x008
#define DC_CMD_WIN_A_INCR_SYNCPT_REG			0x020
#define DC_CMD_WIN_A_INCR_SYNCPT_CNTRL_REG		0x024
#define DC_CMD_WIN_A_INCR_SYNCPT_ERROR_REG		0x028
#define DC_CMD_WIN_B_INCR_SYNCPT_REG			0x040
#define DC_CMD_WIN_B_INCR_SYNCPT_CNTRL_REG		0x044
#define DC_CMD_WIN_B_INCR_SYNCPT_ERROR_REG		0x048
#define DC_CMD_WIN_C_INCR_SYNCPT_REG			0x060
#define DC_CMD_WIN_C_INCR_SYNCPT_CNTRL_REG		0x064
#define DC_CMD_WIN_C_INCR_SYNCPT_ERROR_REG		0x068
#define DC_CMD_CONT_SYNCPT_VSYNC_REG			0x0a0
#define DC_CMD_CTXSW_REG				0x0c0
#define DC_CMD_DISPLAY_COMMAND_OPTION0_REG		0x0c4

#define DC_CMD_DISPLAY_COMMAND_REG			0x0c8
#define DC_CMD_DISPLAY_COMMAND_RAISE_CHANNEL_ID		__BITS(30,27)
#define DC_CMD_DISPLAY_COMMAND_RAISE_VECTOR		__BITS(26,22)
#define DC_CMD_DISPLAY_COMMAND_DISPLAY_CTRL_MODE	__BITS(6,5)
#define DC_CMD_DISPLAY_COMMAND_DISPLAY_CTRL_MODE_STOP		0
#define DC_CMD_DISPLAY_COMMAND_DISPLAY_CTRL_MODE_C_DISPLAY	1
#define DC_CMD_DISPLAY_COMMAND_DISPLAY_CTRL_MODE_NC_DISPLAY	2
#define DC_CMD_DISPLAY_COMMAND_RAISE			__BIT(0)

#define DC_CMD_SIGNAL_RAISE_REG				0x0cc

#define DC_CMD_DISPLAY_POWER_CONTROL_REG		0x0d8
#define DC_CMD_DISPLAY_POWER_CONTROL_HSPI_ENABLE	__BIT(25)
#define DC_CMD_DISPLAY_POWER_CONTROL_SPI_ENABLE		__BIT(24)
#define DC_CMD_DISPLAY_POWER_CONTROL_PM1_ENABLE		__BIT(18)
#define DC_CMD_DISPLAY_POWER_CONTROL_PM0_ENABLE		__BIT(16)
#define DC_CMD_DISPLAY_POWER_CONTROL_PW4_ENABLE		__BIT(8)
#define DC_CMD_DISPLAY_POWER_CONTROL_PW3_ENABLE		__BIT(6)
#define DC_CMD_DISPLAY_POWER_CONTROL_PW2_ENABLE		__BIT(4)
#define DC_CMD_DISPLAY_POWER_CONTROL_PW1_ENABLE		__BIT(2)
#define DC_CMD_DISPLAY_POWER_CONTROL_PW0_ENABLE		__BIT(0)

#define DC_CMD_INT_STATUS_REG				0x0dc
#define DC_CMD_INT_MASK_REG				0x0e0
#define DC_CMD_INT_ENABLE_REG				0x0e4
#define DC_CMD_INT_V_BLANK				__BIT(2)

#define DC_CMD_INT_TYPE_REG				0x0e8
#define DC_CMD_INT_POLARITY_REG				0x0ec
#define DC_CMD_SIGNAL_RAISE1_REG			0x0f0
#define DC_CMD_SIGNAL_RAISE2_REG			0x0f4
#define DC_CMD_SIGNAL_RAISE3_REG			0x0f8

#define DC_CMD_STATE_ACCESS_REG				0x100
#define DC_CMD_STATE_ACCESS_WRITE_MUX			__BIT(2)
#define DC_CMD_STATE_ACCESS_READ_MUX			__BIT(0)

#define DC_CMD_STATE_CONTROL_REG			0x104
#define DC_CMD_STATE_CONTROL_NC_HOST_TRIG_ENABLE	__BIT(24)
#define DC_CMD_STATE_CONTROL_CURSOR_UPDATE		__BIT(15)
#define DC_CMD_STATE_CONTROL_WIN_D_UPDATE		__BIT(12)
#define DC_CMD_STATE_CONTROL_WIN_C_UPDATE		__BIT(11)
#define DC_CMD_STATE_CONTROL_WIN_B_UPDATE		__BIT(10)
#define DC_CMD_STATE_CONTROL_WIN_A_UPDATE		__BIT(9)
#define DC_CMD_STATE_CONTROL_GENERAL_UPDATE		__BIT(8)
#define DC_CMD_STATE_CONTROL_CURSOR_ACT_REQ		__BIT(7)
#define DC_CMD_STATE_CONTROL_WIN_D_ACT_REQ		__BIT(4)
#define DC_CMD_STATE_CONTROL_WIN_C_ACT_REQ		__BIT(3)
#define DC_CMD_STATE_CONTROL_WIN_B_ACT_REQ		__BIT(2)
#define DC_CMD_STATE_CONTROL_WIN_A_ACT_REQ		__BIT(1)
#define DC_CMD_STATE_CONTROL_GENERAL_ACT_REQ		__BIT(0)

#define DC_CMD_DISPLAY_WINDOW_HEADER_REG		0x108
#define DC_CMD_DISPLAY_WINDOW_HEADER_WINDOW_D_SELECT	__BIT(7)
#define DC_CMD_DISPLAY_WINDOW_HEADER_WINDOW_C_SELECT	__BIT(6)
#define DC_CMD_DISPLAY_WINDOW_HEADER_WINDOW_B_SELECT	__BIT(5)
#define DC_CMD_DISPLAY_WINDOW_HEADER_WINDOW_A_SELECT	__BIT(4)

#define DC_CMD_REG_ACT_CONTROL_REG			0x10c
#define DC_CMD_WIN_T_STATE_CONTROL_REG			0x110
#define DC_CMD_SECURE_CONTROL_REG			0x114
#define DC_CMD_WIN_D_INCR_SYNCPT_REG			0x130
#define DC_CMD_WIN_D_INCR_SYNCPT_CNTRL_REG		0x134
#define DC_CMD_WIN_D_INCR_SYNCPT_ERROR_REG		0x138

/*
 * Display COM registers
 */
#define DC_COM_CRC_CONTROL_REG				0xc00
#define DC_COM_CRC_CHECKSUM_REG				0xc04
#define DC_COM_PIN_MISC_CONTROL_REG			0xc6c
#define DC_COM_PM0_CONTROL_REG				0xc70
#define DC_COM_PM0_DUTY_CYCLE_REG			0xc74
#define DC_COM_SCRATCH_REGISTER_A_REG			0xc94
#define DC_COM_SCRATCH_REGISTER_B_REG			0xc98
#define DC_COM_CRC_CHECKSUM_LATCHED_REG			0xca4
#define DC_COM_CMU_CSC_KRR_REG				0xca8
#define DC_COM_CMU_CSC_KGR_REG				0xcac
#define DC_COM_CMU_CSC_KBR_REG				0xcb0
#define DC_COM_CMU_CSC_KRG_REG				0xcb4
#define DC_COM_CMU_CSC_KGG_REG				0xcb8
#define DC_COM_CMU_CSC_KBG_REG				0xcbc
#define DC_COM_CMU_CSC_KRB_REG				0xcc0
#define DC_COM_CMU_CSC_KGB_REG				0xcc4
#define DC_COM_CMU_CSC_KBB_REG				0xcc8
#define DC_COM_CMU_LUT_MASK_REG				0xccc
#define DC_COM_CMU_LUT1_REG				0xcd8
#define DC_COM_CMU_LUT2_REG				0xcdc

/*
 * Display DISP registers
 */
#define DC_DISP_DISP_SIGNAL_OPTIONS0_REG		0x1000
#define DC_DISP_DISP_SIGNAL_OPTIONS0_M1_ENABLE		__BIT(26)
#define DC_DISP_DISP_SIGNAL_OPTIONS0_M0_ENABLE		__BIT(24)
#define DC_DISP_DISP_SIGNAL_OPTIONS0_V_PULSE3_ENABLE	__BIT(20)
#define DC_DISP_DISP_SIGNAL_OPTIONS0_V_PULSE2_ENABLE	__BIT(19)
#define DC_DISP_DISP_SIGNAL_OPTIONS0_V_PULSE1_ENABLE	__BIT(18)
#define DC_DISP_DISP_SIGNAL_OPTIONS0_V_PULSE0_ENABLE	__BIT(16)
#define DC_DISP_DISP_SIGNAL_OPTIONS0_H_PULSE2_ENABLE	__BIT(12)
#define DC_DISP_DISP_SIGNAL_OPTIONS0_H_PULSE1_ENABLE	__BIT(10)
#define DC_DISP_DISP_SIGNAL_OPTIONS0_H_PULSE0_ENABLE	__BIT(8)

#define DC_DISP_DISP_WIN_OPTIONS_REG			0x1008
#define DC_DISP_DISP_WIN_OPTIONS_HDMI_ENABLE		__BIT(30)
#define DC_DISP_DISP_WIN_OPTIONS_DSI_ENABLE		__BIT(29)
#define DC_DISP_DISP_WIN_OPTIONS_SOR_ENABLE		__BIT(25)
#define DC_DISP_DISP_WIN_OPTIONS_CURSOR_ENABLE		__BIT(16)

#define DC_DISP_DISP_TIMING_OPTIONS_REG			0x1014
#define DC_DISP_DISP_TIMING_OPTIONS_VSYNC_POS		__BITS(11,0)

#define DC_DISP_REF_TO_SYNC_REG				0x1018
#define DC_DISP_REF_TO_SYNC_V				__BITS(28,16)
#define DC_DISP_REF_TO_SYNC_H				__BITS(12,0)

#define DC_DISP_SYNC_WIDTH_REG				0x101c
#define DC_DISP_SYNC_WIDTH_V				__BITS(28,16)
#define DC_DISP_SYNC_WIDTH_H				__BITS(12,0)

#define DC_DISP_BACK_PORCH_REG				0x1020
#define DC_DISP_BACK_PORCH_V				__BITS(28,16)
#define DC_DISP_BACK_PORCH_H				__BITS(12,0)

#define DC_DISP_DISP_ACTIVE_REG				0x1024
#define DC_DISP_DISP_ACTIVE_V				__BITS(28,16)
#define DC_DISP_DISP_ACTIVE_H				__BITS(12,0)

#define DC_DISP_FRONT_PORCH_REG				0x1028
#define DC_DISP_FRONT_PORCH_V				__BITS(28,16)
#define DC_DISP_FRONT_PORCH_H				__BITS(12,0)

#define DC_DISP_H_PULSE0_CONTROL_REG			0x102c
#define DC_DISP_H_PULSE0_POSITION_A_REG			0x1030
#define DC_DISP_H_PULSE0_POSITION_B_REG			0x1034
#define DC_DISP_H_PULSE0_POSITION_C_REG			0x1038
#define DC_DISP_H_PULSE0_POSITION_D_REG			0x103c
#define DC_DISP_H_PULSE1_CONTROL_REG			0x1040
#define DC_DISP_H_PULSE1_POSITION_A_REG			0x1044
#define DC_DISP_H_PULSE1_POSITION_B_REG			0x1048
#define DC_DISP_H_PULSE1_POSITION_C_REG			0x104c
#define DC_DISP_H_PULSE1_POSITION_D_REG			0x1050

#define DC_DISP_H_PULSE2_CONTROL_REG			0x1054
#define DC_DISP_H_PULSE2_CONTROL_LAST			__BITS(11,8)
#define DC_DISP_H_PULSE2_CONTROL_LAST_END_A		1
#define DC_DISP_H_PULSE2_CONTROL_V_QUAL			__BITS(7,6)
#define DC_DISP_H_PULSE2_CONTROL_V_QUAL_VACTIVE		2
#define DC_DISP_H_PULSE2_CONTROL_POLARITY		__BIT(4)
#define DC_DISP_H_PULSE2_CONTROL_MODE			__BIT(3)

#define DC_DISP_H_PULSE2_POSITION_A_REG			0x1058
#define DC_DISP_H_PULSE2_POSITION_A_END			__BITS(28,16)
#define DC_DISP_H_PULSE2_POSITION_A_START		__BITS(12,0)

#define DC_DISP_H_PULSE2_POSITION_B_REG			0x105c
#define DC_DISP_H_PULSE2_POSITION_C_REG			0x1060
#define DC_DISP_H_PULSE2_POSITION_D_REG			0x1064
#define DC_DISP_V_PULSE0_CONTROL_REG			0x1068
#define DC_DISP_V_PULSE0_POSITION_A_REG			0x106c
#define DC_DISP_V_PULSE0_POSITION_B_REG			0x1070
#define DC_DISP_V_PULSE0_POSITION_C_REG			0x1074
#define DC_DISP_V_PULSE1_CONTROL_REG			0x1078
#define DC_DISP_V_PULSE1_POSITION_A_REG			0x107c
#define DC_DISP_V_PULSE1_POSITION_B_REG			0x1080
#define DC_DISP_V_PULSE1_POSITION_C_REG			0x1084
#define DC_DISP_V_PULSE2_CONTROL_REG			0x1088
#define DC_DISP_V_PULSE2_POSITION_A_REG			0x108c
#define DC_DISP_V_PULSE3_CONTROL_REG			0x1090
#define DC_DISP_V_PULSE3_POSITION_A_REG			0x1094

#define DC_DISP_DISP_CLOCK_CONTROL_REG			0x10b8
#define DC_DISP_DISP_CLOCK_CONTROL_PIXEL_CLK_DIVIDER	__BITS(11,8)
#define DC_DISP_DISP_CLOCK_CONTROL_SHIFT_CLK_DIVIDER	__BITS(7,0)

#define DC_DISP_DISP_INTERFACE_CONTROL_REG		0x10bc

#define DC_DISP_DISP_COLOR_CONTROL_REG			0x10c0
#define DC_DISP_DISP_COLOR_CONTROL_BASE_COLOR_SIZE	__BITS(3,0)
#define DC_DISP_DISP_COLOR_CONTROL_BASE_COLOR_SIZE_888	8

#define DC_DISP_COLOR_KEY0_LOWER_REG			0x10d8
#define DC_DISP_COLOR_KEY0_UPPER_REG			0x10dc
#define DC_DISP_COLOR_KEY1_LOWER_REG			0x10e0
#define DC_DISP_COLOR_KEY1_UPPER_REG			0x10e4
#define DC_DISP_CURSOR_FOREGROUND_REG			0x10f0
#define DC_DISP_CURSOR_BACKGROUND_REG			0x10f4

#define DC_DISP_CURSOR_START_ADDR_REG			0x10f8
#define DC_DISP_CURSOR_START_ADDR_CLIPPING		__BITS(29,28)
#define DC_DISP_CURSOR_START_ADDR_CLIPPING_DISPLAY	0
#define DC_DISP_CURSOR_START_ADDR_CLIPPING_WA		1
#define DC_DISP_CURSOR_START_ADDR_CLIPPING_WB		2
#define DC_DISP_CURSOR_START_ADDR_CLIPPING_WC		3
#define DC_DISP_CURSOR_START_ADDR_SIZE			__BITS(25,24)
#define DC_DISP_CURSOR_START_ADDR_SIZE_32		0
#define DC_DISP_CURSOR_START_ADDR_SIZE_64		1
#define DC_DISP_CURSOR_START_ADDR_SIZE_128		2
#define DC_DISP_CURSOR_START_ADDR_SIZE_256		3
#define DC_DISP_CURSOR_START_ADDR_ADDRESS_LO		__BITS(21,0)

#define DC_DISP_CURSOR_START_ADDR_NS_REG		0x10fc

#define DC_DISP_CURSOR_POSITION_REG			0x1100
#define DC_DISP_CURSOR_POSITION_V			__BITS(29,16)
#define DC_DISP_CURSOR_POSITION_H			__BITS(13,0)

#define DC_DISP_CURSOR_POSITION_NS_REG			0x1104
#define DC_DISP_DC_MCCIF_FIFOCTRL_REG			0x1200
#define DC_DISP_MCCIF_DISPLAY0A_HYST_REG		0x1204
#define DC_DISP_MCCIF_DISPLAY0B_HYST_REG		0x1208
#define DC_DISP_MCCIF_DISPLAY0C_HYST_REG		0x120c
#define DC_DISP_DISP_MISC_CONTROL_REG			0x1304
#define DC_DISP_SD_CONTROL_REG				0x1308
#define DC_DISP_SD_CSC_COEFF_REG			0x130c
#define DC_DISP_SD_LUT_REG				0x1310
#define DC_DISP_SD_FLICKER_CONTROL_REG			0x1334
#define DC_DISP_SD_PIXEL_COUNT_REG			0x1338
#define DC_DISP_SD_HISTOGRAM_REG			0x133c
#define DC_DISP_SD_BL_PARAMETERS_REG			0x135c
#define DC_DISP_SD_BL_TF_REG				0x1360
#define DC_DISP_SD_BL_CONTROL_REG			0x1370
#define DC_DISP_SD_HW_K_VALUES_REG			0x1374
#define DC_DISP_SD_MAN_K_VALUES_REG			0x1378
#define DC_DISP_SD_K_LIMIT_REG				0x137c
#define DC_DISP_SD_WINDOW_POSITION_REG			0x1380
#define DC_DISP_SD_WINDOW_SIZE_REG			0x1384
#define DC_DISP_SD_SOFT_CLIPPING_REG			0x1388
#define DC_DISP_SD_SMOOTH_K_REG				0x138c
#define DC_DISP_BLEND_BACKGROUND_COLOR_REG		0x1390
#define DC_DISP_INTERLACE_CONTROL_REG			0x1394
#define DC_DISP_INTERLACE_FIELD2_REF_TO_SYNC_REG	0x1398
#define DC_DISP_INTERLACE_FIELD2_SYNC_WIDTH_REG		0x139c
#define DC_DISP_INTERLACE_FIELD2_BACK_PORCH_REG		0x13a0
#define DC_DISP_INTERLACE_FIELD2_FRONT_PORCH_REG	0x13a4
#define DC_DISP_INTERLACE_FIELD2_DISP_ACTIVE_REG	0x13a8
#define DC_DISP_CURSOR_UNDERFLOW_CTRL_REG		0x13ac
#define DC_DISP_CURSOR_START_ADDR_HI_REG		0x13b0
#define DC_DISP_CURSOR_START_ADDR_HI_NS_REG		0x13b4
#define DC_DISP_CURSOR_INTERLACE_CONTROL_REG		0x13b8
#define DC_DISP_CSC2_CONTROL_REG			0x13bc

#define DC_DISP_BLEND_CURSOR_CONTROL_REG		0x13c4
#define DC_DISP_BLEND_CURSOR_CONTROL_MODE_SEL		__BIT(24)
#define DC_DISP_BLEND_CURSOR_CONTROL_DST_BLEND_FACTOR_SEL __BITS(17,16)
#define DC_DISP_BLEND_CURSOR_CONTROL_SRC_BLEND_FACTOR_SEL __BITS(9,8)
#define DC_DISP_BLEND_CURSOR_CONTROL_ALPHA		__BITS(7,0)

#define DC_DISP_DVFS_CURSOR_CONTROL_REG			0x13c8
#define DC_DISP_CURSOR_UFLOW_DBG_PIXEL_REG		0x13cc
#define DC_DISP_CURSOR_SPOOLUP_CONTROL_REG		0x13d0
#define DC_DISP_DISPLAY_CLK_GATE_OVERRIDE_REG		0x13d4
#define DC_DISP_DISPLAY_DBG_TIMING_REG			0x13d8
#define DC_DISP_DISPLAY_SPARE0_REG			0x13dc
#define DC_DISP_DISPLAY_SPARE1_REG			0x13e0

/*
 * Window A registers
 */
#define DC_WINC_A_COLOR_PALETTE_REG			0x1400
#define DC_WINC_A_PALETTE_COLOR_EXT_REG			0x1800
#define DC_WINC_A_H_FILTER_P00_REG			0x1804
#define DC_WINC_A_H_FILTER_P01_REG			0x1808
#define DC_WINC_A_H_FILTER_P02_REG			0x180c
#define DC_WINC_A_H_FILTER_P03_REG			0x1810
#define DC_WINC_A_H_FILTER_P04_REG			0x1814
#define DC_WINC_A_H_FILTER_P05_REG			0x1818
#define DC_WINC_A_H_FILTER_P06_REG			0x181c
#define DC_WINC_A_H_FILTER_P07_REG			0x1820
#define DC_WINC_A_H_FILTER_P08_REG			0x1824
#define DC_WINC_A_H_FILTER_P09_REG			0x1828
#define DC_WINC_A_H_FILTER_P0A_REG			0x182c
#define DC_WINC_A_H_FILTER_P0B_REG			0x1830
#define DC_WINC_A_H_FILTER_P0C_REG			0x1834
#define DC_WINC_A_H_FILTER_P0D_REG			0x1838
#define DC_WINC_A_H_FILTER_P0E_REG			0x183c
#define DC_WINC_A_H_FILTER_P0F_REG			0x1840
#define DC_WINC_A_CSC_YOF_REG				0x1844
#define DC_WINC_A_CSC_KYRGB_REG				0x1848
#define DC_WINC_A_CSC_KUR_REG				0x184c
#define DC_WINC_A_CSC_KVR_REG				0x1850
#define DC_WINC_A_CSC_KUG_REG				0x1854
#define DC_WINC_A_CSC_KVG_REG				0x1858
#define DC_WINC_A_CSC_KUB_REG				0x185c
#define DC_WINC_A_CSC_KVB_REG				0x1860
#define DC_WINC_A_V_FILTER_P00_REG			0x1864
#define DC_WINC_A_V_FILTER_P01_REG			0x1868
#define DC_WINC_A_V_FILTER_P02_REG			0x186c
#define DC_WINC_A_V_FILTER_P03_REG			0x1870
#define DC_WINC_A_V_FILTER_P04_REG			0x1874
#define DC_WINC_A_V_FILTER_P05_REG			0x1878
#define DC_WINC_A_V_FILTER_P06_REG			0x187c
#define DC_WINC_A_V_FILTER_P07_REG			0x1880
#define DC_WINC_A_V_FILTER_P08_REG			0x1884
#define DC_WINC_A_V_FILTER_P09_REG			0x1888
#define DC_WINC_A_V_FILTER_P0A_REG			0x188c
#define DC_WINC_A_V_FILTER_P0B_REG			0x1890
#define DC_WINC_A_V_FILTER_P0C_REG			0x1894
#define DC_WINC_A_V_FILTER_P0D_REG			0x1898
#define DC_WINC_A_V_FILTER_P0E_REG			0x189c
#define DC_WINC_A_V_FILTER_P0F_REG			0x18a0
#define DC_WINC_A_H_FILTER_HI_P00_REG			0x18a4
#define DC_WINC_A_H_FILTER_HI_P01_REG			0x18a8
#define DC_WINC_A_H_FILTER_HI_P02_REG			0x18ac
#define DC_WINC_A_H_FILTER_HI_P03_REG			0x18b0
#define DC_WINC_A_H_FILTER_HI_P04_REG			0x18b4
#define DC_WINC_A_H_FILTER_HI_P05_REG			0x18b8
#define DC_WINC_A_H_FILTER_HI_P06_REG			0x18bc
#define DC_WINC_A_H_FILTER_HI_P07_REG			0x18c0
#define DC_WINC_A_H_FILTER_HI_P08_REG			0x18c4
#define DC_WINC_A_H_FILTER_HI_P09_REG			0x18c8
#define DC_WINC_A_H_FILTER_HI_P0A_REG			0x18cc
#define DC_WINC_A_H_FILTER_HI_P0B_REG			0x18d0
#define DC_WINC_A_H_FILTER_HI_P0C_REG			0x18d4
#define DC_WINC_A_H_FILTER_HI_P0D_REG			0x18d8
#define DC_WINC_A_H_FILTER_HI_P0E_REG			0x18dc
#define DC_WINC_A_H_FILTER_HI_P0F_REG			0x18e0

#define DC_WINC_A_WIN_OPTIONS_REG			0x1c00
#define DC_WINC_A_WIN_OPTIONS_H_FILTER_MODE		__BIT(31)
#define DC_WINC_A_WIN_OPTIONS_WIN_ENABLE		__BIT(30)
#define DC_WINC_A_WIN_OPTIONS_INTERLACE_ENABLE		__BIT(23)
#define DC_WINC_A_WIN_OPTIONS_YUV_RANGE_EXPAND		__BIT(22)
#define DC_WINC_A_WIN_OPTIONS_DV_ENABLE			__BIT(20)
#define DC_WINC_A_WIN_OPTIONS_CSC_ENABLE		__BIT(18)
#define DC_WINC_A_WIN_OPTIONS_CP_ENABLE			__BIT(16)
#define DC_WINC_A_WIN_OPTIONS_V_FILTER_UV_ALIGN		__BIT(14)
#define DC_WINC_A_WIN_OPTIONS_V_FILTER_OPTIMIZE		__BIT(12)
#define DC_WINC_A_WIN_OPTIONS_V_FILTER_ENABLE		__BIT(10)
#define DC_WINC_A_WIN_OPTIONS_H_FILTER_ENABLE		__BIT(8)
#define DC_WINC_A_WIN_OPTIONS_COLOR_EXPAND		__BIT(6)
#define DC_WINC_A_WIN_OPTIONS_SCAN_COLUMN		__BIT(4)
#define DC_WINC_A_WIN_OPTIONS_V_DIRECTION		__BIT(2)
#define DC_WINC_A_WIN_OPTIONS_H_DIRECTION		__BIT(0)

#define DC_WINC_A_BYTE_SWAP_REG				0x1c04
#define DC_WINC_A_BYTE_SWAP_SWAP			__BITS(2,0)
#define DC_WINC_A_BYTE_SWAP_SWAP_NOSWAP			0

#define DC_WINC_A_COLOR_DEPTH_REG			0x1c0c
#define DC_WINC_A_COLOR_DEPTH_DEPTH			__BITS(6,0)
#define DC_WINC_A_COLOR_DEPTH_DEPTH_T_A8R8G8B8		12
#define DC_WINC_A_COLOR_DEPTH_DEPTH_T_X8R8G8B8		37

#define DC_WINC_A_POSITION_REG				0x1c10
#define DC_WINC_A_POSITION_V				__BITS(28,16)
#define DC_WINC_A_POSITION_H				__BITS(12,0)

#define DC_WINC_A_SIZE_REG				0x1c14
#define DC_WINC_A_SIZE_V				__BITS(28,16)
#define DC_WINC_A_SIZE_H				__BITS(12,0)

#define DC_WINC_A_PRESCALED_SIZE_REG			0x1c18
#define DC_WINC_A_PRESCALED_SIZE_V			__BITS(28,16)
#define DC_WINC_A_PRESCALED_SIZE_H			__BITS(14,0)

#define DC_WINC_A_H_INITIAL_DDA_REG			0x1c1c
#define DC_WINC_A_V_INITIAL_DDA_REG			0x1c20
#define DC_WINC_A_DDA_INCREMENT_REG			0x1c24

#define DC_WINC_A_LINE_STRIDE_REG			0x1c28
#define DC_WINC_A_LINE_STRIDE_UV_LINE_STRIDE		__BITS(31,16)
#define DC_WINC_A_LINE_STRIDE_LINE_STRIDE		__BITS(15,0)

#define DC_WINC_A_DV_CONTROL_REG			0x1c38
#define DC_WINC_A_BLEND_LAYER_CONTROL_REG		0x1c58
#define DC_WINC_A_BLEND_MATCH_SELECT_REG		0x1c5c
#define DC_WINC_A_BLEND_NOMATCH_SELECT_REG		0x1c60
#define DC_WINC_A_BLEND_ALPHA_1BIT_REG			0x1c64

/*
 * WINBUF_A registers
 */
#define DC_WINBUF_A_START_ADDR_REG			0x2000
#define DC_WINBUF_A_START_ADDR_NS_REG			0x2004
#define DC_WINBUF_A_START_ADDR_U_REG			0x2008
#define DC_WINBUF_A_START_ADDR_U_NS_REG			0x200c
#define DC_WINBUF_A_START_ADDR_V_REG			0x2010
#define DC_WINBUF_A_START_ADDR_V_NS_REG			0x2014
#define DC_WINBUF_A_ADDR_H_OFFSET_REG			0x2018
#define DC_WINBUF_A_ADDR_H_OFFSET_NS_REG		0x201c
#define DC_WINBUF_A_ADDR_V_OFFSET_REG			0x2020
#define DC_WINBUF_A_ADDR_V_OFFSET_NS_REG		0x2024
#define DC_WINBUF_A_UFLOW_STATUS_REG			0x2028

#define DC_WINBUF_A_SURFACE_KIND_REG			0x202c
#define DC_WINBUF_A_SURFACE_KIND_BLOCK_HEIGHT		__BITS(6,4)
#define DC_WINBUF_A_SURFACE_KIND_SURFACE_KIND		__BITS(1,0)
#define DC_WINBUF_A_SURFACE_KIND_SURFACE_KIND_PITCH	0
#define DC_WINBUF_A_SURFACE_KIND_SURFACE_KIND_TILED	1
#define DC_WINBUF_A_SURFACE_KIND_SURFACE_KIND_BL_16B2	2

#define DC_WINBUF_A_SURFACE_WEIGHT_REG			0x2030
#define DC_WINBUF_A_START_ADDR_HI_REG			0x2034
#define DC_WINBUF_A_START_ADDR_HI_NS_REG		0x2038
#define DC_WINBUF_A_START_ADDR_HI_U_REG			0x203c
#define DC_WINBUF_A_START_ADDR_HI_U_NS_REG		0x2040
#define DC_WINBUF_A_START_ADDR_HI_V_REG			0x2044
#define DC_WINBUF_A_START_ADDR_HI_V_NS_REG		0x2048
#define DC_WINBUF_A_START_ADDR_FIELD2_REG		0x204c
#define DC_WINBUF_A_START_ADDR_FIELD2_NS_REG		0x2050
#define DC_WINBUF_A_START_ADDR_FIELD2_U_REG		0x2054
#define DC_WINBUF_A_START_ADDR_FIELD2_U_NS_REG		0x2058
#define DC_WINBUF_A_START_ADDR_FIELD2_V_REG		0x205c
#define DC_WINBUF_A_START_ADDR_FIELD2_V_NS_REG		0x2060
#define DC_WINBUF_A_START_ADDR_FIELD2_HI_REG		0x2064
#define DC_WINBUF_A_START_ADDR_FIELD2_HI_NS_REG		0x2068
#define DC_WINBUF_A_START_ADDR_FIELD2_HI_U_REG		0x206c
#define DC_WINBUF_A_START_ADDR_FIELD2_HI_U_NS_REG	0x2070
#define DC_WINBUF_A_START_ADDR_FIELD2_HI_V_REG		0x2074
#define DC_WINBUF_A_START_ADDR_FIELD2_HI_V_NS_REG	0x2078
#define DC_WINBUF_A_ADDR_H_OFFSET_FIELD2_REG		0x207c
#define DC_WINBUF_A_ADDR_H_OFFSET_FIELD2_NS_REG		0x2080
#define DC_WINBUF_A_ADDR_V_OFFSET_FIELD2_REG		0x2084
#define DC_WINBUF_A_ADDR_V_OFFSET_FIELD2_NS_REG		0x2088
#define DC_WINBUF_A_UFLOW_CTRL_REG			0x2090
#define DC_WINBUF_A_UFLOW_DBG_PIXEL_REG			0x2094
#define DC_WINBUF_A_UFLOW_THRESHOLD_REG			0x2098
#define DC_WINBUF_A_SPOOL_UP_REG			0x209c
#define DC_WINBUF_A_SCALEFACTOR_THRESHOLD_REG		0x20a0
#define DC_WINBUF_A_LATENCY_THRESHOLD_REG		0x20a4
#define DC_WINBUF_A_MEMFETCH_DEBUG_STATUS_REG		0x20a8
#define DC_WINBUF_A_MEMFETCH_CONTROL_REG		0x20ac
#define DC_WINBUF_A_OCCUPANCY_THROTTLE_REG		0x20b0
#define DC_WINBUF_A_SCRATCH_REGISTER_0_REG		0x20b4
#define DC_WINBUF_A_SCRATCH_REGISTER_1_REG		0x20b8


#endif /* _ARM_TEGRA_DCREG_H */
