/*	$OpenBSD: banner.c,v 1.23 2018/10/16 20:06:42 tb Exp $	*/
/*	$NetBSD: banner.c,v 1.4 1995/04/22 11:55:15 cgd Exp $	*/

/*
 * Copyright (c) 1980, 1993, 1994
 *	The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/*
 * banner - prints large signs
 * banner [-w width] [-d] [-t] message ...
 */

#include <err.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#define MAXMSG 1024
#define DWIDTH 132
#define NCHARS 128
#define NBYTES 9085

/* Pointers into data_table for each ASCII char */
const int asc_ptr[NCHARS] = {
/* '\x00' */	   0,      0,      0,      0,      0,      0,      0,      0,
/* '\x08' */	   0,      0,      0,      0,      0,      0,      0,      0,
/* '\x10' */	   0,      0,      0,      0,      0,      0,      0,      0,
/* '\x18' */	   0,      0,      0,      0,      0,      0,      0,      0,
/*    ' ' */	   1,      2,     48,     78,    100,    276,    477,    582,
/*    '(' */	 612,    675,    738,    836,    846,    876,    880,    902,
/*    '0' */	 999,   1129,   1178,   1396,   1570,   1714,   1903,   2079,
/*    '8' */	2202,   2411,   2587,   2623,      0,   2671,      0,   2677,
/*    '@' */	2818,   3032,   3232,   3361,   3517,   3618,   3685,   3739,
/*    'H' */	3918,   3952,   3966,   4065,   4230,   4262,   4379,   4494,
/*    'P' */	4654,   4734,   4942,   5130,   5338,   5388,   5513,   5646,
/*    'X' */	5827,   6040,   6190,      0,      0,      0,      0,      0,
/*    '`' */	  48,   6435,   6573,   6663,   6765,   6857,   6999,   7082,
/*    'h' */	7304,   7375,   7421,   7505,   7609,   7621,   7715,   7786,
/*    'p' */	7894,   7984,   8074,   8135,   8293,   8353,   8418,   8514,
/*    'x' */	8640,   8795,   8922,      0,      0,      0,      0,      0,
};

/*
 * Table of stuff to print. Format:
 * 128+n -> print current line n times.
 * 192+n -> print current line n times, and this is last byte of char.
 * else, put m chars at position n (where m
 * is the next elt in array) and goto second
 * next element in array.
 */
const char data_table[NBYTES] = {
	129,
/*    1 ' ' */
	227,
/*    2 '!' */
	 34,    6,   90,   19,  129,   32,   10,   74,   40,  129,
	 31,   12,   64,   53,  129,   30,   14,   54,   65,  129,
	 30,   14,   53,   67,  129,   30,   14,   54,   65,  129,
	 31,   12,   64,   53,  129,   32,   10,   74,   40,  129,
	 34,    6,   90,   19,  129,  194,
/*   48 '"' '`' */
	 99,    9,  129,   97,   14,  129,   96,   18,  129,   95,
	 22,  129,   95,   16,  117,    2,  129,   95,   14,  129,
	 96,   11,  129,   97,    9,  129,   99,    6,  129,  194,
/*   78 '#' */
	 87,    4,  101,    4,  131,   82,   28,  131,   87,    4,
	101,    4,  133,   82,   28,  131,   87,    4,  101,    4,
	131,  193,
/*  100 '$' */
	 39,    1,   84,   27,  129,   38,    3,   81,   32,  129,
	 37,    5,   79,   35,  129,   36,    5,   77,   38,  129,
	 35,    5,   76,   40,  129,   34,    5,   75,   21,  103,
	 14,  129,   33,    5,   74,   19,  107,   11,  129,   32,
	  5,   73,   17,  110,    9,  129,   32,    4,   73,   16,
	112,    7,  129,   31,    4,   72,   15,  114,    6,  129,
	 31,    4,   72,   14,  115,    5,  129,   30,    4,   71,
	 15,  116,    5,  129,   27,   97,  131,   30,    4,   69,
	 14,  117,    4,  129,   30,    4,   68,   15,  117,    4,
	132,   30,    4,   68,   14,  117,    4,  129,   27,   97,
	131,   30,    5,   65,   15,  116,    5,  129,   31,    4,
	 65,   14,  116,    4,  129,   31,    6,   64,   15,  116,
	  4,  129,   32,    7,   62,   16,  115,    4,  129,   32,
	  9,   61,   17,  114,    5,  129,   33,   11,   58,   19,
	113,    5,  129,   34,   14,   55,   21,  112,    5,  129,
	 35,   40,  111,    5,  129,   36,   38,  110,    5,  129,
	 37,   35,  109,    5,  129,   38,   32,  110,    3,  129,
	 40,   27,  111,    1,  129,  193,
/*  276 '%' */
	 30,    4,  103,    9,  129,   30,    7,  100,   15,  129,
	 30,   10,   99,   17,  129,   33,   10,   97,    6,  112,
	  6,  129,   36,   10,   96,    5,  114,    5,  129,   39,
	 10,   96,    4,  115,    4,  129,   42,   10,   95,    4,
	116,    4,  129,   45,   10,   95,    3,  117,    3,  129,
	 48,   10,   95,    3,  117,    3,  129,   51,   10,   95,
	  4,  116,    4,  129,   54,   10,   96,    4,  115,    4,
	129,   57,   10,   96,    5,  114,    5,  129,   60,   10,
	 97,    6,  112,    6,  129,   63,   10,   99,   17,  129,
	 66,   10,  100,   15,  129,   69,   10,  103,    9,  129,
	 39,    9,   72,   10,  129,   36,   15,   75,   10,  129,
	 35,   17,   78,   10,  129,   33,    6,   48,    6,   81,
	 10,  129,   32,    5,   50,    5,   84,   10,  129,   32,
	  4,   51,    4,   87,   10,  129,   31,    4,   52,    4,
	 90,   10,  129,   31,    3,   53,    3,   93,   10,  129,
	 31,    3,   53,    3,   96,   10,  129,   31,    4,   52,
	  4,   99,   10,  129,   32,    4,   51,    4,  102,   10,
	129,   32,    5,   50,    5,  105,   10,  129,   33,    6,
	 48,    6,  108,   10,  129,   35,   17,  111,   10,  129,
	 36,   15,  114,    7,  129,   40,    9,  118,    4,  129,
	193,
/*  477 '&' */
	 48,   18,  129,   43,   28,  129,   41,   32,  129,   39,
	 36,  129,   37,   40,  129,   35,   44,  129,   34,   46,
	129,   33,   13,   68,   13,  129,   32,    9,   73,    9,
	129,   32,    7,   75,    7,  129,   31,    6,   77,    6,
	129,   31,    5,   78,    5,  129,   30,    5,   79,    5,
	129,   20,   74,  132,   30,    4,   80,    4,  129,   31,
	  3,   79,    4,  129,   31,    4,   79,    4,  129,   32,
	  3,   78,    4,  129,   32,    4,   76,    6,  129,   33,
	  4,   74,    7,  129,   34,    4,   72,    8,  129,   35,
	  5,   72,    7,  129,   37,    5,   73,    4,  129,   39,
	  4,   74,    1,  129,  194,
/*  582 "'" */
	111,    6,  129,  109,   10,  129,  108,   12,  129,  107,
	 14,  129,   97,    2,  105,   16,  129,   99,   22,  129,
	102,   18,  129,  105,   14,  129,  108,    9,  129,  194,
/*  612 '(' */
	 63,   25,  129,   57,   37,  129,   52,   47,  129,   48,
	 55,  129,   44,   63,  129,   41,   69,  129,   38,   75,
	129,   36,   79,  129,   34,   83,  129,   33,   28,   90,
	 28,  129,   32,   23,   96,   23,  129,   32,   17,  102,
	 17,  129,   31,   13,  107,   13,  129,   30,    9,  112,
	  9,  129,   30,    5,  116,    5,  129,   30,    1,  120,
	  1,  129,  194,
/*  675 ')' */
	 30,    1,  120,    1,  129,   30,    5,  116,    5,  129,
	 30,    9,  112,    9,  129,   31,   13,  107,   13,  129,
	 32,   17,  102,   17,  129,   32,   23,   96,   23,  129,
	 33,   28,   90,   28,  129,   34,   83,  129,   36,   79,
	129,   38,   75,  129,   41,   69,  129,   44,   63,  129,
	 48,   55,  129,   52,   47,  129,   57,   37,  129,   63,
	 25,  129,  194,
/*  738 '*' */
	 80,    4,  131,   68,    2,   80,    4,   94,    2,  129,
	 66,    6,   80,    4,   92,    6,  129,   67,    7,   80,
	  4,   90,    7,  129,   69,    7,   80,    4,   88,    7,
	129,   71,    6,   80,    4,   87,    6,  129,   72,   20,
	129,   74,   16,  129,   76,   12,  129,   62,   40,  131,
	 76,   12,  129,   74,   16,  129,   72,   20,  129,   71,
	  6,   80,    4,   87,    6,  129,   69,    7,   80,    4,
	 88,    7,  129,   67,    7,   80,    4,   90,    7,  129,
	 66,    6,   80,    4,   92,    6,  129,   68,    2,   80,
	  4,   94,    2,  129,   80,    4,  130,  193,
/*  836 '+' */
	 60,    4,  139,   41,   42,  131,   60,    4,  139,  193,
/*  846 ',' */
	 34,    6,  129,   32,   10,  129,   31,   12,  129,   30,
	 14,  129,   20,    2,   28,   16,  129,   22,   22,  129,
	 24,   19,  129,   27,   15,  129,   31,    9,  129,  194,
/*  876 '-' */
	 60,    4,  152,  193,
/*  880 '.' */
	 34,    6,  129,   32,   10,  129,   31,   12,  129,   30,
	 14,  131,   31,   12,  129,   32,   10,  129,   34,    6,
	129,  194,
/*  902 '/' */
	 30,    4,  129,   30,    7,  129,   30,   10,  129,   33,
	 10,  129,   36,   10,  129,   39,   10,  129,   42,   10,
	129,   45,   10,  129,   48,   10,  129,   51,   10,  129,
	 54,   10,  129,   57,   10,  129,   60,   10,  129,   63,
	 10,  129,   66,   10,  129,   69,   10,  129,   72,   10,
	129,   75,   10,  129,   78,   10,  129,   81,   10,  129,
	 84,   10,  129,   87,   10,  129,   90,   10,  129,   93,
	 10,  129,   96,   10,  129,   99,   10,  129,  102,   10,
	129,  105,   10,  129,  108,   10,  129,  111,   10,  129,
	114,    7,  129,  117,    4,  129,  193,
/*  999 '0' */
	 60,   31,  129,   53,   45,  129,   49,   53,  129,   46,
	 59,  129,   43,   65,  129,   41,   69,  129,   39,   73,
	129,   37,   77,  129,   36,   79,  129,   35,   15,  101,
	 15,  129,   34,   11,  106,   11,  129,   33,    9,  109,
	  9,  129,   32,    7,  112,    7,  129,   31,    6,  114,
	  6,  129,   31,    5,  115,    5,  129,   30,    5,  116,
	  5,  129,   30,    4,  117,    4,  132,   30,    5,  116,
	  5,  129,   31,    5,  115,    5,  129,   31,    6,  114,
	  6,  129,   32,    7,  112,    7,  129,   33,    9,  109,
	  9,  129,   34,   11,  106,   11,  129,   35,   15,  101,
	 15,  129,   36,   79,  129,   37,   77,  129,   39,   73,
	129,   41,   69,  129,   43,   65,  129,   46,   59,  129,
	 49,   53,  129,   53,   45,  129,   60,   31,  129,  193,
/* 1129 '1' */
	 30,    4,  129,   30,    4,  100,    1,  129,   30,    4,
	100,    3,  129,   30,    4,  100,    5,  129,   30,   76,
	129,   30,   78,  129,   30,   80,  129,   30,   82,  129,
	 30,   83,  129,   30,   85,  129,   30,   87,  129,   30,
	 89,  129,   30,   91,  129,   30,    4,  132,  193,
/* 1178 '2' */
	 30,    3,  129,   30,    7,  129,   30,   10,  112,    1,
	129,   30,   13,  112,    2,  129,   30,   16,  112,    3,
	129,   30,   18,  111,    5,  129,   30,   21,  111,    6,
	129,   30,   23,  112,    6,  129,   30,   14,   47,    8,
	113,    6,  129,   30,   14,   49,    8,  114,    5,  129,
	 30,   14,   51,    8,  115,    5,  129,   30,   14,   53,
	  8,  116,    4,  129,   30,   14,   55,    8,  116,    5,
	129,   30,   14,   56,    9,  117,    4,  129,   30,   14,
	 57,    9,  117,    4,  129,   30,   14,   58,   10,  117,
	  4,  129,   30,   14,   59,   10,  117,    4,  129,   30,
	 14,   60,   11,  117,    4,  129,   30,   14,   61,   11,
	116,    5,  129,   30,   14,   62,   11,  116,    5,  129,
	 30,   14,   63,   12,  115,    6,  129,   30,   14,   64,
	 13,  114,    7,  129,   30,   14,   65,   13,  113,    8,
	129,   30,   14,   65,   15,  111,    9,  129,   30,   14,
	 66,   16,  109,   11,  129,   30,   14,   67,   17,  107,
	 12,  129,   30,   14,   68,   20,  103,   16,  129,   30,
	 14,   69,   49,  129,   30,   14,   70,   47,  129,   30,
	 14,   71,   45,  129,   30,   14,   73,   42,  129,   30,
	 15,   75,   38,  129,   33,   12,   77,   34,  129,   36,
	 10,   79,   30,  129,   40,    6,   82,   23,  129,   44,
	  3,   86,   15,  129,   47,    1,  129,  193,
/* 1396 '3' */
	129,   38,    3,  129,   37,    5,  111,    1,  129,   36,
	  7,  111,    2,  129,   35,    9,  110,    5,  129,   34,
	  8,  110,    6,  129,   33,    7,  109,    8,  129,   32,
	  7,  110,    8,  129,   32,    6,  112,    7,  129,   31,
	  6,  113,    6,  129,   31,    5,  114,    6,  129,   30,
	  5,  115,    5,  129,   30,    5,  116,    4,  129,   30,
	  4,  117,    4,  132,   30,    4,   79,    2,  117,    4,
	129,   30,    5,   78,    4,  117,    4,  129,   30,    5,
	 77,    6,  116,    5,  129,   30,    6,   76,    8,  115,
	  6,  129,   30,    7,   75,   11,  114,    6,  129,   30,
	  8,   73,   15,  112,    8,  129,   31,    9,   71,   19,
	110,    9,  129,   31,   11,   68,   26,  107,   12,  129,
	 32,   13,   65,   14,   82,   36,  129,   32,   16,   61,
	 17,   83,   34,  129,   33,   44,   84,   32,  129,   34,
	 42,   85,   30,  129,   35,   40,   87,   27,  129,   36,
	 38,   89,   23,  129,   38,   34,   92,   17,  129,   40,
	 30,   95,   11,  129,   42,   26,  129,   45,   20,  129,
	 49,   11,  129,  193,
/* 1570 '4' */
	 49,    1,  129,   49,    4,  129,   49,    6,  129,   49,
	  8,  129,   49,   10,  129,   49,   12,  129,   49,   14,
	129,   49,   17,  129,   49,   19,  129,   49,   21,  129,
	 49,   23,  129,   49,   14,   65,    9,  129,   49,   14,
	 67,    9,  129,   49,   14,   69,    9,  129,   49,   14,
	 71,   10,  129,   49,   14,   74,    9,  129,   49,   14,
	 76,    9,  129,   49,   14,   78,    9,  129,   49,   14,
	 80,    9,  129,   49,   14,   82,    9,  129,   49,   14,
	 84,    9,  129,   30,    4,   49,   14,   86,   10,  129,
	 30,    4,   49,   14,   89,    9,  129,   30,    4,   49,
	 14,   91,    9,  129,   30,    4,   49,   14,   93,    9,
	129,   30,   74,  129,   30,   76,  129,   30,   78,  129,
	 30,   81,  129,   30,   83,  129,   30,   85,  129,   30,
	 87,  129,   30,   89,  129,   30,   91,  129,   30,    4,
	 49,   14,  132,  193,
/* 1714 '5' */
	 37,    1,  129,   36,    3,   77,    3,  129,   35,    5,
	 78,   11,  129,   34,    7,   78,   21,  129,   33,    7,
	 79,   29,  129,   32,    7,   79,   38,  129,   32,    6,
	 80,    4,   92,   29,  129,   31,    6,   80,    5,  102,
	 19,  129,   31,    5,   80,    6,  107,   14,  129,   31,
	  4,   81,    5,  107,   14,  129,   30,    5,   81,    6,
	107,   14,  129,   30,    4,   81,    6,  107,   14,  130,
	 30,    4,   81,    7,  107,   14,  129,   30,    4,   80,
	  8,  107,   14,  130,   30,    5,   80,    8,  107,   14,
	129,   30,    5,   79,    9,  107,   14,  129,   31,    5,
	 79,    9,  107,   14,  129,   31,    6,   78,   10,  107,
	 14,  129,   32,    6,   76,   11,  107,   14,  129,   32,
	  8,   74,   13,  107,   14,  129,   33,   10,   71,   16,
	107,   14,  129,   33,   15,   67,   19,  107,   14,  129,
	 34,   51,  107,   14,  129,   35,   49,  107,   14,  129,
	 36,   47,  107,   14,  129,   37,   45,  107,   14,  129,
	 39,   41,  107,   14,  129,   41,   37,  107,   14,  129,
	 44,   32,  107,   14,  129,   47,   25,  111,   10,  129,
	 51,   16,  115,    6,  129,  119,    2,  129,  193,
/* 1903 '6' */
	 56,   39,  129,   51,   49,  129,   47,   57,  129,   44,
	 63,  129,   42,   67,  129,   40,   71,  129,   38,   75,
	129,   37,   77,  129,   35,   81,  129,   34,   16,   74,
	  5,  101,   16,  129,   33,   11,   76,    5,  107,   11,
	129,   32,    9,   77,    5,  110,    9,  129,   32,    7,
	 79,    4,  112,    7,  129,   31,    6,   80,    4,  114,
	  6,  129,   31,    5,   81,    4,  115,    5,  129,   30,
	  5,   82,    4,  116,    5,  129,   30,    4,   82,    4,
	116,    5,  129,   30,    4,   82,    5,  117,    4,  131,
	 30,    5,   82,    5,  117,    4,  129,   31,    5,   81,
	  6,  117,    4,  129,   31,    6,   80,    7,  117,    4,
	129,   32,    7,   79,    8,  117,    4,  129,   32,    9,
	 77,    9,  116,    5,  129,   33,   11,   75,   11,  116,
	  4,  129,   34,   16,   69,   16,  115,    5,  129,   35,
	 49,  114,    5,  129,   37,   46,  113,    5,  129,   38,
	 44,  112,    6,  129,   40,   41,  112,    5,  129,   42,
	 37,  113,    3,  129,   44,   33,  114,    1,  129,   47,
	 27,  129,   51,   17,  129,  193,
/* 2079 '7' */
	103,    2,  129,  103,    6,  129,  104,    9,  129,  105,
	 12,  129,  106,   15,  129,  107,   14,  135,   30,   10,
	107,   14,  129,   30,   17,  107,   14,  129,   30,   25,
	107,   14,  129,   30,   31,  107,   14,  129,   30,   37,
	107,   14,  129,   30,   42,  107,   14,  129,   30,   46,
	107,   14,  129,   30,   50,  107,   14,  129,   30,   54,
	107,   14,  129,   30,   58,  107,   14,  129,   59,   32,
	107,   14,  129,   64,   30,  107,   14,  129,   74,   23,
	107,   14,  129,   81,   18,  107,   14,  129,   86,   16,
	107,   14,  129,   91,   14,  107,   14,  129,   96,   25,
	129,  100,   21,  129,  104,   17,  129,  107,   14,  129,
	111,   10,  129,  114,    7,  129,  117,    4,  129,  120,
	  1,  129,  193,
/* 2202 '8' */
	 48,   13,  129,   44,   21,  129,   42,   26,  129,   40,
	 30,   92,   12,  129,   38,   34,   88,   20,  129,   36,
	 37,   86,   25,  129,   35,   39,   84,   29,  129,   34,
	 13,   63,   12,   82,   33,  129,   33,   11,   67,    9,
	 80,   36,  129,   32,    9,   70,    7,   79,   38,  129,
	 31,    8,   72,   46,  129,   30,    7,   74,   22,  108,
	 11,  129,   30,    6,   75,   19,  111,    9,  129,   30,
	  5,   75,   17,  113,    7,  129,   30,    5,   74,   16,
	114,    6,  129,   30,    4,   73,   16,  115,    6,  129,
	 30,    4,   72,   16,  116,    5,  129,   30,    4,   72,
	 15,  117,    4,  129,   30,    4,   71,   16,  117,    4,
	129,   30,    5,   70,   16,  117,    4,  129,   30,    5,
	 70,   15,  117,    4,  129,   30,    6,   69,   15,  116,
	  5,  129,   30,    7,   68,   17,  115,    5,  129,   30,
	  9,   67,   19,  114,    6,  129,   30,   10,   65,   22,
	113,    6,  129,   31,   12,   63,   27,  110,    9,  129,
	 32,   14,   60,   21,   84,    9,  106,   12,  129,   33,
	 47,   85,   32,  129,   34,   45,   86,   30,  129,   35,
	 43,   88,   26,  129,   36,   40,   90,   22,  129,   38,
	 36,   93,   17,  129,   40,   32,   96,   10,  129,   42,
	 28,  129,   44,   23,  129,   48,   15,  129,  193,
/* 2411 '9' */
	 83,   17,  129,   77,   27,  129,   36,    1,   74,   33,
	129,   35,    3,   72,   37,  129,   34,    5,   70,   41,
	129,   33,    6,   69,   44,  129,   33,    5,   68,   46,
	129,   32,    5,   67,   49,  129,   31,    5,   66,   17,
	101,   16,  129,   31,    5,   66,   11,  108,   10,  129,
	 30,    4,   65,    9,  110,    9,  129,   30,    4,   64,
	  8,  112,    7,  129,   30,    4,   64,    7,  114,    6,
	129,   30,    4,   64,    6,  115,    5,  129,   30,    4,
	 64,    5,  116,    5,  129,   30,    4,   64,    5,  117,
	  4,  131,   30,    4,   65,    4,  117,    4,  129,   30,
	  5,   65,    4,  116,    5,  129,   31,    5,   66,    4,
	115,    5,  129,   31,    6,   67,    4,  114,    6,  129,
	 32,    7,   68,    4,  112,    7,  129,   32,    9,   69,
	  5,  110,    9,  129,   33,   11,   70,    5,  107,   11,
	129,   34,   16,   72,    5,  101,   16,  129,   35,   81,
	129,   37,   77,  129,   38,   75,  129,   40,   71,  129,
	 42,   67,  129,   44,   63,  129,   47,   57,  129,   51,
	 49,  129,   56,   39,  129,  193,
/* 2587 ':' */
	 34,    6,   74,    6,  129,   32,   10,   72,   10,  129,
	 31,   12,   71,   12,  129,   30,   14,   70,   14,  131,
	 31,   12,   71,   12,  129,   32,   10,   72,   10,  129,
	 34,    6,   74,    6,  129,  194,
/* 2623 ';' */
	 34,    6,   74,    6,  129,   32,   10,   72,   10,  129,
	 31,   12,   71,   12,  129,   30,   14,   70,   14,  129,
	 20,    2,   28,   16,   70,   14,  129,   22,   22,   70,
	 14,  129,   24,   19,   71,   12,  129,   27,   15,   72,
	 10,  129,   31,    9,   74,    6,  129,  194,
/* 2671 '=' */
	 53,    4,   63,    4,  152,  193,
/* 2677 '?' */
	 99,    7,  129,   97,   13,  129,   96,   16,  129,   96,
	 18,  129,   96,   19,  129,   97,   19,  129,   99,    6,
	110,    7,  129,  112,    6,  129,  114,    5,  129,   34,
	  6,   57,    5,  115,    4,  129,   32,   10,   54,   12,
	116,    4,  129,   31,   12,   53,   16,  117,    3,  129,
	 30,   14,   52,   20,  117,    4,  129,   30,   14,   52,
	 23,  117,    4,  129,   30,   14,   52,   25,  117,    4,
	129,   31,   12,   52,   27,  117,    4,  129,   32,   10,
	 53,   10,   70,   11,  116,    5,  129,   34,    6,   55,
	  5,   73,   10,  115,    6,  129,   74,   11,  114,    7,
	129,   75,   12,  112,    9,  129,   76,   13,  110,   10,
	129,   77,   16,  106,   14,  129,   78,   41,  129,   80,
	 38,  129,   81,   36,  129,   82,   34,  129,   84,   30,
	129,   86,   26,  129,   88,   22,  129,   92,   14,  129,
	194,
/* 2818 '@' */
	 55,   15,  129,   50,   25,  129,   47,   32,  129,   45,
	 13,   70,   12,  129,   43,    9,   76,   10,  129,   42,
	  6,   79,    8,  129,   41,    5,   81,    7,  129,   40,
	  4,   84,    6,  129,   39,    4,   59,   12,   85,    6,
	129,   38,    4,   55,   19,   87,    5,  129,   37,    4,
	 53,   23,   88,    4,  129,   36,    4,   51,    8,   71,
	  6,   89,    4,  129,   36,    4,   51,    6,   73,    4,
	 89,    4,  129,   36,    4,   50,    6,   74,    4,   90,
	  3,  129,   35,    4,   50,    5,   75,    3,   90,    4,
	129,   35,    4,   50,    4,   75,    4,   90,    4,  131,
	 35,    4,   50,    5,   75,    4,   90,    4,  129,   36,
	  4,   51,    5,   75,    4,   90,    4,  129,   36,    4,
	 51,    6,   75,    4,   90,    4,  129,   36,    4,   53,
	 26,   90,    4,  129,   37,    4,   54,   25,   90,    4,
	129,   37,    4,   52,   27,   90,    3,  129,   38,    4,
	 52,    4,   89,    4,  129,   39,    4,   51,    4,   88,
	  4,  129,   40,    4,   50,    4,   87,    5,  129,   41,
	  4,   50,    4,   86,    5,  129,   42,    4,   50,    4,
	 85,    5,  129,   43,    3,   50,    4,   83,    6,  129,
	 44,    2,   51,    5,   80,    7,  129,   46,    1,   52,
	  6,   76,    9,  129,   54,   28,  129,   56,   23,  129,
	 60,   16,  129,  193,
/* 3032 'A' */
	 30,    4,  132,   30,    5,  129,   30,    8,  129,   30,
	 12,  129,   30,   16,  129,   30,    4,   37,   12,  129,
	 30,    4,   41,   12,  129,   30,    4,   44,   13,  129,
	 30,    4,   48,   13,  129,   52,   13,  129,   56,   12,
	129,   58,   14,  129,   58,    4,   64,   12,  129,   58,
	  4,   68,   12,  129,   58,    4,   72,   12,  129,   58,
	  4,   75,   13,  129,   58,    4,   79,   13,  129,   58,
	  4,   83,   13,  129,   58,    4,   87,   13,  129,   58,
	  4,   91,   12,  129,   58,    4,   95,   12,  129,   58,
	  4,   96,   15,  129,   58,    4,   93,   22,  129,   58,
	  4,   89,   30,  129,   58,    4,   85,   36,  129,   58,
	  4,   81,   38,  129,   58,    4,   77,   38,  129,   58,
	  4,   73,   38,  129,   58,    4,   70,   37,  129,   58,
	  4,   66,   37,  129,   58,   41,  129,   58,   37,  129,
	 54,   38,  129,   30,    4,   50,   38,  129,   30,    4,
	 46,   38,  129,   30,    4,   42,   38,  129,   30,    4,
	 38,   39,  129,   30,   43,  129,   30,   39,  129,   30,
	 35,  129,   30,   31,  129,   30,   27,  129,   30,   24,
	129,   30,   20,  129,   30,   16,  129,   30,   12,  129,
	 30,    8,  129,   30,    5,  129,   30,    4,  132,  193,
/* 3232 'B' */
	 30,    4,  117,    4,  132,   30,   91,  137,   30,    4,
	 80,    4,  117,    4,  138,   30,    4,   80,    5,  116,
	  5,  129,   30,    5,   79,    6,  116,    5,  130,   30,
	  6,   78,    8,  115,    6,  129,   31,    6,   77,    9,
	115,    6,  129,   31,    7,   76,   11,  114,    6,  129,
	 31,    8,   75,   14,  112,    8,  129,   32,    8,   74,
	 16,  111,    9,  129,   32,    9,   73,   19,  109,   10,
	129,   33,   10,   71,   24,  106,   13,  129,   33,   13,
	 68,   12,   83,   35,  129,   34,   16,   64,   15,   84,
	 33,  129,   35,   43,   85,   31,  129,   36,   41,   86,
	 29,  129,   37,   39,   88,   25,  129,   38,   37,   90,
	 21,  129,   40,   33,   93,   15,  129,   42,   29,   96,
	  9,  129,   45,   24,  129,   49,   16,  129,  193,
/* 3361 'C' */
	 63,   25,  129,   57,   37,  129,   53,   45,  129,   50,
	 51,  129,   47,   57,  129,   45,   61,  129,   43,   65,
	129,   41,   69,  129,   39,   73,  129,   38,   25,   92,
	 21,  129,   36,   21,   97,   18,  129,   35,   18,  102,
	 14,  129,   34,   16,  106,   11,  129,   33,   14,  108,
	 10,  129,   32,   12,  111,    8,  129,   32,   10,  113,
	  6,  129,   31,   10,  114,    6,  129,   31,    8,  115,
	  5,  129,   30,    8,  116,    5,  129,   30,    7,  116,
	  5,  129,   30,    6,  117,    4,  130,   30,    5,  117,
	  4,  131,   31,    4,  116,    5,  129,   32,    4,  116,
	  4,  129,   32,    5,  115,    5,  129,   33,    4,  114,
	  5,  129,   34,    4,  112,    6,  129,   35,    4,  110,
	  7,  129,   37,    4,  107,    9,  129,   39,    4,  103,
	 12,  129,   41,    4,  103,   18,  129,   43,    4,  103,
	 18,  129,   45,    5,  103,   18,  129,   48,    5,  103,
	 18,  129,   51,    1,  129,  193,
/* 3517 'D' */
	 30,    4,  117,    4,  132,   30,   91,  137,   30,    4,
	117,    4,  135,   30,    5,  116,    5,  130,   30,    6,
	115,    6,  130,   31,    6,  114,    6,  129,   31,    7,
	113,    7,  129,   32,    7,  112,    7,  129,   32,    8,
	111,    8,  129,   33,    9,  109,    9,  129,   33,   12,
	106,   12,  129,   34,   13,  104,   13,  129,   35,   15,
	101,   15,  129,   36,   19,   96,   19,  129,   37,   24,
	 90,   24,  129,   39,   73,  129,   40,   71,  129,   42,
	 67,  129,   44,   63,  129,   46,   59,  129,   49,   53,
	129,   52,   47,  129,   56,   39,  129,   61,   29,  129,
	193,
/* 3618 'E' */
	 30,    4,  117,    4,  132,   30,   91,  137,   30,    4,
	 80,    4,  117,    4,  140,   30,    4,   79,    6,  117,
	  4,  129,   30,    4,   77,   10,  117,    4,  129,   30,
	  4,   73,   18,  117,    4,  132,   30,    4,  117,    4,
	130,   30,    5,  116,    5,  130,   30,    7,  114,    7,
	129,   30,    8,  113,    8,  129,   30,   11,  110,   11,
	129,   30,   18,  103,   18,  132,  193,
/* 3685 'F' */
	 30,    4,  117,    4,  132,   30,   91,  137,   30,    4,
	 80,    4,  117,    4,  132,   80,    4,  117,    4,  136,
	 79,    6,  117,    4,  129,   77,   10,  117,    4,  129,
	 73,   18,  117,    4,  132,  117,    4,  130,  116,    5,
	130,  114,    7,  129,  113,    8,  129,  110,   11,  129,
	103,   18,  132,  193,
/* 3739 'G' */
	 63,   25,  129,   57,   37,  129,   53,   45,  129,   50,
	 51,  129,   47,   57,  129,   45,   61,  129,   43,   65,
	129,   41,   69,  129,   39,   73,  129,   38,   25,   92,
	 21,  129,   36,   21,   97,   18,  129,   35,   18,  102,
	 14,  129,   34,   16,  106,   11,  129,   33,   14,  108,
	 10,  129,   32,   12,  111,    8,  129,   32,   10,  113,
	  6,  129,   31,   10,  114,    6,  129,   31,    8,  115,
	  5,  129,   30,    8,  116,    5,  129,   30,    7,  116,
	  5,  129,   30,    6,  117,    4,  130,   30,    5,  117,
	  4,  131,   30,    5,   75,    4,  116,    5,  129,   31,
	  5,   75,    4,  116,    4,  129,   31,    6,   75,    4,
	115,    5,  129,   32,    7,   75,    4,  114,    5,  129,
	 32,    9,   75,    4,  112,    6,  129,   33,   11,   75,
	  4,  110,    7,  129,   34,   15,   75,    4,  107,    9,
	129,   35,   44,  103,   12,  129,   36,   43,  103,   18,
	129,   38,   41,  103,   18,  129,   39,   40,  103,   18,
	129,   41,   38,  103,   18,  129,   44,   35,  129,   48,
	 31,  129,   52,   27,  129,   61,   18,  129,  193,
/* 3918 'H' */
	 30,    4,  117,    4,  132,   30,   91,  137,   30,    4,
	 80,    4,  117,    4,  132,   80,    4,  140,   30,    4,
	 80,    4,  117,    4,  132,   30,   91,  137,   30,    4,
	117,    4,  132,  193,
/* 3952 'I' */
	 30,    4,  117,    4,  132,   30,   91,  137,   30,    4,
	117,    4,  132,  193,
/* 3966 'J' */
	 44,    7,  129,   40,   13,  129,   37,   17,  129,   35,
	 20,  129,   34,   22,  129,   33,   23,  129,   32,   24,
	129,   32,   23,  129,   31,    6,   41,   13,  129,   31,
	  5,   42,   11,  129,   30,    5,   44,    7,  129,   30,
	  4,  132,   30,    5,  130,   31,    5,  129,   31,    6,
	117,    4,  129,   31,    8,  117,    4,  129,   32,    9,
	117,    4,  129,   33,   11,  117,    4,  129,   34,   87,
	129,   35,   86,  129,   36,   85,  129,   37,   84,  129,
	 38,   83,  129,   40,   81,  129,   42,   79,  129,   45,
	 76,  129,   50,   71,  129,  117,    4,  132,  193,
/* 4065 'K' */
	 30,    4,  117,    4,  132,   30,   91,  137,   30,    4,
	 76,    8,  117,    4,  129,   30,    4,   73,   13,  117,
	  4,  129,   30,    4,   70,   18,  117,    4,  129,   30,
	  4,   67,   23,  117,    4,  129,   65,   26,  129,   62,
	 31,  129,   59,   35,  129,   56,   29,   89,    7,  129,
	 53,   29,   91,    7,  129,   50,   29,   93,    7,  129,
	 47,   29,   95,    6,  129,   30,    4,   45,   29,   96,
	  7,  129,   30,    4,   42,   29,   98,    7,  129,   30,
	  4,   39,   30,  100,    6,  129,   30,    4,   36,   30,
	101,    7,  129,   30,   33,  103,    7,  117,    4,  129,
	 30,   30,  105,    6,  117,    4,  129,   30,   27,  106,
	  7,  117,    4,  129,   30,   25,  108,    7,  117,    4,
	129,   30,   22,  110,   11,  129,   30,   19,  111,   10,
	129,   30,   16,  113,    8,  129,   30,   13,  115,    6,
	129,   30,   11,  116,    5,  129,   30,    8,  117,    4,
	129,   30,    5,  117,    4,  129,   30,    4,  117,    4,
	130,   30,    4,  130,  193,
/* 4230 'L' */
	 30,    4,  117,    4,  132,   30,   91,  137,   30,    4,
	117,    4,  132,   30,    4,  144,   30,    5,  130,   30,
	  7,  129,   30,    8,  129,   30,   11,  129,   30,   18,
	132,  193,
/* 4262 'M' */
	 30,    4,  117,    4,  132,   30,   91,  132,   30,    4,
	103,   18,  129,   30,    4,   97,   24,  129,   30,    4,
	 92,   29,  129,   30,    4,   87,   34,  129,   81,   40,
	129,   76,   45,  129,   70,   49,  129,   65,   49,  129,
	 60,   49,  129,   55,   49,  129,   50,   48,  129,   44,
	 49,  129,   39,   48,  129,   33,   49,  129,   30,   47,
	129,   34,   37,  129,   40,   26,  129,   46,   19,  129,
	 52,   19,  129,   58,   19,  129,   64,   19,  129,   70,
	 19,  129,   76,   19,  129,   82,   19,  129,   30,    4,
	 88,   18,  129,   30,    4,   94,   18,  129,   30,    4,
	100,   18,  129,   30,    4,  106,   15,  129,   30,   91,
	137,   30,    4,  117,    4,  132,  193,
/* 4379 'N' */
	 30,    4,  117,    4,  132,   30,   91,  132,   30,    4,
	107,   14,  129,   30,    4,  104,   17,  129,   30,    4,
	101,   20,  129,   30,    4,   99,   22,  129,   96,   25,
	129,   93,   28,  129,   91,   28,  129,   88,   29,  129,
	 85,   29,  129,   82,   29,  129,   79,   29,  129,   76,
	 29,  129,   74,   29,  129,   71,   29,  129,   68,   29,
	129,   65,   29,  129,   62,   29,  129,   60,   29,  129,
	 57,   29,  129,   54,   29,  129,   51,   29,  129,   49,
	 28,  129,   46,   29,  129,   43,   29,  129,   40,   29,
	117,    4,  129,   37,   29,  117,    4,  129,   35,   29,
	117,    4,  129,   32,   29,  117,    4,  129,   30,   91,
	132,  117,    4,  132,  193,
/* 4494 'O' */
	 63,   25,  129,   57,   37,  129,   53,   45,  129,   50,
	 51,  129,   47,   57,  129,   45,   61,  129,   43,   65,
	129,   41,   69,  129,   39,   73,  129,   38,   21,   92,
	 21,  129,   36,   18,   97,   18,  129,   35,   14,  102,
	 14,  129,   34,   11,  106,   11,  129,   33,   10,  108,
	 10,  129,   32,    8,  111,    8,  129,   32,    6,  113,
	  6,  129,   31,    6,  114,    6,  129,   31,    5,  115,
	  5,  129,   30,    5,  116,    5,  130,   30,    4,  117,
	  4,  132,   30,    5,  116,    5,  130,   31,    5,  115,
	  5,  129,   31,    6,  114,    6,  129,   32,    6,  113,
	  6,  129,   32,    8,  111,    8,  129,   33,   10,  108,
	 10,  129,   34,   11,  106,   11,  129,   35,   14,  102,
	 14,  129,   36,   18,   97,   18,  129,   38,   21,   92,
	 21,  129,   39,   73,  129,   41,   69,  129,   43,   65,
	129,   45,   61,  129,   47,   57,  129,   50,   51,  129,
	 53,   45,  129,   57,   37,  129,   63,   25,  129,  193,
/* 4654 'P' */
	 30,    4,  117,    4,  132,   30,   91,  137,   30,    4,
	 80,    4,  117,    4,  132,   80,    4,  117,    4,  134,
	 80,    5,  116,    5,  131,   80,    6,  115,    6,  130,
	 81,    6,  114,    6,  129,   81,    8,  112,    8,  129,
	 81,    9,  111,    9,  129,   82,   10,  109,   10,  129,
	 82,   13,  106,   13,  129,   83,   35,  129,   84,   33,
	129,   85,   31,  129,   86,   29,  129,   88,   25,  129,
	 90,   21,  129,   93,   15,  129,   96,    9,  129,  193,
/* 4734 'Q' */
	 63,   25,  129,   57,   37,  129,   53,   45,  129,   50,
	 51,  129,   47,   57,  129,   45,   61,  129,   43,   65,
	129,   41,   69,  129,   39,   73,  129,   38,   21,   92,
	 21,  129,   36,   18,   97,   18,  129,   35,   14,  102,
	 14,  129,   34,   11,  106,   11,  129,   33,   10,  108,
	 10,  129,   32,    8,  111,    8,  129,   32,    6,  113,
	  6,  129,   31,    6,  114,    6,  129,   31,    5,  115,
	  5,  129,   30,    5,  116,    5,  130,   30,    4,   39,
	  2,  117,    4,  129,   30,    4,   40,    4,  117,    4,
	129,   30,    4,   41,    5,  117,    4,  129,   30,    4,
	 41,    6,  117,    4,  129,   30,    5,   40,    8,  116,
	  5,  129,   30,    5,   39,   10,  116,    5,  129,   31,
	  5,   38,   11,  115,    5,  129,   31,   18,  114,    6,
	129,   32,   17,  113,    6,  129,   32,   16,  111,    8,
	129,   33,   15,  108,   10,  129,   33,   14,  106,   11,
	129,   32,   17,  102,   14,  129,   31,   23,   97,   18,
	129,   31,   28,   92,   21,  129,   30,   82,  129,   30,
	 80,  129,   30,   11,   43,   65,  129,   30,   10,   45,
	 61,  129,   31,    8,   47,   57,  129,   32,    6,   50,
	 51,  129,   33,    5,   53,   45,  129,   35,    4,   57,
	 37,  129,   38,    2,   63,   25,  129,  193,
/* 4942 'R' */
	 30,    4,  117,    4,  132,   30,   91,  137,   30,    4,
	 76,    8,  117,    4,  129,   30,    4,   73,   11,  117,
	  4,  129,   30,    4,   70,   14,  117,    4,  129,   30,
	  4,   67,   17,  117,    4,  129,   65,   19,  117,    4,
	129,   62,   22,  117,    4,  129,   59,   25,  117,    4,
	129,   56,   28,  117,    4,  129,   53,   31,  117,    4,
	129,   50,   34,  117,    4,  129,   47,   29,   80,    5,
	116,    5,  129,   30,    4,   45,   29,   80,    5,  116,
	  5,  129,   30,    4,   42,   29,   80,    5,  116,    5,
	129,   30,    4,   39,   30,   80,    6,  115,    6,  129,
	 30,    4,   36,   30,   80,    6,  115,    6,  129,   30,
	 33,   81,    6,  114,    6,  129,   30,   30,   81,    8,
	112,    8,  129,   30,   27,   81,    9,  111,    9,  129,
	 30,   25,   82,   10,  109,   10,  129,   30,   22,   82,
	 13,  106,   13,  129,   30,   19,   83,   35,  129,   30,
	 16,   84,   33,  129,   30,   13,   85,   31,  129,   30,
	 11,   86,   29,  129,   30,    8,   88,   25,  129,   30,
	  5,   90,   21,  129,   30,    4,   93,   15,  129,   30,
	  4,   96,    9,  129,   30,    4,  130,  193,
/* 5130 'S' */
	 30,   18,  130,   30,   18,   89,   15,  129,   30,   18,
	 85,   23,  129,   34,   11,   83,   27,  129,   34,    9,
	 81,   31,  129,   33,    8,   79,   35,  129,   33,    6,
	 78,   16,  106,    9,  129,   32,    6,   77,   15,  109,
	  7,  129,   32,    5,   76,   14,  111,    6,  129,   31,
	  5,   75,   14,  113,    5,  129,   31,    4,   74,   15,
	114,    5,  129,   31,    4,   74,   14,  115,    4,  129,
	 30,    4,   73,   15,  116,    4,  129,   30,    4,   73,
	 14,  116,    4,  129,   30,    4,   73,   14,  117,    4,
	129,   30,    4,   72,   15,  117,    4,  130,   30,    4,
	 71,   15,  117,    4,  130,   30,    4,   70,   15,  117,
	  4,  129,   30,    5,   70,   15,  117,    4,  129,   30,
	  5,   69,   15,  116,    5,  129,   30,    6,   68,   16,
	115,    5,  129,   31,    6,   67,   16,  114,    6,  129,
	 31,    7,   66,   17,  113,    6,  129,   32,    7,   64,
	 18,  111,    8,  129,   32,    8,   62,   19,  109,    9,
	129,   33,    9,   60,   20,  107,   10,  129,   34,   11,
	 57,   22,  103,   13,  129,   35,   43,  103,   18,  129,
	 36,   41,  103,   18,  129,   38,   38,  103,   18,  129,
	 39,   35,  103,   18,  129,   41,   31,  129,   43,   27,
	129,   46,   22,  129,   49,   14,  129,  193,
/* 5338 'T' */
	103,   18,  132,  110,   11,  129,  113,    8,  129,  114,
	  7,  129,  116,    5,  130,  117,    4,  132,   30,    4,
	117,    4,  132,   30,   91,  137,   30,    4,  117,    4,
	132,  117,    4,  132,  116,    5,  130,  114,    7,  129,
	113,    8,  129,  110,   11,  129,  103,   18,  132,  193,
/* 5388 'U' */
	117,    4,  132,   56,   65,  129,   50,   71,  129,   46,
	 75,  129,   44,   77,  129,   42,   79,  129,   40,   81,
	129,   38,   83,  129,   36,   85,  129,   35,   86,  129,
	 34,   20,  117,    4,  129,   33,   17,  117,    4,  129,
	 32,   15,  117,    4,  129,   32,   13,  117,    4,  129,
	 31,   12,  129,   31,   10,  129,   31,    9,  129,   30,
	  9,  129,   30,    8,  130,   30,    7,  132,   31,    6,
	130,   31,    7,  129,   32,    6,  129,   32,    7,  129,
	 33,    7,  129,   34,    7,  129,   35,    8,  129,   36,
	  9,  117,    4,  129,   38,    9,  117,    4,  129,   40,
	 10,  117,    4,  129,   42,   12,  117,    4,  129,   44,
	 77,  129,   46,   75,  129,   50,   71,  129,   56,   65,
	129,  117,    4,  132,  193,
/* 5513 'V' */
	117,    4,  132,  115,    6,  129,  110,   11,  129,  105,
	 16,  129,  101,   20,  129,   96,   25,  129,   92,   29,
	129,   87,   34,  129,   83,   38,  129,   78,   43,  129,
	 74,   47,  129,   70,   42,  117,    4,  129,   65,   42,
	117,    4,  129,   60,   43,  117,    4,  129,   56,   42,
	129,   51,   42,  129,   46,   43,  129,   42,   43,  129,
	 37,   44,  129,   33,   43,  129,   30,   42,  129,   33,
	 34,  129,   38,   25,  129,   42,   16,  129,   47,   15,
	129,   52,   15,  129,   57,   15,  129,   61,   16,  129,
	 66,   16,  129,   71,   16,  129,   76,   16,  129,   80,
	 16,  129,   85,   16,  117,    4,  129,   90,   16,  117,
	  4,  129,   95,   16,  117,    4,  129,  100,   21,  129,
	105,   16,  129,  110,   11,  129,  114,    7,  129,  117,
	  4,  132,  193,
/* 5646 'W' */
	117,    4,  132,  115,    6,  129,  110,   11,  129,  105,
	 16,  129,  101,   20,  129,   96,   25,  129,   92,   29,
	129,   87,   34,  129,   83,   38,  129,   78,   43,  129,
	 74,   47,  129,   70,   42,  117,    4,  129,   65,   42,
	117,    4,  129,   60,   43,  117,    4,  129,   56,   42,
	129,   51,   42,  129,   46,   43,  129,   42,   43,  129,
	 37,   44,  129,   33,   43,  129,   30,   42,  129,   33,
	 34,  129,   38,   25,  129,   42,   16,  129,   47,   15,
	129,   52,   15,  129,   57,   15,  129,   61,   16,  129,
	 65,   17,  129,   60,   27,  129,   56,   36,  129,   51,
	 42,  129,   46,   43,  129,   42,   43,  129,   37,   44,
	129,   33,   43,  129,   30,   42,  129,   33,   34,  129,
	 38,   25,  129,   42,   16,  129,   47,   15,  129,   52,
	 15,  129,   57,   15,  129,   61,   16,  129,   66,   16,
	129,   71,   16,  129,   76,   16,  129,   80,   16,  129,
	 85,   16,  117,    4,  129,   90,   16,  117,    4,  129,
	 95,   16,  117,    4,  129,  100,   21,  129,  105,   16,
	129,  110,   11,  129,  114,    7,  129,  117,    4,  132,
	193,
/* 5827 'X' */
	 30,    4,  117,    4,  132,   30,    4,  115,    6,  129,
	 30,    4,  112,    9,  129,   30,    6,  109,   12,  129,
	 30,    9,  106,   15,  129,   30,   11,  103,   18,  129,
	 30,   14,  100,   21,  129,   30,    4,   38,    9,   98,
	 23,  129,   30,    4,   40,   10,   95,   26,  129,   30,
	  4,   43,    9,   92,   29,  129,   46,    9,   89,   32,
	129,   49,    8,   86,   28,  117,    4,  129,   51,    9,
	 83,   28,  117,    4,  129,   54,    9,   80,   28,  117,
	  4,  129,   57,    8,   77,   28,  117,    4,  129,   59,
	  9,   74,   28,  129,   62,   37,  129,   64,   33,  129,
	 66,   28,  129,   63,   28,  129,   60,   28,  129,   57,
	 28,  129,   54,   33,  129,   51,   39,  129,   48,   29,
	 83,    9,  129,   30,    4,   45,   29,   86,    9,  129,
	 30,    4,   42,   29,   89,    9,  129,   30,    4,   39,
	 29,   92,    8,  129,   30,    4,   36,   29,   94,    9,
	129,   30,   32,   97,    9,  129,   30,   29,  100,    8,
	117,    4,  129,   30,   26,  103,    8,  117,    4,  129,
	 30,   23,  105,    9,  117,    4,  129,   30,   20,  108,
	 13,  129,   30,   18,  111,   10,  129,   30,   15,  113,
	  8,  129,   30,   12,  116,    5,  129,   30,    9,  117,
	  4,  129,   30,    6,  117,    4,  129,   30,    4,  117,
	  4,  132,  193,
/* 6040 'Y' */
	117,    4,  132,  114,    7,  129,  111,   10,  129,  108,
	 13,  129,  105,   16,  129,  102,   19,  129,  100,   21,
	129,   96,   25,  129,   93,   28,  129,   90,   31,  129,
	 87,   34,  129,   84,   30,  117,    4,  129,   30,    4,
	 81,   30,  117,    4,  129,   30,    4,   78,   30,  117,
	  4,  129,   30,    4,   75,   30,  117,    4,  129,   30,
	  4,   72,   30,  129,   30,   69,  129,   30,   66,  129,
	 30,   63,  129,   30,   60,  129,   30,   57,  129,   30,
	 54,  129,   30,   51,  129,   30,   48,  129,   30,   51,
	129,   30,    4,   73,   12,  129,   30,    4,   76,   12,
	129,   30,    4,   80,   12,  129,   30,    4,   83,   12,
	129,   87,   12,  129,   90,   12,  117,    4,  129,   94,
	 11,  117,    4,  129,   97,   12,  117,    4,  129,  101,
	 12,  117,    4,  129,  104,   17,  129,  108,   13,  129,
	111,   10,  129,  115,    6,  129,  117,    4,  134,  193,
/* 6190 'Z' */
	 30,    1,  103,   18,  129,   30,    4,  103,   18,  129,
	 30,    7,  103,   18,  129,   30,    9,  103,   18,  129,
	 30,   12,  110,   11,  129,   30,   15,  113,    8,  129,
	 30,   18,  114,    7,  129,   30,   21,  116,    5,  129,
	 30,   24,  116,    5,  129,   30,   27,  117,    4,  129,
	 30,   30,  117,    4,  129,   30,   33,  117,    4,  129,
	 30,    4,   37,   28,  117,    4,  129,   30,    4,   40,
	 28,  117,    4,  129,   30,    4,   42,   29,  117,    4,
	129,   30,    4,   45,   29,  117,    4,  129,   30,    4,
	 48,   29,  117,    4,  129,   30,    4,   51,   29,  117,
	  4,  129,   30,    4,   54,   29,  117,    4,  129,   30,
	  4,   57,   29,  117,    4,  129,   30,    4,   59,   30,
	117,    4,  129,   30,    4,   62,   30,  117,    4,  129,
	 30,    4,   65,   30,  117,    4,  129,   30,    4,   68,
	 30,  117,    4,  129,   30,    4,   71,   30,  117,    4,
	129,   30,    4,   74,   30,  117,    4,  129,   30,    4,
	 77,   30,  117,    4,  129,   30,    4,   80,   30,  117,
	  4,  129,   30,    4,   83,   30,  117,    4,  129,   30,
	  4,   86,   35,  129,   30,    4,   89,   32,  129,   30,
	  4,   91,   30,  129,   30,    4,   94,   27,  129,   30,
	  5,   97,   24,  129,   30,    5,  100,   21,  129,   30,
	  7,  103,   18,  129,   30,    8,  106,   15,  129,   30,
	 11,  109,   12,  129,   30,   18,  112,    9,  129,   30,
	 18,  115,    6,  129,   30,   18,  117,    4,  129,   30,
	 18,  120,    1,  129,  193,
/* 6435 'a' */
	 42,    8,  129,   38,   16,  129,   36,   20,  129,   34,
	 24,   71,    5,  129,   33,   26,   69,   10,  129,   32,
	 28,   68,   13,  129,   31,   30,   68,   14,  129,   31,
	  9,   52,    9,   68,   15,  129,   30,    8,   54,    8,
	 69,   14,  129,   30,    7,   55,    7,   71,    4,   78,
	  6,  129,   30,    6,   56,    6,   79,    5,  129,   30,
	  6,   56,    6,   80,    4,  130,   31,    5,   56,    5,
	 80,    4,  129,   31,    5,   56,    5,   79,    5,  129,
	 32,    5,   55,    5,   78,    6,  129,   33,    5,   54,
	  5,   77,    7,  129,   34,    6,   52,    6,   74,    9,
	129,   35,   48,  129,   33,   49,  129,   32,   49,  129,
	 31,   49,  129,   30,   49,  129,   30,   47,  129,   30,
	 45,  129,   30,   41,  129,   30,    6,  129,   30,    4,
	129,   30,    3,  129,   30,    2,  129,  193,
/* 6573 'b' */
	 30,    4,  117,    4,  130,   30,   91,  136,   37,    5,
	 72,    5,  129,   35,    5,   74,    5,  129,   33,    5,
	 76,    5,  129,   32,    5,   77,    5,  129,   31,    5,
	 78,    5,  129,   31,    4,   79,    4,  129,   30,    5,
	 79,    5,  131,   30,    6,   78,    6,  129,   30,    7,
	 77,    7,  129,   31,    8,   75,    8,  129,   31,   11,
	 72,   11,  129,   32,   15,   67,   15,  129,   33,   48,
	129,   34,   46,  129,   35,   44,  129,   37,   40,  129,
	 39,   36,  129,   42,   30,  129,   46,   22,  129,  193,
/* 6663 'c' */
	 48,   18,  129,   43,   28,  129,   41,   32,  129,   39,
	 36,  129,   37,   40,  129,   35,   44,  129,   34,   46,
	129,   33,   13,   68,   13,  129,   32,    9,   73,    9,
	129,   32,    7,   75,    7,  129,   31,    6,   77,    6,
	129,   31,    5,   78,    5,  129,   30,    5,   79,    5,
	129,   30,    4,   80,    4,  133,   31,    3,   79,    4,
	129,   31,    4,   79,    4,  129,   32,    3,   78,    4,
	129,   32,    4,   76,    6,  129,   33,    4,   74,    7,
	129,   34,    4,   72,    8,  129,   35,    5,   72,    7,
	129,   37,    5,   73,    4,  129,   39,    4,   74,    1,
	129,  194,
/* 6765 'd' */
	 46,   22,  129,   42,   30,  129,   39,   36,  129,   37,
	 40,  129,   35,   44,  129,   34,   46,  129,   33,   48,
	129,   32,   15,   67,   15,  129,   31,   11,   72,   11,
	129,   31,    8,   75,    8,  129,   30,    7,   77,    7,
	129,   30,    6,   78,    6,  129,   30,    5,   79,    5,
	131,   31,    4,   79,    4,  129,   31,    5,   78,    5,
	129,   32,    5,   77,    5,  129,   33,    5,   76,    5,
	129,   35,    5,   74,    5,  117,    4,  129,   37,    5,
	 72,    5,  117,    4,  129,   30,   91,  136,   30,    4,
	130,  193,
/* 6857 'e' */
	 48,   18,  129,   43,   28,  129,   41,   32,  129,   39,
	 36,  129,   37,   40,  129,   35,   44,  129,   34,   46,
	129,   33,   13,   55,    4,   68,   13,  129,   32,    9,
	 55,    4,   73,    9,  129,   32,    7,   55,    4,   75,
	  7,  129,   31,    6,   55,    4,   77,    6,  129,   31,
	  5,   55,    4,   78,    5,  129,   30,    5,   55,    4,
	 79,    5,  129,   30,    4,   55,    4,   80,    4,  132,
	 30,    4,   55,    4,   79,    5,  129,   31,    3,   55,
	  4,   78,    5,  129,   31,    4,   55,    4,   77,    6,
	129,   32,    3,   55,    4,   75,    7,  129,   32,    4,
	 55,    4,   73,    9,  129,   33,    4,   55,    4,   68,
	 13,  129,   34,    4,   55,   25,  129,   35,    5,   55,
	 24,  129,   37,    5,   55,   22,  129,   39,    4,   55,
	 20,  129,   55,   18,  129,   55,   16,  129,   55,   11,
	129,  193,
/* 6999 'f' */
	 80,    4,  129,   30,    4,   80,    4,  130,   30,   78,
	129,   30,   82,  129,   30,   85,  129,   30,   87,  129,
	 30,   88,  129,   30,   89,  129,   30,   90,  130,   30,
	  4,   80,    4,  115,    6,  129,   30,    4,   80,    4,
	117,    4,  129,   80,    4,  105,    6,  117,    4,  129,
	 80,    4,  103,   10,  116,    5,  129,   80,    4,  102,
	 19,  129,   80,    4,  101,   19,  129,  101,   19,  129,
	101,   18,  129,  102,   16,  129,  103,   12,  129,  105,
	  6,  129,  193,
/* 7082 'g' */
	 12,   10,   59,   11,  129,    9,   16,   55,   19,  129,
	  7,   20,   53,   23,  129,    6,    7,   23,    5,   32,
	  6,   51,   27,  129,    4,    7,   25,   16,   50,   29,
	129,    3,    6,   27,   16,   49,   31,  129,    2,    6,
	 28,   16,   48,   33,  129,    1,    6,   27,   18,   47,
	 35,  129,    1,    6,   27,   31,   71,   12,  129,    1,
	  5,   26,   15,   44,   10,   75,    8,  129,    1,    5,
	 25,   14,   45,    7,   77,    7,  129,    1,    5,   25,
	 13,   45,    5,   79,    5,  129,    1,    5,   24,   14,
	 45,    4,   80,    4,  129,    1,    5,   24,   13,   45,
	  4,   80,    4,  129,    1,    5,   23,   14,   45,    4,
	 80,    4,  129,    1,    5,   23,   13,   45,    4,   80,
	  4,  129,    1,    6,   22,   13,   45,    5,   79,    5,
	129,    1,    6,   21,   14,   45,    7,   77,    7,  129,
	  1,    7,   21,   13,   46,    8,   75,    8,  129,    1,
	  8,   20,   13,   46,   12,   71,   12,  129,    1,   10,
	 18,   15,   47,   35,  129,    2,   30,   48,   33,  129,
	  3,   29,   49,   32,  129,    4,   27,   50,   31,  129,
	  5,   25,   51,   27,   80,    2,   86,    4,  129,    7,
	 21,   53,   23,   80,    3,   85,    6,  129,    9,   17,
	 55,   19,   80,   12,  129,   12,   12,   59,   11,   81,
	 11,  129,   82,   10,  129,   84,    7,  129,   86,    4,
	129,  193,
/* 7304 'h' */
	 30,    4,  117,    4,  130,   30,   91,  136,   30,    4,
	 72,    5,  129,   30,    4,   74,    5,  129,   75,    5,
	129,   76,    5,  129,   76,    6,  129,   77,    6,  130,
	 77,    7,  130,   76,    8,  129,   30,    4,   75,    9,
	129,   30,    4,   72,   12,  129,   30,   54,  129,   30,
	 53,  130,   30,   52,  129,   30,   51,  129,   30,   49,
	129,   30,   46,  129,   30,   42,  129,   30,    4,  130,
	193,
/* 7375 'i' */
	 30,    4,   80,    4,  129,   30,    4,   80,    4,  100,
	  6,  129,   30,   54,   98,   10,  129,   30,   54,   97,
	 12,  129,   30,   54,   96,   14,  131,   30,   54,   97,
	 12,  129,   30,   54,   98,   10,  129,   30,   54,  100,
	  6,  129,   30,    4,  130,  193,
/* 7421 'j' */
	  7,    6,  129,    4,   11,  129,    3,   13,  129,    2,
	 14,  129,    1,   15,  130,    1,    3,    6,    9,  129,
	  1,    3,    7,    6,  129,    1,    3,  130,    1,    4,
	129,    1,    5,   80,    4,  129,    1,    7,   80,    4,
	100,    6,  129,    2,   82,   98,   10,  129,    3,   81,
	 97,   12,  129,    4,   80,   96,   14,  129,    5,   79,
	 96,   14,  129,    7,   77,   96,   14,  129,   10,   74,
	 97,   12,  129,   14,   70,   98,   10,  129,   19,   65,
	100,    6,  129,  193,
/* 7505 'k' */
	 30,    4,  117,    4,  130,   30,   91,  136,   30,    4,
	 57,    9,  129,   30,    4,   55,   12,  129,   52,   17,
	129,   50,   20,  129,   48,   24,  129,   46,   27,  129,
	 44,   21,   69,    6,  129,   41,   22,   70,    6,   80,
	  4,  129,   30,    4,   39,   21,   72,    6,   80,    4,
	129,   30,    4,   36,   22,   73,   11,  129,   30,   26,
	 75,    9,  129,   30,   23,   76,    8,  129,   30,   21,
	 78,    6,  129,   30,   19,   79,    5,  129,   30,   16,
	 80,    4,  129,   30,   14,   80,    4,  129,   30,   12,
	129,   30,   10,  129,   30,    7,  129,   30,    5,  129,
	 30,    4,  130,  193,
/* 7609 'l' */
	 30,    4,  117,    4,  130,   30,   91,  136,   30,    4,
	130,  193,
/* 7621 'm' */
	 30,    4,   80,    4,  130,   30,   54,  136,   30,    4,
	 72,    5,  129,   30,    4,   74,    5,  129,   75,    5,
	129,   76,    5,  129,   30,    4,   75,    7,  129,   30,
	  4,   74,    9,  129,   30,   54,  132,   30,   53,  129,
	 30,   52,  129,   30,   51,  129,   30,   48,  129,   30,
	  4,   72,    5,  129,   30,    4,   74,    5,  129,   75,
	  5,  129,   76,    5,  129,   30,    4,   75,    7,  129,
	 30,    4,   74,    9,  129,   30,   54,  132,   30,   53,
	129,   30,   52,  129,   30,   51,  129,   30,   48,  129,
	 30,    4,  130,  193,
/* 7715 'n' */
	 30,    4,   80,    4,  130,   30,   54,  136,   30,    4,
	 72,    5,  129,   30,    4,   74,    5,  129,   75,    5,
	129,   76,    5,  129,   76,    6,  129,   77,    6,  130,
	 77,    7,  130,   76,    8,  129,   30,    4,   75,    9,
	129,   30,    4,   72,   12,  129,   30,   54,  129,   30,
	 53,  130,   30,   52,  129,   30,   51,  129,   30,   49,
	129,   30,   46,  129,   30,   42,  129,   30,    4,  130,
	193,
/* 7786 'o' */
	 48,   18,  129,   43,   28,  129,   41,   32,  129,   39,
	 36,  129,   37,   40,  129,   35,   44,  129,   34,   46,
	129,   33,   13,   68,   13,  129,   32,    9,   73,    9,
	129,   32,    7,   75,    7,  129,   31,    6,   77,    6,
	129,   31,    5,   78,    5,  129,   30,    5,   79,    5,
	129,   30,    4,   80,    4,  132,   30,    5,   79,    5,
	130,   31,    5,   78,    5,  129,   31,    6,   77,    6,
	129,   32,    7,   75,    7,  129,   32,    9,   73,    9,
	129,   33,   13,   68,   13,  129,   34,   46,  129,   35,
	 44,  129,   37,   40,  129,   39,   36,  129,   41,   32,
	129,   43,   28,  129,   48,   18,  129,  193,
/* 7894 'p' */
	  1,    3,   80,    4,  130,    1,   83,  137,   37,    5,
	 72,    5,  129,   35,    5,   74,    5,  129,   33,    5,
	 76,    5,  129,   32,    5,   77,    5,  129,   31,    5,
	 78,    5,  129,   31,    4,   79,    4,  129,   30,    5,
	 79,    5,  131,   30,    6,   78,    6,  129,   30,    7,
	 77,    7,  129,   31,    8,   75,    8,  129,   31,   11,
	 72,   11,  129,   32,   15,   67,   15,  129,   33,   48,
	129,   34,   46,  129,   35,   44,  129,   37,   40,  129,
	 39,   36,  129,   42,   30,  129,   46,   22,  129,  193,
/* 7984 'q' */
	 46,   22,  129,   42,   30,  129,   39,   36,  129,   37,
	 40,  129,   35,   44,  129,   34,   46,  129,   33,   48,
	129,   32,   15,   67,   15,  129,   31,   11,   72,   11,
	129,   31,    8,   75,    8,  129,   30,    7,   77,    7,
	129,   30,    6,   78,    6,  129,   30,    5,   79,    5,
	131,   31,    4,   79,    4,  129,   31,    5,   78,    5,
	129,   32,    5,   77,    5,  129,   33,    5,   76,    5,
	129,   35,    5,   74,    5,  129,   37,    5,   72,    5,
	129,    1,   83,  136,    1,    3,   80,    4,  130,  193,
/* 8074 'r' */
	 30,    4,   80,    4,  130,   30,   54,  136,   30,    4,
	 68,    6,  129,   30,    4,   70,    6,  129,   71,    7,
	129,   72,    7,  129,   73,    7,  129,   74,    7,  129,
	 74,    8,  129,   75,    8,  130,   69,   15,  129,   67,
	 17,  129,   66,   18,  129,   65,   19,  130,   65,   18,
	130,   66,   16,  129,   67,   13,  129,   69,    8,  129,
	193,
/* 8135 's' */
	 30,   13,   64,    8,  129,   30,   13,   61,   14,  129,
	 30,   13,   59,   18,  129,   30,   13,   57,   22,  129,
	 33,    8,   56,   24,  129,   32,    7,   55,   26,  129,
	 32,    6,   54,   28,  129,   31,    6,   53,   16,   77,
	  6,  129,   31,    5,   53,   14,   79,    4,  129,   30,
	  5,   52,   14,   80,    4,  129,   30,    5,   52,   13,
	 80,    4,  129,   30,    4,   52,   13,   80,    4,  129,
	 30,    4,   52,   12,   80,    4,  129,   30,    4,   51,
	 13,   80,    4,  130,   30,    4,   50,   13,   79,    5,
	129,   30,    4,   50,   13,   78,    5,  129,   30,    5,
	 49,   14,   77,    6,  129,   31,    4,   49,   13,   76,
	  6,  129,   31,    5,   48,   14,   75,    7,  129,   32,
	  5,   47,   14,   73,    8,  129,   32,    6,   45,   16,
	 71,   13,  129,   33,   27,   71,   13,  129,   34,   26,
	 71,   13,  129,   35,   24,   71,   13,  129,   37,   20,
	129,   39,   16,  129,   43,    9,  129,  193,
/* 8293 't' */
	 80,    4,  131,   41,   56,  129,   37,   60,  129,   35,
	 62,  129,   33,   64,  129,   32,   65,  129,   31,   66,
	129,   30,   67,  130,   30,   11,   80,    4,  129,   30,
	  9,   80,    4,  129,   30,    8,   80,    4,  129,   31,
	  7,   80,    4,  129,   31,    6,  129,   32,    5,  129,
	 33,    5,  129,   35,    4,  129,   38,    3,  129,  193,
/* 8353 'u' */
	 80,    4,  130,   42,   42,  129,   38,   46,  129,   35,
	 49,  129,   33,   51,  129,   32,   52,  129,   31,   53,
	130,   30,   54,  129,   30,   12,  129,   30,    9,  129,
	 30,    8,  129,   30,    7,  130,   31,    6,  130,   32,
	  6,  129,   33,    5,  129,   34,    5,  129,   35,    5,
	 80,    4,  129,   37,    5,   80,    4,  129,   30,   54,
	136,   30,    4,  130,  193,
/* 8418 'v' */
	 80,    4,  130,   77,    7,  129,   74,   10,  129,   70,
	 14,  129,   66,   18,  129,   62,   22,  129,   59,   25,
	129,   55,   29,  129,   51,   33,  129,   47,   37,  129,
	 44,   32,   80,    4,  129,   40,   32,   80,    4,  129,
	 36,   32,  129,   32,   33,  129,   30,   31,  129,   33,
	 24,  129,   36,   17,  129,   40,   12,  129,   44,   12,
	129,   48,   12,  129,   51,   13,  129,   55,   13,  129,
	 59,   13,   80,    4,  129,   63,   13,   80,    4,  129,
	 67,   17,  129,   71,   13,  129,   74,   10,  129,   78,
	  6,  129,   80,    4,  131,  193,
/* 8514 'w' */
	 80,    4,  130,   77,    7,  129,   74,   10,  129,   70,
	 14,  129,   66,   18,  129,   62,   22,  129,   59,   25,
	129,   55,   29,  129,   51,   33,  129,   47,   37,  129,
	 44,   32,   80,    4,  129,   40,   32,   80,    4,  129,
	 36,   32,  129,   32,   33,  129,   30,   31,  129,   33,
	 24,  129,   36,   17,  129,   40,   12,  129,   44,   12,
	129,   47,   13,  129,   44,   20,  129,   40,   28,  129,
	 36,   31,  129,   32,   32,  129,   30,   30,  129,   33,
	 24,  129,   36,   17,  129,   40,   12,  129,   44,   12,
	129,   48,   12,  129,   51,   13,  129,   55,   13,  129,
	 59,   13,   80,    4,  129,   63,   13,   80,    4,  129,
	 67,   17,  129,   71,   13,  129,   74,   10,  129,   78,
	  6,  129,   80,    4,  131,  193,
/* 8640 'x' */
	 30,    4,   80,    4,  130,   30,    4,   79,    5,  129,
	 30,    5,   77,    7,  129,   30,    6,   74,   10,  129,
	 30,    8,   72,   12,  129,   30,   11,   69,   15,  129,
	 30,   13,   67,   17,  129,   30,    4,   37,    8,   64,
	 20,  129,   30,    4,   39,    8,   62,   22,  129,   41,
	  8,   59,   25,  129,   43,    8,   57,   27,  129,   45,
	  8,   55,   22,   80,    4,  129,   47,   27,   80,    4,
	129,   49,   23,  129,   47,   22,  129,   44,   23,  129,
	 42,   22,  129,   30,    4,   39,   27,  129,   30,    4,
	 37,   31,  129,   30,   27,   62,    8,  129,   30,   25,
	 64,    8,  129,   30,   22,   66,    8,   80,    4,  129,
	 30,   20,   68,    8,   80,    4,  129,   30,   17,   70,
	  8,   80,    4,  129,   30,   15,   73,   11,  129,   30,
	 12,   75,    9,  129,   30,   10,   77,    7,  129,   30,
	  7,   79,    5,  129,   30,    5,   80,    4,  129,   30,
	  4,   80,    4,  130,  193,
/* 8795 'y' */
	  4,    5,   80,    4,  129,    2,    9,   80,    4,  129,
	  1,   11,   77,    7,  129,    1,   12,   74,   10,  129,
	  1,   12,   70,   14,  129,    1,   12,   66,   18,  129,
	  1,   11,   62,   22,  129,    2,    9,   59,   25,  129,
	  4,   11,   55,   29,  129,    7,   12,   51,   33,  129,
	 10,   12,   47,   37,  129,   14,   12,   44,   32,   80,
	  4,  129,   17,   13,   40,   32,   80,    4,  129,   21,
	 13,   36,   32,  129,   25,   40,  129,   29,   32,  129,
	 33,   24,  129,   36,   17,  129,   40,   12,  129,   44,
	 12,  129,   48,   12,  129,   51,   13,  129,   55,   13,
	129,   59,   13,   80,    4,  129,   63,   13,   80,    4,
	129,   67,   17,  129,   71,   13,  129,   74,   10,  129,
	 78,    6,  129,   80,    4,  131,  193,
/* 8922 'z' */
	 30,    1,   71,   13,  129,   30,    3,   71,   13,  129,
	 30,    6,   71,   13,  129,   30,    9,   75,    9,  129,
	 30,   11,   77,    7,  129,   30,   14,   79,    5,  129,
	 30,   17,   79,    5,  129,   30,   19,   80,    4,  129,
	 30,   22,   80,    4,  129,   30,   25,   80,    4,  129,
	 30,   27,   80,    4,  129,   30,    4,   36,   24,   80,
	  4,  129,   30,    4,   38,   25,   80,    4,  129,   30,
	  4,   41,   24,   80,    4,  129,   30,    4,   44,   24,
	 80,    4,  129,   30,    4,   46,   25,   80,    4,  129,
	 30,    4,   49,   25,   80,    4,  129,   30,    4,   52,
	 24,   80,    4,  129,   30,    4,   54,   30,  129,   30,
	  4,   57,   27,  129,   30,    4,   59,   25,  129,   30,
	  4,   62,   22,  129,   30,    4,   65,   19,  129,   30,
	  5,   67,   17,  129,   30,    5,   70,   14,  129,   30,
	  7,   73,   11,  129,   30,    9,   76,    8,  129,   30,
	 13,   78,    6,  129,   30,   13,   81,    3,  129,   30,
	 13,  129,  193,
};

char	line[DWIDTH];
char	message[MAXMSG];
char	print[DWIDTH];
int	debug, i, j, linen, max, nchars, pc, term, trace, x, y;
int	width = DWIDTH;	/* -w option: scrunch letters to 80 columns */

int
main(int argc, char *argv[])
{ 
	int ch;
	const char *errstr;

	if (pledge("stdio", NULL) == -1)
		err(1, "pledge");

	while ((ch = getopt(argc, argv, "w:tdh")) != -1)
		switch (ch) {
		case 'd':
			debug = 1;
			break;
		case 't':
			trace = 1;
			break;
		case 'w':
			width = strtonum(optarg, 1, DWIDTH, &errstr);
			if (errstr)
				errx(1, "width is %s: %s", errstr, optarg);
			break;
		case 'h':
		default:
			(void)fprintf(stderr,
			    "usage: %s [-w width] message ...\n",
			    getprogname());
			return 1;
		}
	argc -= optind;
	argv += optind;

	for (i = 0; i < width; i++) {
		j = i * DWIDTH / width;
		print[j] = 1;
	}

	/* Have now read in the data. Next get the message to be printed. */
	if (*argv) {
		strlcpy(message, *argv, sizeof message);
		while (*++argv) {
			strlcat(message, " ", sizeof message);
			strlcat(message, *argv, sizeof message);
		}
	} else {
		if (isatty(fileno(stdin)))
			fprintf(stderr,"Message: ");
		if (fgets(message, sizeof(message), stdin) == NULL)
			errx(1, "error reading message");
		/* get rid of newline */
		message[strcspn(message, "\n")] = '\0';
	}
	nchars = strlen(message);

	/* some debugging print statements */
	if (debug) {
		printf("int asc_ptr[128] = {\n");
		for (i = 0; i < 128; i++) {
			printf("%4d,   ",asc_ptr[i]);
			if ((i+1) % 8 == 0)
				printf("\n");
		}
		printf("};\nchar data_table[NBYTES] = {\n");
		printf("  /*   ");
		for (i = 0; i < 10; i++) printf(" %3d  ",i);
		printf("   */\n");
		for (i = 0; i < NBYTES; i += 10) {
			printf("/* %4d */  ",i);
			for (j = i; j < i+10; j++) { 
				x = data_table[j] & 0377;
				printf(" %3d, ",x);
			}
			putchar('\n');
		}
		printf("};\n");
	}

	/* check message to make sure it's legal */
	j = 0;
	for (i = 0; i < nchars; i++)
		if ((u_char) message[i] >= NCHARS ||
		    asc_ptr[(u_char) message[i]] == 0) {
			warnx("The character '%c' is not in my character set",
			    message[i]);
			j++;
		}
	if (j)
		return 1;

	if (trace)
		printf("Message '%s' is OK\n",message);
	/* Now have message. Print it one character at a time.  */

	for (i = 0; i < nchars; i++) {
		if (trace)
			printf("Char #%d: %c\n", i, message[i]);
		for (j = 0; j < DWIDTH; j++) line[j] = ' ';
		pc = asc_ptr[(u_char) message[i]];
		term = 0;
		max = 0;
		linen = 0;
		while (!term) {
			if (pc < 0 || pc >= NBYTES) {
				printf("bad pc: %d\n",pc);
				return 1;
			}
			x = data_table[pc] & 0377;
			if (trace)
				printf("pc=%d, term=%d, max=%d, linen=%d, x=%d\n",pc,term,max,linen,x);
			if (x >= 128) {
				if (x>192) term++;
				x = x & 63;
				while (x--) {
					if (print[(unsigned int) linen++ % DWIDTH]) {
						for (j=0; j < max && j < DWIDTH; j++)
							if (print[j])
								putchar(line[j]);
						putchar('\n');
					}
				}
				for (j = 0; j < DWIDTH; j++) line[j] = ' ';
				pc++;
				max = 0;
			}
			else {
				if (pc+1 < 0 || pc+1 >= NBYTES) {
					printf("bad pc: %d\n",pc+1);
					return 1;
				}
				y = data_table[pc+1];
				/* compensate for narrow teminals */
#ifdef notdef
				x = (x*width + (DWIDTH/2)) / DWIDTH;
				y = (y*width + (DWIDTH/2)) / DWIDTH;
#endif
				max = x+y;
				while (x < max && x < DWIDTH)
					line[x++] = '#';
				pc += 2;
				if (trace)
					printf("x=%d, y=%d, max=%d\n",x,y,max);
			}
		}
	}

	return 0;
}
