/*-
 * Copyright (C) 2014 Warner Losh.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $FreeBSD: stable/10/sys/dev/nand/nfc_at91.h 266087 2014-05-14 20:31:54Z ian $
 */

/*
 * Atmel at91-family integrated NAND controller driver.
 *
 * Interface to board setup code to set parameters.
 */

#ifndef	DEV_NAND_NFC_AT91_H
#define	DEV_NAND_NFC_AT91_H 1

struct at91_nand_params 
{
	uint32_t	ale;		/* Address for ALE (address) NAND cycles */
	uint32_t	cle;		/* Address for CLE (command) NAND cycles */
	uint32_t	width;		/* 8 or 16 bits (specify in bits) */
	uint32_t	cs;		/* Chip Select NAND is connected to */
	uint32_t	rnb_pin;	/* GPIO pin # for Read/notBusy */
	uint32_t	nce_pin;	/* GPIO pin # for CE (active low) */
};

void at91_enable_nand(const struct at91_nand_params *);

#endif /* DEV_NAND_NFC_AT91_H */
