#- 
# SPDX-License-Identifier: BSD-2-Clause
# 
# Copyright (c) 2019 Ian Lepore <ian@freebsd.org>
# 
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
# 
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
# ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
# OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
# LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
# OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
# SUCH DAMAGE.
#
# $FreeBSD: stable/12/sys/dev/iicbus/mux/iicmux_if.m 356278 2020-01-02 17:51:49Z ian $
#

#include <sys/bus.h>

INTERFACE iicmux;

HEADER {
	struct iic_reqbus_data;
}

#
# iicmux_bus_select(device_t dev, int busidx, struct iic_reqbus_data *rd)
#  Do whatever the mux hardware requires to connect the downstream
#  bus selected by busidx to the upstream bus.  This must return
#  an IIC adapter-layer error code; standard errno values returned
#  from this must be encoded using iic2errno().
#
METHOD int bus_select {
	device_t dev;
	int busidx;
	struct iic_reqbus_data *rd;
};
