/*-
 * Copyright (c) 2013-2015 Sandvine Inc.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $FreeBSD: stable/12/sys/dev/pci/pci_iov.h 303721 2016-08-03 17:09:12Z jhb $
 */

#ifndef _PCI_IOV_H_
#define	_PCI_IOV_H_

#include "pci_iov_if.h"

struct nvlist;

int	pci_iov_attach_name(device_t dev, struct nvlist *pf_schema,
	    struct nvlist *vf_schema, const char *fmt, ...) __printflike(4, 5);

static __inline int
pci_iov_attach(device_t dev, struct nvlist *pf_schema, struct nvlist *vf_schema)
{
	return (PCI_IOV_ATTACH(device_get_parent(dev), dev, pf_schema,
	    vf_schema, device_get_nameunit(dev)));
}

static __inline int
pci_iov_detach(device_t dev)
{
	return (PCI_IOV_DETACH(device_get_parent(dev), dev));
}

#endif /* !_PCI_IOV_H_ */
